/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import gate.Controller;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamwareUtils {
    public static final String INPUT_ANNOTATION_SETS_FEATURE = "gate.teamware.inputAnnotationSets";
    public static final String OUTPUT_ANNOTATION_SETS_FEATURE = "gate.teamware.outputAnnotationSets";

    private TeamwareUtils() {
    }

    public static Set<String> getInputAnnotationSets(Controller controller) {
        Object v = controller.getFeatures().get(INPUT_ANNOTATION_SETS_FEATURE);
        if (v != null && v instanceof Set) {
            return (Set)v;
        }
        HashSet<String> hashSet = new HashSet<String>();
        controller.getFeatures().put(INPUT_ANNOTATION_SETS_FEATURE, hashSet);
        TeamwareUtils.populateInputSetNamesForController(hashSet, controller, true);
        return hashSet;
    }

    public static Set<String> getLikelyInputAnnotationSets(Controller controller) {
        HashSet<String> hashSet = new HashSet<String>();
        TeamwareUtils.populateInputSetNamesForController(hashSet, controller, false);
        return hashSet;
    }

    private static void populateInputSetNamesForController(Set<String> set, Controller controller, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = controller.getPRs();
        try {
            for (ProcessingResource processingResource : collection) {
                ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
                for (List<Parameter> list2 : list) {
                    for (Parameter parameter : list2) {
                        if (parameter.getName().equals("inputASName")) {
                            String string = (String)processingResource.getParameterValue(parameter.getName());
                            if (bl && (string == null || hashSet.contains(string))) continue;
                            set.add(string);
                            continue;
                        }
                        if (bl || !parameter.getName().equals("annotationSetName")) continue;
                        set.add((String)processingResource.getParameterValue(parameter.getName()));
                    }
                }
                if (!bl) continue;
                for (List<Parameter> list2 : list) {
                    for (Parameter parameter : list2) {
                        if (!parameter.getName().equals("outputASName") && !parameter.getName().equals("annotationSetName")) continue;
                        hashSet.add(String.valueOf(processingResource.getParameterValue(parameter.getName())));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<String> getOutputAnnotationSets(Controller controller) {
        Object v = controller.getFeatures().get(OUTPUT_ANNOTATION_SETS_FEATURE);
        if (v != null && v instanceof Set) {
            return (Set)v;
        }
        HashSet<String> hashSet = new HashSet<String>();
        controller.getFeatures().put(OUTPUT_ANNOTATION_SETS_FEATURE, hashSet);
        TeamwareUtils.populateOutputSetNamesForController(hashSet, controller, true);
        return hashSet;
    }

    public static Set<String> getLikelyOutputAnnotationSets(Controller controller) {
        HashSet<String> hashSet = new HashSet<String>();
        TeamwareUtils.populateOutputSetNamesForController(hashSet, controller, false);
        return hashSet;
    }

    private static void populateOutputSetNamesForController(Set<String> set, Controller controller, boolean bl) {
        Collection collection = controller.getPRs();
        try {
            for (ProcessingResource processingResource : collection) {
                ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
                if (bl) {
                    for (List<Parameter> list2 : list) {
                        for (Parameter parameter : list2) {
                            if (!parameter.getName().equals("inputASName") && !parameter.getName().equals("annotationSetName")) continue;
                            set.remove(processingResource.getParameterValue(parameter.getName()));
                        }
                    }
                }
                for (List<Parameter> list2 : list) {
                    for (Parameter parameter : list2) {
                        if (!parameter.getName().equals("outputASName") && !parameter.getName().equals("annotationSetName")) continue;
                        set.add((String)processingResource.getParameterValue(parameter.getName()));
                    }
                }
            }
            if (!bl) {
                set.add(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

