/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;

class AnnotationSetNameComboEditor
implements ComboBoxEditor,
FocusListener {
    public static final String DEFAULT_SET_TEXT = "<Default annotation set>";
    private ComboBoxEditor realEditor;
    private Font normalFont;
    private Font italicFont;
    private boolean isEmpty;

    AnnotationSetNameComboEditor(ComboBoxEditor comboBoxEditor) {
        this.realEditor = comboBoxEditor;
        this.normalFont = comboBoxEditor.getEditorComponent().getFont();
        this.italicFont = this.normalFont.deriveFont(2);
        this.setItem(null, false);
        comboBoxEditor.getEditorComponent().addFocusListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.realEditor.addActionListener(actionListener);
    }

    public Component getEditorComponent() {
        return this.realEditor.getEditorComponent();
    }

    public Object getItem() {
        Object object = this.realEditor.getItem();
        if (this.isEmpty || DEFAULT_SET_TEXT.equals(object)) {
            return null;
        }
        return object;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.realEditor.removeActionListener(actionListener);
    }

    public void selectAll() {
        if (!this.isEmpty) {
            this.realEditor.selectAll();
        }
    }

    public void setItem(Object object) {
        this.setItem(object, true);
    }

    private void setItem(Object object, boolean bl) {
        if (object == null || "".equals(object)) {
            this.isEmpty = true;
            this.realEditor.getEditorComponent().setFont(this.italicFont);
            this.realEditor.setItem(DEFAULT_SET_TEXT);
        } else {
            this.isEmpty = false;
            this.realEditor.getEditorComponent().setFont(this.normalFont);
            this.realEditor.setItem(object);
        }
        if (bl) {
            if (this.realEditor.getEditorComponent().isFocusOwner()) {
                this.focusGained(null);
            } else {
                this.focusLost(null);
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isEmpty) {
            JTextField jTextField = (JTextField)this.realEditor.getEditorComponent();
            jTextField.setText("");
            jTextField.setFont(this.normalFont);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)this.realEditor.getEditorComponent();
        if (jTextField.getDocument().getLength() == 0 || DEFAULT_SET_TEXT.equals(jTextField.getText())) {
            this.setItem(null, false);
        } else {
            this.isEmpty = false;
        }
    }
}

