/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitivePropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 4049916060868227125L;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected JTextField nameSpace;
    protected JTextField propertyName;
    protected JButton domainButton;
    protected JButton rangeButton;
    protected ValuesSelectionAction domainAction;
    protected ValuesSelectionAction rangeAction;
    protected ArrayList<String> ontologyClassesURIs;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public TransitivePropertyAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Property Name:"), gridBagConstraints);
        this.propertyName = new JTextField(30);
        this.mainPanel.add((Component)this.propertyName, gridBagConstraints);
        this.domainButton = new JButton("Domain");
        this.mainPanel.add((Component)this.domainButton, gridBagConstraints);
        this.rangeButton = new JButton("Range");
        this.mainPanel.add((Component)this.rangeButton, gridBagConstraints);
        this.domainAction = new ValuesSelectionAction();
        this.domainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[TransitivePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TransitivePropertyAction.this.ontologyClassesURIs.get(i);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < TransitivePropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = TransitivePropertyAction.this.selectedNodes.get(i);
                    if (!(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource() instanceof OClass)) continue;
                    arrayList.add(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource().getURI().toString());
                }
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                TransitivePropertyAction.this.domainAction.showGUI("Domain", stringArray, stringArray2, false, MainFrame.getIcon("ontology-transitive-property"));
            }
        });
        this.rangeAction = new ValuesSelectionAction();
        this.rangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[TransitivePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TransitivePropertyAction.this.ontologyClassesURIs.get(i);
                }
                TransitivePropertyAction.this.rangeAction.showGUI("Range", stringArray, new String[0], false, MainFrame.getIcon("ontology-transitive-property"));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-transitive-property")){

            public void selectInitialValue() {
                TransitivePropertyAction.this.propertyName.requestFocusInWindow();
                TransitivePropertyAction.this.propertyName.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Transitive Property").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            Object object2;
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Property Name: " + this.propertyName.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string + this.propertyName.getText() + "</b> already exists.");
                return;
            }
            String[] stringArray = this.domainAction.getSelectedValues();
            HashSet<OClass> hashSet = new HashSet<OClass>();
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = (OClass)this.ontology.getOResourceFromMap(stringArray[i]);
                hashSet.add((OClass)object2);
            }
            String[] stringArray2 = this.rangeAction.getSelectedValues();
            object2 = new HashSet();
            for (int i = 0; i < stringArray2.length; ++i) {
                OClass oClass = (OClass)this.ontology.getOResourceFromMap(stringArray2[i]);
                ((HashSet)object2).add(oClass);
            }
            this.ontology.addTransitiveProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet, (Set<OClass>)object2);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public ArrayList<String> getOntologyClassesURIs() {
        return this.ontologyClassesURIs;
    }

    public void setOntologyClassesURIs(ArrayList<String> arrayList) {
        this.ontologyClassesURIs = arrayList;
    }
}

