/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricPropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257286915891017008L;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected JTextField nameSpace;
    protected JTextField propertyName;
    protected JButton domainRangeButton;
    protected ValuesSelectionAction domainRangeAction;
    protected ArrayList<String> ontologyClassesURIs;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public SymmetricPropertyAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Property Name:"), gridBagConstraints);
        this.propertyName = new JTextField(30);
        this.mainPanel.add((Component)this.propertyName, gridBagConstraints);
        this.domainRangeButton = new JButton("Domain and Range");
        this.mainPanel.add((Component)this.domainRangeButton, gridBagConstraints);
        this.domainRangeAction = new ValuesSelectionAction();
        this.domainRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[SymmetricPropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = SymmetricPropertyAction.this.ontologyClassesURIs.get(i);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < SymmetricPropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = SymmetricPropertyAction.this.selectedNodes.get(i);
                    if (!(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource() instanceof OClass)) continue;
                    arrayList.add(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource().getURI().toString());
                }
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                SymmetricPropertyAction.this.domainRangeAction.showGUI("Domain and Range", stringArray, stringArray2, false, MainFrame.getIcon("ontology-symmetric-property"));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-symmetric-property")){

            public void selectInitialValue() {
                SymmetricPropertyAction.this.propertyName.requestFocusInWindow();
                SymmetricPropertyAction.this.propertyName.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Symmetric Property").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid NameSpace: " + string + "\n Example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Symmetric Property Name: " + this.propertyName.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string + this.propertyName.getText() + "</b> already exists.");
                return;
            }
            String[] stringArray = this.domainRangeAction.getSelectedValues();
            HashSet<OClass> hashSet = new HashSet<OClass>();
            for (int i = 0; i < stringArray.length; ++i) {
                OClass oClass = (OClass)this.ontology.getOResourceFromMap(stringArray[i]);
                hashSet.add(oClass);
            }
            this.ontology.addSymmetricProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public ArrayList<String> getOntologyClassesURIs() {
        return this.ontologyClassesURIs;
    }

    public void setOntologyClassesURIs(ArrayList<String> arrayList) {
        this.ontologyClassesURIs = arrayList;
    }
}

