/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.Restriction;
import gate.gui.MainFrame;
import gate.gui.ontology.DetailsGroup;
import gate.gui.ontology.KeyValuePair;
import gate.gui.ontology.OntologyItemComparator;
import gate.gui.ontology.PropertyValue;
import gate.gui.ontology.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class DetailsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3834870286880618035L;
    protected DetailsGroup resourceInfo = new DetailsGroup("Resource Information", true, null);
    protected DetailsGroup directSuperClasses = new DetailsGroup("Direct Super Classes", true, null);
    protected DetailsGroup allSuperClasses = new DetailsGroup("All Super Classes", true, null);
    protected DetailsGroup directSubClasses = new DetailsGroup("Direct Sub Classes", true, null);
    protected DetailsGroup allSubClasses = new DetailsGroup("All Sub Classes", true, null);
    protected DetailsGroup equivalentClasses = new DetailsGroup("Equivalent Classes", true, null);
    protected DetailsGroup sameAsInstances = new DetailsGroup("Same Instances", true, null);
    protected DetailsGroup instances = new DetailsGroup("Instances", true, null);
    protected DetailsGroup propertyTypes = new DetailsGroup("Property Types", true, null);
    protected DetailsGroup propertyValues = new DetailsGroup("Property Values", true, null);
    protected DetailsGroup directTypes = new DetailsGroup("Direct Types", true, null);
    protected DetailsGroup allTypes = new DetailsGroup("All Types", true, null);
    protected DetailsGroup[] detailGroups = new DetailsGroup[0];
    protected Ontology ontology;
    protected OResource oResource;
    protected boolean ontologyMode = false;
    public static final int COLUMN_COUNT = 4;
    public static final int EXPANDED_COLUMN = 0;
    public static final int LABEL_COLUMN = 1;
    public static final int VALUE_COLUMN = 2;
    public static final int DELETE_COLUMN = 3;
    protected OntologyItemComparator itemComparator = new OntologyItemComparator();

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        int n = this.detailGroups.length;
        for (int i = 0; i < this.detailGroups.length; ++i) {
            if (!this.detailGroups[i].isExpanded()) continue;
            n += this.detailGroups[i].getSize();
        }
        return n;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "Value";
            }
            case 3: {
                return "Delete";
            }
        }
        return "";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 2) {
            return false;
        }
        Object object = this.getItemForRow(n);
        if (!(object instanceof PropertyValue)) {
            return false;
        }
        RDFProperty rDFProperty = ((PropertyValue)object).getProperty();
        return rDFProperty instanceof AnnotationProperty || rDFProperty instanceof DatatypeProperty;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getItemForRow(n);
        switch (n2) {
            case 0: {
                if (!(object2 instanceof DetailsGroup)) break;
                DetailsGroup detailsGroup = (DetailsGroup)object2;
                detailsGroup.setExpanded((Boolean)object);
                break;
            }
            case 2: {
                if (!(object2 instanceof PropertyValue)) break;
                PropertyValue propertyValue = (PropertyValue)object2;
                RDFProperty rDFProperty = propertyValue.getProperty();
                if (rDFProperty instanceof AnnotationProperty) {
                    this.oResource.removeAnnotationPropertyValue((AnnotationProperty)rDFProperty, (Literal)propertyValue.getValue());
                    this.oResource.addAnnotationPropertyValue((AnnotationProperty)rDFProperty, new Literal((String)object));
                    this.setItemForRow(n, new PropertyValue(rDFProperty, new Literal((String)object)));
                    break;
                }
                if (!(rDFProperty instanceof DatatypeProperty)) break;
                boolean bl = ((DatatypeProperty)rDFProperty).getDataType().isValidValue((String)object);
                if (!bl) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incompatible value: " + object + "\nUse a value of type " + ((DatatypeProperty)rDFProperty).getDataType().getXmlSchemaURIString().replaceFirst("http://www.w3.org/2001/XMLSchema#", ""));
                    return;
                }
                try {
                    ((OInstance)this.oResource).removeDatatypePropertyValue((DatatypeProperty)rDFProperty, (Literal)propertyValue.getValue());
                    ((OInstance)this.oResource).addDatatypePropertyValue((DatatypeProperty)rDFProperty, new Literal((String)object, ((DatatypeProperty)rDFProperty).getDataType()));
                    this.setItemForRow(n, new PropertyValue(rDFProperty, new Literal((String)object)));
                    break;
                }
                catch (InvalidValueException invalidValueException) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incompatible value");
                    invalidValueException.printStackTrace();
                    return;
                }
            }
        }
        this.fireTableDataChanged();
    }

    protected Object getItemForRow(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            if (n2 == n) {
                return this.detailGroups[n3];
            }
            int n4 = 1 + (this.detailGroups[n3].isExpanded() ? this.detailGroups[n3].getSize() : 0);
            if (n2 + n4 > n) {
                return this.detailGroups[n3].getValueAt(n - n2 - 1);
            }
            n2 += n4;
            ++n3;
        }
        return null;
    }

    protected void setItemForRow(int n, Object object) {
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            if (n2 == n) {
                this.detailGroups[n3].setExpanded((Boolean)object);
                return;
            }
            int n4 = 1 + (this.detailGroups[n3].isExpanded() ? this.detailGroups[n3].getSize() : 0);
            if (n2 + n4 > n) {
                this.detailGroups[n3].setValueAt(n - n2 - 1, object);
                return;
            }
            n2 += n4;
            ++n3;
        }
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.getItemForRow(n);
        switch (n2) {
            case 0: {
                return object instanceof DetailsGroup ? (((DetailsGroup)object).getSize() > 0 ? (((DetailsGroup)object).isExpanded() ? "expanded" : "closed") : "empty") : null;
            }
            case 1: {
                return object;
            }
            case 2: {
                if (object instanceof DetailsGroup) {
                    return "";
                }
                if (object instanceof PropertyValue) {
                    PropertyValue propertyValue = (PropertyValue)object;
                    if (propertyValue.getValue() instanceof Literal) {
                        return ((Literal)propertyValue.getValue()).getValue();
                    }
                    return propertyValue.getValue().toString();
                }
                if (object instanceof KeyValuePair) {
                    KeyValuePair keyValuePair = (KeyValuePair)object;
                    return keyValuePair.getValue().toString();
                }
                if (object instanceof RDFProperty) {
                    RDFProperty rDFProperty = (RDFProperty)object;
                    if (rDFProperty instanceof DatatypeProperty) {
                        return ((DatatypeProperty)rDFProperty).getDataType().getXmlSchemaURIString();
                    }
                    if (!(rDFProperty instanceof AnnotationProperty)) {
                        Set<OResource> set = rDFProperty.getRange();
                        if (set == null || set.isEmpty()) {
                            return "[ALL CLASSES]";
                        }
                        String string = "[";
                        boolean bl = true;
                        for (OResource oResource : set) {
                            if (!bl) {
                                string = string + ",";
                            } else {
                                bl = false;
                            }
                            string = string + oResource.getName();
                        }
                        string = string + "]";
                        return string;
                    }
                    return "[ALL RESOURCES]";
                }
                return object.toString();
            }
            case 3: {
                return object;
            }
        }
        return null;
    }

    public void setItem(OResource oResource) {
        this.oResource = oResource;
        if (oResource instanceof OClass) {
            this.detailGroups = new DetailsGroup[]{this.resourceInfo, this.directSuperClasses, this.allSuperClasses, this.directSubClasses, this.allSubClasses, this.equivalentClasses, this.propertyTypes, this.propertyValues, this.instances};
            OClass oClass = (OClass)oResource;
            this.resourceInfo.getValues().clear();
            if (oClass instanceof Restriction) {
                this.resourceInfo.getValues().addAll(Utils.getDetailsToAdd(oClass));
            } else {
                this.resourceInfo.getValues().add(oClass);
                this.resourceInfo.getValues().add(new KeyValuePair(oClass, "URI", oClass.getURI().toString(), false));
                this.resourceInfo.getValues().add(new KeyValuePair(oClass, "TYPE", "Ontology Class", false));
            }
            Set<OClass> set = oClass.getSuperClasses((byte)0);
            this.directSuperClasses.getValues().clear();
            this.directSuperClasses.getValues().addAll(set);
            Collections.sort(this.directSuperClasses.getValues(), this.itemComparator);
            Set<OClass> set2 = oClass.getSuperClasses((byte)1);
            this.allSuperClasses.getValues().clear();
            this.allSuperClasses.getValues().addAll(set2);
            Collections.sort(this.allSuperClasses.getValues(), this.itemComparator);
            Set<OClass> set3 = oClass.getSubClasses((byte)0);
            this.directSubClasses.getValues().clear();
            this.directSubClasses.getValues().addAll(set3);
            Collections.sort(this.directSubClasses.getValues(), this.itemComparator);
            Set<OClass> set4 = oClass.getSubClasses((byte)1);
            this.allSubClasses.getValues().clear();
            this.allSubClasses.getValues().addAll(set4);
            Collections.sort(this.allSubClasses.getValues(), this.itemComparator);
            Set<OClass> set5 = oClass.getEquivalentClasses();
            this.equivalentClasses.getValues().clear();
            this.equivalentClasses.getValues().addAll(set5);
            Collections.sort(this.equivalentClasses.getValues(), this.itemComparator);
            this.propertyTypes.getValues().clear();
            Set<RDFProperty> set6 = oClass.getPropertiesWithResourceAsDomain();
            this.propertyTypes.getValues().addAll(set6);
            Collections.sort(this.propertyTypes.getValues(), this.itemComparator);
            this.propertyValues.getValues().clear();
            Set<AnnotationProperty> set7 = oClass.getSetAnnotationProperties();
            if (set7 != null) {
                for (AnnotationProperty annotationProperty : set7) {
                    List<Literal> list = oClass.getAnnotationPropertyValues(annotationProperty);
                    for (int i = 0; i < list.size(); ++i) {
                        PropertyValue propertyValue = new PropertyValue(annotationProperty, list.get(i));
                        this.propertyValues.getValues().add(propertyValue);
                    }
                }
            }
            Set<OInstance> set8 = this.ontology.getOInstances(oClass, (byte)0);
            this.instances.getValues().clear();
            if (set8 != null) {
                this.instances.getValues().addAll(set8);
                Collections.sort(this.instances.getValues(), this.itemComparator);
            }
        } else if (oResource instanceof OInstance) {
            PropertyValue propertyValue;
            int n;
            List<Object> list;
            Object object;
            OInstance oInstance = (OInstance)oResource;
            this.detailGroups = new DetailsGroup[]{this.resourceInfo, this.directTypes, this.allTypes, this.sameAsInstances, this.propertyTypes, this.propertyValues};
            this.resourceInfo.getValues().clear();
            this.resourceInfo.getValues().add(oInstance);
            this.resourceInfo.getValues().add(new KeyValuePair(oInstance, "URI", oInstance.getURI().toString(), false));
            this.resourceInfo.getValues().add(new KeyValuePair(oInstance, "TYPE", "Ontology Instance", false));
            Set<OClass> set9 = oInstance.getOClasses((byte)0);
            this.directTypes.getValues().clear();
            if (set9 != null) {
                for (OClass set10 : set9) {
                    this.directTypes.getValues().addAll(Utils.getDetailsToAdd(set10));
                }
            }
            Set<OClass> set11 = oInstance.getOClasses((byte)1);
            this.allTypes.getValues().clear();
            if (set11 != null) {
                Iterator iterator = set11.iterator();
                while (iterator.hasNext()) {
                    object = (OClass)iterator.next();
                    this.allTypes.getValues().addAll(Utils.getDetailsToAdd(object));
                }
            }
            Set<OInstance> set = oInstance.getSameInstance();
            this.sameAsInstances.getValues().clear();
            if (set != null) {
                this.sameAsInstances.getValues().addAll(set);
                Collections.sort(this.sameAsInstances.getValues(), this.itemComparator);
            }
            this.propertyTypes.getValues().clear();
            object = oInstance.getPropertiesWithResourceAsDomain();
            this.propertyTypes.getValues().addAll(object);
            this.propertyValues.getValues().clear();
            Set<AnnotationProperty> set10 = oInstance.getSetAnnotationProperties();
            Set<DatatypeProperty> set12 = oInstance.getSetDatatypeProperties();
            Set<ObjectProperty> set13 = oInstance.getSetObjectProperties();
            Set<RDFProperty> set14 = oInstance.getSetRDFProperties();
            for (AnnotationProperty annotationProperty : set10) {
                list = oInstance.getAnnotationPropertyValues(annotationProperty);
                for (n = 0; n < list.size(); ++n) {
                    propertyValue = new PropertyValue(annotationProperty, list.get(n));
                    this.propertyValues.getValues().add(propertyValue);
                }
            }
            for (DatatypeProperty datatypeProperty : set12) {
                list = oInstance.getDatatypePropertyValues(datatypeProperty);
                for (n = 0; n < list.size(); ++n) {
                    propertyValue = new PropertyValue(datatypeProperty, list.get(n));
                    this.propertyValues.getValues().add(propertyValue);
                }
            }
            for (ObjectProperty objectProperty : set13) {
                list = oInstance.getObjectPropertyValues(objectProperty);
                for (n = 0; n < list.size(); ++n) {
                    propertyValue = new PropertyValue(objectProperty, list.get(n));
                    this.propertyValues.getValues().add(propertyValue);
                }
            }
            for (RDFProperty rDFProperty : set14) {
                list = oInstance.getRDFPropertyOValues(rDFProperty);
                for (n = 0; n < list.size(); ++n) {
                    propertyValue = new PropertyValue(rDFProperty, list.get(n));
                    this.propertyValues.getValues().add(propertyValue);
                }
            }
        }
        this.fireTableDataChanged();
    }

    public OResource getItem() {
        return this.oResource;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }
}

