/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.OntologyClassView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.XJTable;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import gate.util.Out;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class OntologyInstanceView
extends AbstractDocumentView {
    protected Ontology selectedOntology;
    protected TextualDocumentView textView;
    protected OntologyClassView classView;
    protected JPanel mainPanel;
    protected JTextField filterTextField;
    protected JButton clearFilterButton;
    protected JButton newInstanceButton;
    protected JButton addLabelButton;
    protected XJTable instanceTable;
    protected XJTable propertyTable;
    protected OClass selectedClass;
    protected OInstance selectedInstance;
    protected Set<OInstance> instanceSet = new HashSet<OInstance>();
    protected Set<ObjectProperty> propertiesSet = new HashSet<ObjectProperty>();
    protected Set<ObjectProperty> propertiesNotSet = new HashSet<ObjectProperty>();
    protected Map<String, Set<OClass>> propertyClassesMap = new HashMap<String, Set<OClass>>();

    protected void initGUI() {
        Serializable serializable;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            serializable = iterator.next();
            if (!(serializable instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)serializable;
        }
        this.mainPanel = new JPanel(new BorderLayout());
        serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Filter: ");
        ((Container)serializable).add(jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.filterTextField = new JTextField(20);
        ((Container)serializable).add(this.filterTextField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.filterTextField.setToolTipText("Filter the instance table rows");
        JPanel jPanel = new JPanel();
        this.clearFilterButton = new JButton();
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(this.clearFilterButton);
        this.newInstanceButton = new JButton("New Inst.");
        this.newInstanceButton.setEnabled(false);
        this.newInstanceButton.setToolTipText("New instance from the selection");
        this.newInstanceButton.setMnemonic(78);
        jPanel.add(this.newInstanceButton);
        this.addLabelButton = new JButton("Add to Selected Inst.");
        this.addLabelButton.setEnabled(false);
        this.addLabelButton.setToolTipText("Add label from selection to the selected instance");
        this.newInstanceButton.setMnemonic(65);
        jPanel.add(this.addLabelButton);
        ((Container)serializable).add(jPanel, gridBagConstraints);
        this.mainPanel.add((Component)serializable, "North");
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                if (dimension != null) {
                    dimension.width = Integer.MAX_VALUE;
                    this.setMaximumSize(dimension);
                }
                return dimension;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.instanceTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.instanceTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Instance");
        defaultTableModel.addColumn("Label");
        this.instanceTable.setModel(defaultTableModel);
        jPanel2.add(new JScrollPane(this.instanceTable));
        this.propertyTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return this.convertColumnIndexToModel(n2) == 1;
            }
        };
        this.propertyTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        this.propertyTable.setModel(defaultTableModel);
        jPanel2.add(new JScrollPane(this.propertyTable));
        this.mainPanel.add((Component)jPanel2, "Center");
        this.initListeners();
    }

    protected void initListeners() {
        this.clearFilterButton.setAction(new AbstractAction("", MainFrame.getIcon("exit.gif")){
            {
                this.putValue("MnemonicKey", 8);
                this.putValue("ShortDescription", "Clear text field");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.filterTextField.setText("");
                OntologyInstanceView.this.filterTextField.requestFocusInWindow();
            }
        });
        this.instanceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                OntologyInstanceView.this.updatePropertyTable();
                OntologyInstanceView.this.addLabelButton.setEnabled(OntologyInstanceView.this.newInstanceButton.isEnabled() && OntologyInstanceView.this.selectedInstance != null);
            }
        });
        this.instanceTable.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '\t' && keyEvent.getKeyChar() != ' ' && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyChar() != '\u007f') {
                    OntologyInstanceView.this.filterTextField.requestFocusInWindow();
                    OntologyInstanceView.this.filterTextField.setText(String.valueOf(keyEvent.getKeyChar()));
                }
            }
        });
        this.instanceTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                final JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (jTable.getSelectedRowCount() > 0) {
                        jPopupMenu.add(new AbstractAction(jTable.getSelectedRowCount() > 1 ? "Delete instances" : "Delete instance"){

                            public void actionPerformed(ActionEvent actionEvent) {
                                for (OInstance oInstance : OntologyInstanceView.this.instanceSet) {
                                    for (int n : jTable.getSelectedRows()) {
                                        if (!oInstance.getName().equals(jTable.getModel().getValueAt(n, 0))) continue;
                                        OntologyInstanceView.this.selectedOntology.removeOInstance(oInstance);
                                        AnnotationSet annotationSet = OntologyInstanceView.this.document.getAnnotations(OntologyInstanceView.this.classView.getSelectedSet());
                                        for (Annotation annotation : annotationSet.get("Mention")) {
                                            if (!annotation.getFeatures().containsKey("ontology") || !annotation.getFeatures().get("ontology").equals(OntologyInstanceView.this.selectedOntology.getOntologyURI()) || !annotation.getFeatures().containsKey("class") || !annotation.getFeatures().get("class").equals(((Object)OntologyInstanceView.this.selectedClass.getONodeID()).toString()) || !annotation.getFeatures().containsKey("inst") || !annotation.getFeatures().get("inst").equals(((Object)oInstance.getONodeID()).toString())) continue;
                                            annotationSet.remove(annotation);
                                        }
                                    }
                                }
                                OntologyInstanceView.this.classView.setClassSelected(OntologyInstanceView.this.selectedClass, false);
                                OntologyInstanceView.this.classView.setClassSelected(OntologyInstanceView.this.selectedClass, true);
                                OntologyInstanceView.this.updateInstanceTable(OntologyInstanceView.this.selectedClass);
                            }
                        });
                    }
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.propertyTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                final JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (jTable.getSelectedRowCount() > 0) {
                        jPopupMenu.add(new AbstractAction(jTable.getSelectedRowCount() > 1 ? "Delete properties" : "Delete property"){

                            public void actionPerformed(ActionEvent actionEvent) {
                                for (ObjectProperty objectProperty : OntologyInstanceView.this.propertiesSet) {
                                    block1: for (int n : jTable.getSelectedRows()) {
                                        if (!objectProperty.getName().equals(jTable.getModel().getValueAt(n, 0))) continue;
                                        for (OInstance oInstance : OntologyInstanceView.this.selectedInstance.getObjectPropertyValues(objectProperty)) {
                                            String string = oInstance.getONodeID().getResourceName();
                                            if (!string.equals(jTable.getModel().getValueAt(n, 1))) continue;
                                            OntologyInstanceView.this.selectedInstance.removeObjectPropertyValue(objectProperty, oInstance);
                                            continue block1;
                                        }
                                    }
                                }
                                OntologyInstanceView.this.updatePropertyTable();
                            }
                        });
                    }
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Instance view table rows filter", true);
            private TimerTask timerTask;

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date date = new Date(System.currentTimeMillis() + 300L);
                this.timerTask = new TimerTask(){

                    public void run() {
                        OntologyInstanceView.this.updateInstanceTable(OntologyInstanceView.this.selectedClass);
                    }
                };
                this.timer.schedule(this.timerTask, date);
            }
        });
        this.filterTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
                    OntologyInstanceView.this.instanceTable.dispatchEvent(keyEvent);
                }
            }
        });
    }

    protected void registerHooks() {
    }

    protected void unregisterHooks() {
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public int getType() {
        return 2;
    }

    public void setClassView(OntologyClassView ontologyClassView) {
        this.classView = ontologyClassView;
    }

    public void updateInstanceTable(OClass oClass) {
        this.selectedClass = oClass;
        this.instanceSet.clear();
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Instance");
        defaultTableModel.addColumn("Label");
        if (oClass != null) {
            this.selectedOntology = oClass.getOntology();
            Set<OInstance> set = this.selectedOntology.getOInstances(oClass, OConstants.Closure.TRANSITIVE_CLOSURE);
            String string = this.filterTextField.getText().trim().toLowerCase(Locale.ENGLISH);
            for (OInstance oInstance : set) {
                Set<AnnotationProperty> set2 = oInstance.getSetAnnotationProperties();
                for (AnnotationProperty annotationProperty : set2) {
                    if (!annotationProperty.getName().equals("label")) continue;
                    this.instanceSet.add(oInstance);
                    List<Literal> list = oInstance.getAnnotationPropertyValues(annotationProperty);
                    HashSet<String> hashSet = new HashSet<String>();
                    boolean bl = false;
                    for (Literal literal : list) {
                        hashSet.add(literal.getValue());
                        if (literal.getValue().toLowerCase().indexOf(string) == -1) continue;
                        bl = true;
                    }
                    if (bl) {
                        defaultTableModel.addRow(new Object[]{oInstance.getName(), Strings.toString(hashSet)});
                        continue;
                    }
                    this.instanceSet.remove(oInstance);
                }
            }
        }
        this.instanceTable.setModel(defaultTableModel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((AbstractTableModel)OntologyInstanceView.this.instanceTable.getModel()).fireTableDataChanged();
                if (OntologyInstanceView.this.instanceTable.getRowCount() > 0) {
                    OntologyInstanceView.this.instanceTable.setRowSelectionInterval(0, 0);
                }
            }
        });
    }

    public void updatePropertyTable() {
        this.selectedInstance = null;
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        if (this.instanceTable.getSelectedRow() != -1) {
            String string = (String)this.instanceTable.getValueAt(this.instanceTable.getSelectedRow(), this.instanceTable.convertColumnIndexToView(0));
            for (OInstance oInstance : this.instanceSet) {
                if (!oInstance.getName().equals(string)) continue;
                this.selectedInstance = oInstance;
                this.propertiesSet.clear();
                this.propertiesNotSet.clear();
                Set<OClass> set = oInstance.getOClasses(OConstants.Closure.DIRECT_CLOSURE);
                for (OClass oResource : set) {
                    for (RDFProperty rDFProperty : oResource.getPropertiesWithResourceAsDomain()) {
                        if (!(rDFProperty instanceof ObjectProperty)) continue;
                        this.propertiesNotSet.add((ObjectProperty)rDFProperty);
                        HashSet<String> hashSet = new HashSet<String>();
                        HashSet<OClass> hashSet2 = new HashSet<OClass>();
                        for (OResource oResource2 : ((ObjectProperty)rDFProperty).getRange()) {
                            hashSet.add(oResource2.getName());
                            hashSet2.add((OClass)oResource2);
                        }
                        if (hashSet.isEmpty()) {
                            hashSet.add("All classes");
                        }
                        this.propertyClassesMap.put(rDFProperty.getName(), hashSet2);
                        defaultTableModel.addRow(new Object[]{rDFProperty.getName(), Strings.toString(hashSet)});
                    }
                }
                for (ObjectProperty objectProperty : oInstance.getSetObjectProperties()) {
                    this.propertiesSet.add(objectProperty);
                    for (OInstance oInstance2 : oInstance.getObjectPropertyValues(objectProperty)) {
                        defaultTableModel.addRow(new Object[]{objectProperty.getName(), oInstance2.getONodeID().getResourceName()});
                    }
                }
            }
        }
        this.propertyTable.setModel(defaultTableModel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OntologyInstanceView.this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new PropertyValueCellEditor());
                ((AbstractTableModel)OntologyInstanceView.this.propertyTable.getModel()).fireTableDataChanged();
            }
        });
    }

    protected void addSelectionToFilter(final String string, final String string2, final int n, final int n2) {
        this.newInstanceButton.setAction(new AbstractAction(this.newInstanceButton.getText()){
            {
                super(string4);
                this.putValue("MnemonicKey", 78);
                this.putValue("ShortDescription", OntologyInstanceView.this.newInstanceButton.getToolTipText());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.createFromSelection(string, string2, n, n2, true);
            }
        });
        this.newInstanceButton.setEnabled(true);
        this.addLabelButton.setAction(new AbstractAction(this.addLabelButton.getText()){
            {
                super(string4);
                this.putValue("MnemonicKey", 65);
                this.putValue("ShortDescription", OntologyInstanceView.this.addLabelButton.getToolTipText());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.createFromSelection(string, string2, n, n2, false);
            }
        });
        this.filterTextField.setText(string2);
        this.addLabelButton.setEnabled(this.selectedInstance != null);
    }

    protected void createFromSelection(String string, String string2, int n, int n2, boolean bl) {
        AnnotationProperty annotationProperty;
        this.newInstanceButton.setEnabled(false);
        this.addLabelButton.setEnabled(false);
        string2 = string2.replaceAll(" ", "_");
        RDFProperty rDFProperty = this.selectedOntology.getProperty(this.selectedOntology.createOURIForName("label"));
        if (rDFProperty == null) {
            annotationProperty = this.selectedOntology.addAnnotationProperty(this.selectedOntology.createOURIForName("label"));
        } else if (rDFProperty instanceof AnnotationProperty) {
            annotationProperty = (AnnotationProperty)rDFProperty;
        } else {
            Out.prln("There is already a property 'label' that is not an annotation property!");
            return;
        }
        OInstance oInstance = this.selectedInstance;
        if (bl) {
            oInstance = this.selectedOntology.addOInstance(this.selectedOntology.createOURIForName(string2), this.selectedClass);
        }
        oInstance.addAnnotationPropertyValue(annotationProperty, new Literal(string2));
        AnnotationSet annotationSet = this.document.getAnnotations(string);
        try {
            this.features = Factory.newFeatureMap();
            this.features.put("ontology", this.selectedOntology.getOntologyURI());
            this.features.put("class", ((Object)this.selectedClass.getONodeID()).toString());
            this.features.put("inst", ((Object)oInstance.getONodeID()).toString());
            Integer n3 = annotationSet.add(Long.valueOf(n), Long.valueOf(n2), "Mention", this.features);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new LuckyException(invalidOffsetException);
        }
        this.classView.setClassSelected(this.selectedClass, false);
        this.classView.setClassSelected(this.selectedClass, true);
        this.updateInstanceTable(this.selectedClass);
    }

    protected class PropertyValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox valueComboBox = new JComboBox();
        private Collator comparator;
        private String oldValue;
        private Map<String, OInstance> nameInstanceMap;

        private PropertyValueCellEditor() {
            this.valueComboBox.setMaximumRowCount(10);
            this.valueComboBox.addActionListener(this);
            this.comparator = Collator.getInstance();
            this.comparator.setStrength(2);
            this.nameInstanceMap = new HashMap<String, OInstance>();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.oldValue = (String)object;
            TreeSet<Object> treeSet = new TreeSet<Object>(this.comparator);
            Set<OClass> set = OntologyInstanceView.this.propertyClassesMap.get((String)OntologyInstanceView.this.propertyTable.getModel().getValueAt(n, 0));
            if (set.isEmpty()) {
                set = OntologyInstanceView.this.selectedOntology.getOClasses(false);
            }
            for (OClass oClass : set) {
                Set<OInstance> set2 = OntologyInstanceView.this.selectedOntology.getOInstances(oClass, OConstants.Closure.TRANSITIVE_CLOSURE);
                for (OInstance oInstance : set2) {
                    treeSet.add(oInstance.getName());
                    this.nameInstanceMap.put(oInstance.getName(), oInstance);
                }
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
            this.valueComboBox.setModel(defaultComboBoxModel);
            this.valueComboBox.setSelectedItem(OntologyInstanceView.this.propertyTable.getValueAt(n, n2));
            return this.valueComboBox;
        }

        public Object getCellEditorValue() {
            return this.valueComboBox.getSelectedItem();
        }

        protected void fireEditingStopped() {
            String string = (String)this.getCellEditorValue();
            if (string == null) {
                this.fireEditingCanceled();
                return;
            }
            super.fireEditingStopped();
            String string2 = (String)OntologyInstanceView.this.propertyTable.getModel().getValueAt(OntologyInstanceView.this.propertyTable.getSelectedRow(), 0);
            for (ObjectProperty objectProperty : OntologyInstanceView.this.propertiesSet) {
                if (!objectProperty.getName().equals(string2)) continue;
                for (OInstance oInstance : OntologyInstanceView.this.selectedInstance.getObjectPropertyValues(objectProperty)) {
                    String string3 = oInstance.getONodeID().getResourceName();
                    if (!string3.equals(this.oldValue)) continue;
                    OntologyInstanceView.this.selectedInstance.removeObjectPropertyValue(objectProperty, oInstance);
                    try {
                        OntologyInstanceView.this.selectedInstance.addObjectPropertyValue(objectProperty, this.nameInstanceMap.get(string));
                    }
                    catch (InvalidValueException invalidValueException) {
                        invalidValueException.printStackTrace();
                    }
                    OntologyInstanceView.this.updatePropertyTable();
                    return;
                }
            }
            for (ObjectProperty objectProperty : OntologyInstanceView.this.propertiesNotSet) {
                if (!objectProperty.getName().equals(string2)) continue;
                try {
                    OntologyInstanceView.this.selectedInstance.addObjectPropertyValue(objectProperty, this.nameInstanceMap.get(string));
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
                OntologyInstanceView.this.updatePropertyTable();
                return;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getCellEditorValue() == null) {
                this.fireEditingCanceled();
            } else {
                this.fireEditingStopped();
            }
        }
    }
}

