/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationListView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.AnnotationStack;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;

public class AnnotationStackView
extends AbstractDocumentView
implements AnnotationListener {
    JLabel targetSetLabel;
    AnnotationStack stackPanel;
    JScrollPane scroller;
    JPanel mainPanel;
    TextualDocumentView textView;
    AnnotationSetsView annotationSetsView;
    AnnotationListView annotationListView;
    String targetSetName;
    Document document;
    PreviousAnnotationAction previousAnnotationAction;
    NextAnnotationAction nextAnnotationAction;
    Map<String, String> typesFeatures = new HashMap<String, String>();

    public void cleanup() {
        super.cleanup();
        this.textView = null;
    }

    protected void initGUI() {
        Serializable serializable;
        Object object;
        Object object2;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object2;
        }
        object2 = this.owner.getVerticalViews().iterator();
        while (this.annotationSetsView == null && object2.hasNext()) {
            object = (DocumentView)object2.next();
            if (!(object instanceof AnnotationSetsView)) continue;
            this.annotationSetsView = (AnnotationSetsView)object;
        }
        object = this.owner.getHorizontalViews().iterator();
        while (this.annotationListView == null && object.hasNext()) {
            serializable = (DocumentView)object.next();
            if (!(serializable instanceof AnnotationListView)) continue;
            this.annotationListView = (AnnotationListView)serializable;
        }
        this.annotationListView.setOwner(this.owner);
        this.document = this.textView.getDocument();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        serializable = new JToolBar();
        ((JToolBar)serializable).setFloatable(false);
        ((JToolBar)serializable).addSeparator();
        this.previousAnnotationAction = new PreviousAnnotationAction();
        ((JToolBar)serializable).add(this.previousAnnotationAction);
        this.nextAnnotationAction = new NextAnnotationAction();
        ((JToolBar)serializable).add(this.nextAnnotationAction);
        ((JToolBar)serializable).addSeparator();
        this.targetSetLabel = new JLabel();
        ((Container)serializable).add(this.targetSetLabel);
        this.targetSetLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AnnotationStackView.this.askTargetSet();
            }
        });
        this.targetSetLabel.setToolTipText("<html>Target set to copy annotation when double clicked.<br>Click to change it.</html>");
        this.mainPanel.add((Component)serializable, "North");
        this.stackPanel = new AnnotationStack(100, 20);
        this.scroller = new JScrollPane(this.stackPanel);
        this.scroller.getViewport().setOpaque(true);
        this.mainPanel.add((Component)this.scroller, "Center");
        this.initListeners();
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    protected void initListeners() {
        this.stackPanel.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                AnnotationStackView.this.updateStackView();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.textView.getTextView().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                AnnotationStackView.this.updateStackView();
            }
        });
    }

    protected void registerHooks() {
    }

    protected void unregisterHooks() {
    }

    public int getType() {
        return 2;
    }

    public void annotationUpdated(AnnotationEvent annotationEvent) {
        this.updateStackView();
    }

    public void updateStackView() {
        if (this.textView == null) {
            return;
        }
        int n = this.textView.getTextView().getCaretPosition();
        int n2 = 40;
        String string = "";
        try {
            string = this.document.getContent().getContent(Math.max(0L, (long)(n - n2)), Math.min(this.document.getContent().size(), (long)(n + 1 + n2))).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace();
        }
        this.stackPanel.setText(string);
        this.stackPanel.setExpressionStartOffset(n);
        this.stackPanel.setExpressionEndOffset(n + 1);
        this.stackPanel.setContextBeforeSize(Math.min(n, n2));
        this.stackPanel.setContextAfterSize(Math.min(this.document.getContent().size().intValue() - 1 - n, n2));
        this.stackPanel.setAnnotationMouseListener(new AnnotationMouseListener());
        this.stackPanel.setHeaderMouseListener(new HeaderMouseListener());
        this.stackPanel.clearAllRows();
        for (AnnotationSetsView.SetHandler setHandler : this.annotationSetsView.setHandlers) {
            for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!typeHandler.isSelected()) continue;
                this.stackPanel.addRow(setHandler.set.getName(), typeHandler.name, this.typesFeatures.get(typeHandler.name), null, null, 1);
                AnnotationSet annotationSet = setHandler.set.get(typeHandler.name).get(Math.max(0L, (long)(n - n2)), Math.min(this.document.getContent().size(), (long)(n + 1 + n2)));
                for (Annotation annotation : annotationSet) {
                    this.stackPanel.addAnnotation(annotation);
                }
            }
        }
        this.stackPanel.drawStack();
    }

    boolean askTargetSet() {
        Object[] objectArray;
        Object object;
        Container container;
        Serializable serializable;
        Object[] objectArray2;
        final JTextField jTextField = new JTextField("consensus", 15);
        if (this.document.getAnnotationSetNames() != null && !this.document.getAnnotationSetNames().isEmpty()) {
            objectArray2 = Collator.getInstance(Locale.ENGLISH);
            objectArray2.setStrength(2);
            serializable = new TreeSet<Object>((Comparator<Object>)objectArray2);
            serializable.addAll(this.document.getAnnotationSetNames());
            container = new JList<Object>(serializable.toArray());
            ((JList)container).setVisibleRowCount(Math.min(10, serializable.size()));
            ((JList)container).setSelectionMode(0);
            ((JList)container).setSelectedValue(this.targetSetName, true);
            object = new JScrollPane(container);
            JPanel jPanel = new JPanel();
            jPanel.setSize(0, 5);
            ((JList)container).addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (jList.getSelectedValue() != null) {
                        jTextField.setText((String)jList.getSelectedValue());
                    }
                }
            });
            objectArray = new Object[]{"Existing annotation sets:", object, jPanel, "Target set:", jTextField};
        } else {
            objectArray = new Object[]{"Target set:", jTextField};
        }
        objectArray2 = new String[]{"Use this target set", "Cancel"};
        serializable = new JOptionPane(objectArray, 3, 0, null, objectArray2, "Cancel");
        container = ((JOptionPane)serializable).createDialog(this.owner, "Copy annotation to another set");
        jTextField.requestFocus();
        ((Dialog)container).setVisible(true);
        object = ((JOptionPane)serializable).getValue();
        if (object == null || object.equals("Cancel") || jTextField.getText().trim().length() == 0) {
            this.textView.getTextView().requestFocusInWindow();
            return false;
        }
        this.targetSetName = jTextField.getText();
        this.targetSetLabel.setText("Target set: " + this.targetSetName);
        this.textView.getTextView().requestFocusInWindow();
        return true;
    }

    protected class HeaderMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        JWindow popupWindow;

        public HeaderMouseListener() {
        }

        public HeaderMouseListener(String string, String string2) {
            this.type = string;
            this.feature = string2;
            this.init();
        }

        public HeaderMouseListener(String string) {
            this.type = string;
            this.init();
        }

        void init() {
            AnnotationStackView.this.mainPanel.addAncestorListener(new AncestorListener(){

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    if (HeaderMouseListener.this.popupWindow != null) {
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
        }

        public MouseInputAdapter createListener(String ... stringArray) {
            switch (stringArray.length) {
                case 1: {
                    return new HeaderMouseListener(stringArray[0]);
                }
                case 2: {
                    return new HeaderMouseListener(stringArray[0], stringArray[1]);
                }
            }
            return null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.dispose();
                return;
            }
            if (mouseEvent.getButton() != 1 || mouseEvent.getClickCount() != 2) {
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            if (AnnotationStackView.this.document.getAnnotationSetNames() != null) {
                hashSet.addAll(AnnotationStackView.this.document.getAnnotationSetNames());
            }
            hashSet.add(null);
            block0: for (String object2 : hashSet) {
                int n = 0;
                for (Annotation annotation : AnnotationStackView.this.document.getAnnotations(object2).get(this.type)) {
                    for (Object k : annotation.getFeatures().keySet()) {
                        treeSet.add((String)k);
                    }
                    if (++n != 50) continue;
                    continue block0;
                }
            }
            treeSet.add("          ");
            final JList<Object> jList = new JList<Object>(treeSet.toArray());
            jList.setVisibleRowCount(Math.min(8, treeSet.size()));
            jList.setSelectionMode(0);
            jList.setBackground(Color.WHITE);
            jList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1) {
                        String string = (String)jList.getSelectedValue();
                        if (string.equals("          ")) {
                            AnnotationStackView.this.typesFeatures.remove(HeaderMouseListener.this.type);
                        } else {
                            AnnotationStackView.this.typesFeatures.put(HeaderMouseListener.this.type, string);
                        }
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                        AnnotationStackView.this.updateStackView();
                        AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
                    }
                }
            });
            this.popupWindow = new JWindow();
            this.popupWindow.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.popupWindow.add(new JScrollPane(jList));
            Component component = mouseEvent.getComponent();
            this.popupWindow.setBounds(component.getLocationOnScreen().x, component.getLocationOnScreen().y + component.getHeight(), component.getWidth(), Math.min(8 * component.getHeight(), treeSet.size() * component.getHeight()));
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = AnnotationStackView.this.typesFeatures.get(HeaderMouseListener.this.type);
                    if (string == null) {
                        string = "          ";
                    }
                    jList.setSelectedValue(string, true);
                    HeaderMouseListener.this.popupWindow.requestFocusInWindow();
                }
            });
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JLabel && ((JLabel)component).getToolTipText() == null) {
                ((JLabel)component).setToolTipText("Double click to choose a feature.");
            }
        }
    }

    class AnnotationMouseListener
    extends AnnotationStack.StackMouseListener {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        int dismissDelay;
        int initialDelay;
        int reshowDelay;
        boolean enabled;
        Annotation annotation;
        AnnotationData annotationData;
        boolean isTooltipSet = false;

        public AnnotationMouseListener() {
        }

        public AnnotationMouseListener(String string, String string2) {
            AnnotationSet annotationSet = AnnotationStackView.this.document.getAnnotations(string);
            this.annotation = annotationSet.get(Integer.valueOf(string2));
            if (this.annotation != null) {
                this.annotationData = new AnnotationDataImpl(annotationSet, this.annotation);
            }
        }

        public MouseInputAdapter createListener(String ... stringArray) {
            switch (stringArray.length) {
                case 3: {
                    return new AnnotationMouseListener(stringArray[0], stringArray[2]);
                }
                case 5: {
                    return new AnnotationMouseListener(stringArray[0], stringArray[4]);
                }
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                List<Action> list = AnnotationStackView.this.annotationListView.getSpecificEditorActions(this.annotationData.getAnnotationSet(), this.annotationData.getAnnotation());
                for (Action action : list) {
                    jPopupMenu.add(action);
                }
                for (Action action : AnnotationStackView.this.annotationListView.getGenericEditorActions(this.annotationData.getAnnotationSet(), this.annotationData.getAnnotation())) {
                    if (list.contains(action)) continue;
                    jPopupMenu.add(action);
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getID() == 500 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                if (AnnotationStackView.this.targetSetName == null && !AnnotationStackView.this.askTargetSet()) {
                    return;
                }
                try {
                    AnnotationStackView.this.document.getAnnotations(AnnotationStackView.this.targetSetName).add(this.annotation.getStartNode().getOffset(), this.annotation.getEndNode().getOffset(), this.annotation.getType(), this.annotation.getFeatures());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace();
                }
                Date date = new Date(System.currentTimeMillis() + 1000L);
                Timer timer = new Timer("Annotation stack view select type", true);
                timer.schedule(new TimerTask(){

                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AnnotationStackView.this.annotationSetsView.selectAnnotation(AnnotationMouseListener.this.annotation, AnnotationStackView.this.document.getAnnotations(AnnotationStackView.this.targetSetName));
                            }
                        });
                    }
                }, date);
            }
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.dismissDelay = this.toolTipManager.getDismissDelay();
            this.initialDelay = this.toolTipManager.getInitialDelay();
            this.reshowDelay = this.toolTipManager.getReshowDelay();
            this.enabled = this.toolTipManager.isEnabled();
            Component component = mouseEvent.getComponent();
            if (!this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel jLabel = (JLabel)component;
                String string = jLabel.getToolTipText() == null ? "" : jLabel.getToolTipText();
                string = string.replaceAll("</?html>", "");
                string = "<html>" + (string.length() == 0 ? "" : string + "<br>") + "Double click to copy this annotation.<br>" + "Right click to edit</html>";
                jLabel.setToolTipText(string);
            }
            this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
            this.toolTipManager.setInitialDelay(0);
            this.toolTipManager.setReshowDelay(0);
            this.toolTipManager.setEnabled(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.toolTipManager.setDismissDelay(this.dismissDelay);
            this.toolTipManager.setInitialDelay(this.initialDelay);
            this.toolTipManager.setReshowDelay(this.reshowDelay);
            this.toolTipManager.setEnabled(this.enabled);
        }
    }

    class NextAnnotationAction
    extends AbstractAction {
        public NextAnnotationAction() {
            super("Next boundary");
            this.putValue("ShortDescription", "Centre the view on the closest next annotation boundary among all displayed");
            this.putValue("MnemonicKey", 39);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationStackView.this.previousAnnotationAction.setEnabled(true);
            TreeSet<Annotation> treeSet = new TreeSet<Annotation>(Collections.reverseOrder(new OffsetComparator()));
            for (AnnotationSetsView.SetHandler setHandler : AnnotationStackView.this.annotationSetsView.setHandlers) {
                for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                    if (!typeHandler.isSelected()) continue;
                    treeSet.addAll(setHandler.set.get(typeHandler.name).getContained(Long.valueOf(AnnotationStackView.this.textView.getTextView().getCaretPosition()), AnnotationStackView.this.document.getContent().size() - 1L));
                }
            }
            if (treeSet.size() > 0) {
                AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)treeSet.last()).getEndNode().getOffset().intValue());
                try {
                    AnnotationStackView.this.textView.getTextView().scrollRectToVisible(AnnotationStackView.this.textView.getTextView().modelToView(AnnotationStackView.this.textView.getTextView().getCaretPosition()));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            this.setEnabled(treeSet.size() > 1);
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }
    }

    class PreviousAnnotationAction
    extends AbstractAction {
        public PreviousAnnotationAction() {
            super("Previous boundary");
            this.putValue("ShortDescription", "Centre the view on the closest previous annotation boundary among all displayed");
            this.putValue("MnemonicKey", 37);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationStackView.this.nextAnnotationAction.setEnabled(true);
            TreeSet<Annotation> treeSet = new TreeSet<Annotation>(new OffsetComparator());
            for (AnnotationSetsView.SetHandler setHandler : AnnotationStackView.this.annotationSetsView.setHandlers) {
                for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                    if (!typeHandler.isSelected()) continue;
                    treeSet.addAll(setHandler.set.get(typeHandler.name).getContained(0L, (long)AnnotationStackView.this.textView.getTextView().getCaretPosition() - 1L));
                }
            }
            if (treeSet.size() > 0) {
                AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)treeSet.last()).getEndNode().getOffset().intValue());
                try {
                    AnnotationStackView.this.textView.getTextView().scrollRectToVisible(AnnotationStackView.this.textView.getTextView().modelToView(AnnotationStackView.this.textView.getTextView().getCaretPosition()));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            this.setEnabled(treeSet.size() > 1);
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }
    }
}

