/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.TextualDocument;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.GateEvent;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationList;
import gate.gui.docview.AnnotationListView;
import gate.gui.docview.AnnotationStackView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.ColorGenerator;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSetsView
extends AbstractDocumentView
implements DocumentListener,
AnnotationSetListener,
AnnotationEditorOwner {
    List<SetHandler> setHandlers = new ArrayList<SetHandler>();
    List tableRows = new ArrayList();
    XJTable mainTable;
    SetsTableModel tableModel;
    JScrollPane scroller;
    JPanel mainPanel;
    JTextField newSetNameTextField;
    TextualDocumentView textView;
    AnnotationListView listView;
    AnnotationStackView stackView;
    JTextArea textPane;
    OwnedAnnotationEditor annotationEditor;
    NewAnnotationSetAction newSetAction;
    protected TextMouseListener textMouseListener;
    protected PropertyChangeListener textChangeListener;
    protected BlockingQueue<TypeSpec> visibleAnnotationTypes = new LinkedBlockingQueue<TypeSpec>();
    protected Timer mouseMovementTimer;
    protected Timer eventMinder;
    protected BlockingQueue<GateEvent> pendingEvents;
    private static final int MOUSE_MOVEMENT_TIMER_DELAY = 500;
    protected MouseStoppedMovingAction mouseStoppedMovingAction;
    protected String lastAnnotationType = "_New_";
    protected List actions = new ArrayList();
    protected static final ColorGenerator colourGenerator = new ColorGenerator();
    private static final int NAME_COL = 1;
    private static final int SELECTED_COL = 0;
    private static final GateEvent END_OF_LIST = new GateEvent(AnnotationSetsView.class, Integer.MAX_VALUE);
    private static final int EVENTS_HANDLE_DELAY = 300;

    @Override
    public void annotationChanged(Annotation annotation, AnnotationSet annotationSet, String string) {
        this.lastAnnotationType = annotation.getType();
        this.setTypeSelected(annotationSet.getName(), annotation.getType(), true);
    }

    @Override
    public void selectAnnotation(final AnnotationData annotationData) {
        Runnable runnable = new Runnable(){

            public void run() {
                List<AnnotationData> list = Collections.singletonList(annotationData);
                AnnotationSetsView.this.owner.setSelectedAnnotations(list);
            }
        };
        this.pendingEvents.offer(new PerformActionEvent(runnable));
        this.eventMinder.restart();
    }

    @Override
    public Annotation getNextAnnotation() {
        return null;
    }

    @Override
    public Annotation getPreviousAnnotation() {
        return null;
    }

    @Override
    public JTextComponent getTextComponent() {
        return this.textPane;
    }

    public AnnotationList getListComponent() {
        return this.listView;
    }

    public AnnotationSetsView() {
        this.actions.add(new SavePreserveFormatAction());
        this.pendingEvents = new LinkedBlockingQueue<GateEvent>();
        this.eventMinder = new Timer(300, new HandleDocumentEventsAction());
        this.eventMinder.setRepeats(true);
        this.eventMinder.setCoalesce(true);
    }

    @Override
    public List getActions() {
        return this.actions;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected void initGUI() {
        Object object;
        Object object2;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object2;
        }
        this.textPane = (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
        object2 = this.owner.getHorizontalViews().iterator();
        while (this.listView == null && object2.hasNext()) {
            object = (DocumentView)object2.next();
            if (!(object instanceof AnnotationListView)) continue;
            this.listView = (AnnotationListView)object;
        }
        object2 = this.owner.getHorizontalViews().iterator();
        while (this.stackView == null && object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof AnnotationStackView)) continue;
            this.stackView = (AnnotationStackView)object;
        }
        this.mainTable = new XJTable();
        this.tableModel = new SetsTableModel();
        this.mainTable.setSortable(false);
        this.mainTable.setModel(this.tableModel);
        this.mainTable.setRowMargin(0);
        this.mainTable.getColumnModel().setColumnMargin(0);
        object = new SetsTableCellRenderer();
        this.mainTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)object);
        this.mainTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)object);
        SetsTableCellEditor setsTableCellEditor = new SetsTableCellEditor();
        this.mainTable.getColumnModel().getColumn(0).setCellEditor(setsTableCellEditor);
        this.mainTable.setSelectionMode(0);
        this.mainTable.setColumnSelectionAllowed(false);
        this.mainTable.setRowSelectionAllowed(true);
        this.mainTable.setSelectionMode(2);
        this.mainTable.setAutoCreateColumnsFromModel(false);
        this.mainTable.setTableHeader(null);
        this.mainTable.setShowGrid(false);
        this.mainTable.setAutoResizeMode(0);
        Color color = this.mainTable.getBackground();
        color = new Color(color.getRGB());
        this.mainTable.setBackground(color);
        this.scroller = new JScrollPane(this.mainTable);
        this.scroller.getViewport().setOpaque(true);
        this.scroller.getViewport().setBackground(color);
        try {
            this.annotationEditor = this.createAnnotationEditor(this.textView, this);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException("Could not initialise the annotation editor!", resourceInstantiationException);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        this.newSetNameTextField = new JTextField();
        this.mainPanel.add((Component)this.newSetNameTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.newSetAction = new NewAnnotationSetAction();
        this.mainPanel.add((Component)new JButton(this.newSetAction), gridBagConstraints);
        this.populateUI();
        this.tableModel.fireTableDataChanged();
        this.eventMinder.start();
        this.initListeners();
    }

    protected OwnedAnnotationEditor createAnnotationEditor(TextualDocumentView textualDocumentView, AnnotationSetsView annotationSetsView) throws ResourceInstantiationException {
        ArrayList<String> arrayList = new ArrayList<String>(Gate.getCreoleRegister().getPublicVrTypes());
        Collections.reverse(arrayList);
        for (String string : arrayList) {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(string);
            try {
                Class<? extends Resource> clazz = resourceData.getResourceClass();
                if (!OwnedAnnotationEditor.class.isAssignableFrom(clazz)) continue;
                OwnedAnnotationEditor ownedAnnotationEditor = (OwnedAnnotationEditor)clazz.newInstance();
                ownedAnnotationEditor.setOwner(this);
                ownedAnnotationEditor.init();
                return ownedAnnotationEditor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Err.prln("Invalid CREOLE data:");
                classNotFoundException.printStackTrace(Err.getPrintWriter());
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        Err.prln("Could not find any annotation editors. Editing annotations disabled.");
        return null;
    }

    protected void populateUI() {
        this.setHandlers.add(new SetHandler(this.document.getAnnotations()));
        ArrayList arrayList = this.document.getNamedAnnotationSets() == null ? new ArrayList() : new ArrayList<String>(this.document.getNamedAnnotationSets().keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.setHandlers.add(new SetHandler(this.document.getAnnotations((String)iterator.next())));
        }
        this.tableRows.addAll(this.setHandlers);
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    public static Color getColor(String string, String string2) {
        Color color;
        Map<String, String> map = Gate.getUserConfig().getMap(AnnotationSetsView.class.getName() + ".colours");
        String string3 = map.get(string + "." + string2);
        if (string3 == null) {
            string3 = map.get(string2);
        }
        if (string3 == null) {
            float[] fArray = colourGenerator.getNextColor().getComponents(null);
            color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
            int n = color.getRGB();
            int n2 = color.getAlpha();
            int n3 = n | n2 << 24;
            map.put(string2, String.valueOf(n3));
            Gate.getUserConfig().put(AnnotationSetsView.class.getName() + ".colours", map);
        } else {
            color = new Color(Integer.valueOf(string3), true);
        }
        return color;
    }

    protected void saveColor(String string, String string2, Color color) {
        Map<String, String> map = Gate.getUserConfig().getMap(AnnotationSetsView.class.getName() + ".colours");
        int n = color.getRGB();
        int n2 = color.getAlpha();
        int n3 = n | n2 << 24;
        String string3 = map.get(string2);
        String string4 = String.valueOf(n3);
        if (string4.equals(string3)) {
            map.remove(string + "." + string2);
        } else {
            map.put(string + "." + string2, string4);
        }
        Gate.getUserConfig().put(AnnotationSetsView.class.getName() + ".colours", map);
    }

    public void saveType(String string, String string2, boolean bl) {
        String string3;
        List<String> list = Gate.getUserConfig().getList(AnnotationSetsView.class.getName() + ".types");
        String string4 = string3 = string == null ? "." : string + ".";
        if (bl) {
            list.add(string3 + string2);
        } else {
            list.remove(string3 + string2);
        }
        Gate.getUserConfig().put(AnnotationSetsView.class.getName() + ".types", list);
    }

    public void restoreSavedSelectedTypes() {
        List<String> list = Gate.getUserConfig().getList(AnnotationSetsView.class.getName() + ".types");
        for (SetHandler setHandler : this.setHandlers) {
            String string = setHandler.set.getName() == null ? "." : setHandler.set.getName() + ".";
            for (TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!list.contains(string + typeHandler.name)) continue;
                typeHandler.setSelected(true);
            }
        }
    }

    public void setNewAnnSetCreationEnabled(boolean bl) {
        this.newSetAction.setEnabled(bl);
        this.newSetNameTextField.setEnabled(bl);
    }

    @Override
    protected void registerHooks() {
        this.textPane.addMouseListener(this.textMouseListener);
        this.textPane.addMouseMotionListener(this.textMouseListener);
        this.textPane.addPropertyChangeListener("highlighter", this.textChangeListener);
        this.restoreSelectedTypes();
    }

    @Override
    protected void unregisterHooks() {
        this.textPane.removeMouseListener(this.textMouseListener);
        this.textPane.removeMouseMotionListener(this.textMouseListener);
        this.textPane.removePropertyChangeListener("highlighter", this.textChangeListener);
        this.storeSelectedTypes();
    }

    protected void storeSelectedTypes() {
        this.visibleAnnotationTypes.clear();
        for (SetHandler setHandler : this.setHandlers) {
            for (TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!typeHandler.isSelected()) continue;
                this.visibleAnnotationTypes.add(new TypeSpec(setHandler.set.getName(), typeHandler.name));
                typeHandler.setSelected(false);
            }
        }
    }

    protected void restoreSelectedTypes() {
        TypeSpec typeSpec;
        while ((typeSpec = (TypeSpec)this.visibleAnnotationTypes.poll()) != null) {
            TypeHandler typeHandler = this.getTypeHandler(typeSpec.setName, typeSpec.type);
            if (typeHandler == null) continue;
            typeHandler.setSelected(true);
        }
    }

    protected void initListeners() {
        this.document.addDocumentListener(this);
        this.mainTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = AnnotationSetsView.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !AnnotationSetsView.this.mainTable.isRowSelected(n)) {
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n = AnnotationSetsView.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = AnnotationSetsView.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 == 1) {
                    Object e = AnnotationSetsView.this.tableRows.get(n);
                    if (mouseEvent.isPopupTrigger()) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        if (e instanceof TypeHandler && AnnotationSetsView.this.mainTable.getSelectedRowCount() == 1) {
                            TypeHandler typeHandler = (TypeHandler)e;
                            jPopupMenu.add(typeHandler.changeColourAction);
                            jPopupMenu.add(new DeleteSelectedAnnotationsAction("Delete"));
                        } else if (AnnotationSetsView.this.mainTable.getSelectedRowCount() > 1 || e instanceof SetHandler) {
                            jPopupMenu.add(new SetSelectedAnnotationsAction(true));
                            jPopupMenu.add(new SetSelectedAnnotationsAction(false));
                            jPopupMenu.add(new DeleteSelectedAnnotationsAction("Delete all"));
                        }
                        if (jPopupMenu.getComponentCount() > 0) {
                            jPopupMenu.show(AnnotationSetsView.this.mainTable, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (mouseEvent.getClickCount() >= 2 && mouseEvent.getID() == 500 && e instanceof TypeHandler) {
                        TypeHandler typeHandler = (TypeHandler)e;
                        typeHandler.changeColourAction.actionPerformed(null);
                    }
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = AnnotationSetsView.this.mainTable.getSelectedRow();
                int n2 = AnnotationSetsView.this.mainTable.getSelectedColumn();
                if (n <= 0 || AnnotationSetsView.this.mainTable.getSelectedRowCount() > 1) {
                    return;
                }
                Object e = AnnotationSetsView.this.tableRows.get(n);
                if (n2 == 1) {
                    if (keyEvent.getKeyCode() == 10 && e instanceof TypeHandler) {
                        TypeHandler typeHandler = (TypeHandler)e;
                        typeHandler.changeColourAction.actionPerformed(null);
                        keyEvent.consume();
                    } else if (keyEvent.getKeyCode() == 32) {
                        if (e instanceof TypeHandler) {
                            TypeHandler typeHandler = (TypeHandler)e;
                            new SetSelectedAnnotationsAction(!typeHandler.selected).actionPerformed(null);
                        } else if (e instanceof SetHandler) {
                            SetHandler setHandler = (SetHandler)e;
                            boolean bl = true;
                            for (TypeHandler typeHandler : setHandler.typeHandlers) {
                                if (!typeHandler.selected) continue;
                                bl = false;
                                break;
                            }
                            new SetSelectedAnnotationsAction(bl).actionPerformed(null);
                        }
                    } else if (keyEvent.getKeyCode() == 37) {
                        if (e instanceof SetHandler) {
                            ((SetHandler)e).setExpanded(false);
                            AnnotationSetsView.this.mainTable.setColumnSelectionInterval(n2, n2);
                            AnnotationSetsView.this.mainTable.setRowSelectionInterval(n, n);
                        }
                        keyEvent.consume();
                    } else if (keyEvent.getKeyCode() == 39) {
                        if (e instanceof SetHandler) {
                            ((SetHandler)e).setExpanded(true);
                            AnnotationSetsView.this.mainTable.setColumnSelectionInterval(n2, n2);
                            AnnotationSetsView.this.mainTable.setRowSelectionInterval(n, n);
                        }
                        keyEvent.consume();
                    }
                }
            }
        });
        this.mouseStoppedMovingAction = new MouseStoppedMovingAction();
        this.mouseMovementTimer = new Timer(500, this.mouseStoppedMovingAction);
        this.mouseMovementTimer.setRepeats(false);
        this.textMouseListener = new TextMouseListener();
        this.textChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    for (SetHandler setHandler : AnnotationSetsView.this.setHandlers) {
                        for (TypeHandler typeHandler : setHandler.typeHandlers) {
                            if (!typeHandler.isSelected()) continue;
                            AnnotationSetsView.this.setTypeSelected(setHandler.set.getName(), typeHandler.name, false);
                            AnnotationSetsView.this.setTypeSelected(setHandler.set.getName(), typeHandler.name, true);
                        }
                    }
                }
            }
        };
        this.mainTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "deleteAll");
        this.mainTable.getInputMap().put(KeyStroke.getKeyStroke("shift DELETE"), "deleteAll");
        this.mainTable.getActionMap().put("deleteAll", new DeleteSelectedAnnotationsAction("Delete"));
        this.newSetNameTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "newSet");
        this.newSetNameTextField.getActionMap().put("newSet", this.newSetAction);
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control E"), "edit annotation");
        this.textPane.getActionMap().put("edit annotation", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(AnnotationSetsView.this.textPane.getCaretPosition());
                AnnotationSetsView.this.mouseStoppedMovingAction.actionPerformed(null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AnnotationSetsView.this.annotationEditor.setPinnedMode(true);
                    }
                });
            }
        });
        InputMap inputMap = this.mainTable.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("TAB");
        final Action action = this.mainTable.getActionMap().get(inputMap.get(keyStroke));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(actionEvent);
                JTable jTable = (JTable)actionEvent.getSource();
                if (jTable.getSelectedColumn() == 0) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        this.mainTable.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("shift TAB");
        final Action action2 = this.mainTable.getActionMap().get(inputMap.get(keyStroke2));
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                action2.actionPerformed(actionEvent);
                JTable jTable = (JTable)actionEvent.getSource();
                if (jTable.getSelectedColumn() == 0) {
                    action2.actionPerformed(actionEvent);
                }
            }
        };
        this.mainTable.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
    }

    @Override
    public void cleanup() {
        this.document.removeDocumentListener(this);
        for (SetHandler setHandler : this.setHandlers) {
            setHandler.set.removeAnnotationSetListener(this);
        }
        this.eventMinder.stop();
        this.pendingEvents.clear();
        super.cleanup();
        this.document = null;
    }

    @Override
    public void annotationSetAdded(DocumentEvent documentEvent) {
        this.pendingEvents.offer(documentEvent);
        this.eventMinder.restart();
    }

    @Override
    public void annotationSetRemoved(DocumentEvent documentEvent) {
        this.pendingEvents.offer(documentEvent);
        this.eventMinder.restart();
    }

    @Override
    public void contentEdited(DocumentEvent documentEvent) {
        for (SetHandler setHandler : this.setHandlers) {
            for (TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!typeHandler.isSelected()) continue;
                typeHandler.repairHighlights(documentEvent.getEditStart().intValue(), documentEvent.getEditEnd().intValue());
            }
        }
    }

    @Override
    public void annotationAdded(AnnotationSetEvent annotationSetEvent) {
        this.pendingEvents.offer(annotationSetEvent);
        this.eventMinder.restart();
    }

    @Override
    public void annotationRemoved(AnnotationSetEvent annotationSetEvent) {
        this.pendingEvents.offer(annotationSetEvent);
        this.eventMinder.restart();
    }

    protected SetHandler getSetHandler(String string) {
        for (SetHandler setHandler : this.setHandlers) {
            if (!(string == null ? setHandler.set.getName() == null : string.equals(setHandler.set.getName()))) continue;
            return setHandler;
        }
        return null;
    }

    public TypeHandler getTypeHandler(String string, String string2) {
        for (TypeHandler typeHandler : this.getSetHandler((String)string).typeHandlers) {
            if (!typeHandler.name.equals(string2)) continue;
            return typeHandler;
        }
        return null;
    }

    public void setTypeSelected(final String string, final String string2, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TypeHandler typeHandler = AnnotationSetsView.this.getTypeHandler(string, string2);
                if (typeHandler != null) {
                    typeHandler.setSelected(bl);
                    int n = AnnotationSetsView.this.tableRows.indexOf(typeHandler);
                    AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                } else {
                    AnnotationSetsView.this.visibleAnnotationTypes.add(new TypeSpec(string, string2));
                }
            }
        });
    }

    @Override
    public void setSelectedAnnotations(List<AnnotationData> list) {
        if (list.size() > 0) {
            final AnnotationData annotationData = list.get(0);
            PerformActionEvent performActionEvent = new PerformActionEvent(new Runnable(){

                public void run() {
                    if (AnnotationSetsView.this.annotationEditor != null && AnnotationSetsView.this.annotationEditor.isActive() && (AnnotationSetsView.this.annotationEditor.getAnnotationSetCurrentlyEdited() != annotationData.getAnnotationSet() || AnnotationSetsView.this.annotationEditor.getAnnotationCurrentlyEdited() != annotationData.getAnnotation())) {
                        AnnotationSetsView.this.annotationEditor.editAnnotation(annotationData.getAnnotation(), annotationData.getAnnotationSet());
                    }
                }
            });
            this.pendingEvents.offer(performActionEvent);
            this.eventMinder.restart();
        }
    }

    public void selectAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        this.selectAnnotation(new AnnotationDataImpl(annotationSet, annotation));
    }

    protected class DeleteSelectedAnnotationsAction
    extends AbstractAction {
        public DeleteSelectedAnnotationsAction(String string) {
            this.putValue("Name", string);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Vector<String> vector = new Vector<String>();
            ArrayList arrayList = new ArrayList();
            int[] nArray = AnnotationSetsView.this.mainTable.getSelectedRows();
            Arrays.sort(nArray);
            for (int n : nArray) {
                Object object32 = AnnotationSetsView.this.tableRows.get(n);
                if (object32 instanceof SetHandler) {
                    arrayList.add(0, object32);
                    object2 = ((SetHandler)object32).set.getName();
                    object2 = object2 == null ? "Default set" : object2;
                    vector.add("set: " + (String)object2);
                    continue;
                }
                if (!(object32 instanceof TypeHandler) || arrayList.contains(((TypeHandler)object32).setHandler)) continue;
                arrayList.add(arrayList.size(), object32);
                object2 = ((TypeHandler)object32).setHandler.set.getName();
                object2 = object2 == null ? "Default set" : object2;
                vector.add("type: " + ((TypeHandler)object32).name + " in set: " + (String)object2);
            }
            if ((actionEvent.getModifiers() & 1) == 0) {
                object = new JList(vector);
                ((JList)object).setVisibleRowCount(Math.min(vector.size() + 1, 10));
                int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), new Object[]{"Are you sure you want to delete the following annotations?", Character.valueOf('\n'), new JScrollPane((Component)object), "<html><i>You can use Shift+Delete to bypass this dialog.</i>\n\n"}, "Delete annotations", -1, 3, null, new String[]{"Delete annotations", "Cancel"}, "Cancel");
                if (n == -1 || n == 1) {
                    return;
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof SetHandler) {
                    SetHandler setHandler = (SetHandler)e;
                    if (setHandler.set == AnnotationSetsView.this.document.getAnnotations()) {
                        for (Annotation annotation : new HashSet<Annotation>(setHandler.set)) {
                            setHandler.set.remove(annotation);
                        }
                        continue;
                    }
                    AnnotationSetsView.this.document.removeAnnotationSet(setHandler.set.getName());
                    continue;
                }
                if (!(e instanceof TypeHandler)) continue;
                TypeHandler typeHandler = (TypeHandler)e;
                AnnotationSet annotationSet = typeHandler.setHandler.set;
                AnnotationSet annotationSet2 = annotationSet.get(typeHandler.name);
                if (annotationSet2 == null || annotationSet2.size() <= 0) continue;
                object2 = new ArrayList<Annotation>(annotationSet2);
                annotationSet.removeAll((Collection<?>)object2);
            }
        }
    }

    protected class SetSelectedAnnotationsAction
    extends AbstractAction {
        boolean selected;

        public SetSelectedAnnotationsAction(boolean bl) {
            String string = bl ? "Select all" : "Unselect all";
            this.putValue("Name", string);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("SPACE"));
            this.selected = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList arrayList = new ArrayList();
            int[] nArray = AnnotationSetsView.this.mainTable.getSelectedRows();
            Arrays.sort(nArray);
            for (int n : nArray) {
                Object object2 = AnnotationSetsView.this.tableRows.get(n);
                if (object2 instanceof SetHandler) {
                    arrayList.add(0, object2);
                    continue;
                }
                if (!(object2 instanceof TypeHandler) || arrayList.contains(((TypeHandler)object2).setHandler)) continue;
                arrayList.add(arrayList.size(), object2);
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof TypeHandler) {
                    TypeHandler typeHandler = (TypeHandler)e;
                    typeHandler.setSelected(this.selected);
                    continue;
                }
                if (!(e instanceof SetHandler)) continue;
                SetHandler setHandler = (SetHandler)e;
                for (String string : setHandler.set.getAllTypes()) {
                    TypeHandler typeHandler = setHandler.getTypeHandler(string);
                    typeHandler.setSelected(this.selected);
                }
            }
        }
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        private AnnotationData aData;

        public EditAnnotationAction(AnnotationData annotationData) {
            super(annotationData.getAnnotation().getType() + " [" + (annotationData.getAnnotationSet().getName() == null ? "  " : annotationData.getAnnotationSet().getName()) + "]");
            this.putValue("ShortDescription", annotationData.getAnnotation().getFeatures().toString());
            this.aData = annotationData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            if (AnnotationSetsView.this.annotationEditor.editingFinished()) {
                AnnotationSetsView.this.selectAnnotation(this.aData);
                AnnotationSetsView.this.annotationEditor.editAnnotation(this.aData.getAnnotation(), this.aData.getAnnotationSet());
            }
        }
    }

    protected class HighlightMenuItem
    extends JMenuItem {
        int start;
        int end;
        Action action;
        Object highlight;

        public HighlightMenuItem(Action action, int n, int n2, JPopupMenu jPopupMenu) {
            super(action);
            this.start = n;
            this.end = n2;
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    HighlightMenuItem.this.showHighlight();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
        }

        protected void showHighlight() {
            try {
                this.highlight = AnnotationSetsView.this.textPane.getHighlighter().addHighlight(this.start, this.end, DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException.toString());
            }
        }

        protected void removeHighlight() {
            if (this.highlight != null) {
                AnnotationSetsView.this.textPane.getHighlighter().removeHighlight(this.highlight);
                this.highlight = null;
            }
        }
    }

    protected class MouseStoppedMovingAction
    extends AbstractAction {
        int textLocation;

        protected MouseStoppedMovingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            if (!AnnotationSetsView.this.annotationEditor.editingFinished()) {
                return;
            }
            if (this.textLocation == -1) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (AnnotationSetsView.this.textPane.getSelectedText() != null && AnnotationSetsView.this.textPane.getSelectionStart() <= this.textLocation && AnnotationSetsView.this.textPane.getSelectionEnd() >= this.textLocation) {
                jPopupMenu.add(new NewAnnotationAction(AnnotationSetsView.this.textPane.getSelectedText()));
                jPopupMenu.addSeparator();
            }
            for (SetHandler setHandler : AnnotationSetsView.this.setHandlers) {
                for (Annotation annotation : setHandler.set.get(Math.max(0L, (long)(this.textLocation - 1)), Math.min(AnnotationSetsView.this.document.getContent().size(), (long)(this.textLocation + 1)))) {
                    if (!setHandler.getTypeHandler(annotation.getType()).isSelected()) continue;
                    AnnotationDataImpl annotationDataImpl = new AnnotationDataImpl(setHandler.set, annotation);
                    jPopupMenu.add(new HighlightMenuItem(new EditAnnotationAction(annotationDataImpl), annotationDataImpl.getAnnotation().getStartNode().getOffset().intValue(), annotationDataImpl.getAnnotation().getEndNode().getOffset().intValue(), jPopupMenu));
                }
            }
            if (jPopupMenu.getComponentCount() != 0) {
                if (jPopupMenu.getComponentCount() == 1 || jPopupMenu.getComponentCount() == 2 && jPopupMenu.getComponent(1) instanceof JSeparator) {
                    ((JMenuItem)jPopupMenu.getComponent(0)).getAction().actionPerformed(actionEvent);
                } else {
                    try {
                        Rectangle rectangle = AnnotationSetsView.this.textPane.modelToView(this.textLocation);
                        jPopupMenu.show(AnnotationSetsView.this.textPane, rectangle.x + 10, rectangle.y);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException);
                    }
                }
            }
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }
    }

    protected class HandleDocumentEventsAction
    extends AbstractAction {
        boolean uiDirty = false;
        private static final int MAX_EVENTS = 300;

        protected HandleDocumentEventsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.uiDirty) {
                this.rebuildDisplay();
                return;
            }
            if (AnnotationSetsView.this.pendingEvents.size() > 300) {
                this.rebuildDisplay();
                return;
            }
            while (!AnnotationSetsView.this.pendingEvents.isEmpty()) {
                Object object;
                Object object2;
                GateEvent gateEvent;
                GateEvent gateEvent2 = (GateEvent)AnnotationSetsView.this.pendingEvents.remove();
                if (gateEvent2 instanceof DocumentEvent) {
                    gateEvent = (DocumentEvent)gateEvent2;
                    if (gateEvent2.getType() == 101) {
                        object2 = ((DocumentEvent)gateEvent).getAnnotationSetName();
                        object = new SetHandler(AnnotationSetsView.this.document.getAnnotations((String)object2));
                        int n = 0;
                        if (object2 != null) {
                            for (n = 1; n < AnnotationSetsView.this.setHandlers.size() && AnnotationSetsView.this.setHandlers.get((int)n).set.getName().compareTo((String)object2) <= 0; ++n) {
                            }
                        }
                        AnnotationSetsView.this.setHandlers.add(n, (SetHandler)object);
                        int n2 = 0;
                        if (n > 0) {
                            SetHandler setHandler = AnnotationSetsView.this.setHandlers.get(n - 1);
                            while (AnnotationSetsView.this.tableRows.get(n2) != setHandler) {
                                ++n2;
                            }
                            if (setHandler.isExpanded()) {
                                n2 += setHandler.typeHandlers.size();
                            }
                            ++n2;
                        }
                        AnnotationSetsView.this.tableRows.add(n2, object);
                        AnnotationSetsView.this.tableModel.fireTableRowsInserted(n2, n2);
                        continue;
                    }
                    if (gateEvent2.getType() != 102 || (object = AnnotationSetsView.this.getSetHandler((String)(object2 = ((DocumentEvent)gateEvent).getAnnotationSetName()))) == null) continue;
                    ((SetHandler)object).set.removeAnnotationSetListener(AnnotationSetsView.this);
                    for (TypeHandler typeHandler : ((SetHandler)object).typeHandlers) {
                        typeHandler.setSelected(false);
                    }
                    AnnotationSetsView.this.setHandlers.remove(object);
                    int n = AnnotationSetsView.this.tableRows.indexOf(object);
                    AnnotationSetsView.this.tableRows.remove(n);
                    int n3 = 1;
                    if (((SetHandler)object).isExpanded()) {
                        for (int i = 0; i < ((SetHandler)object).typeHandlers.size(); ++i) {
                            AnnotationSetsView.this.tableRows.remove(n);
                            ++n3;
                        }
                    }
                    AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n, n + n3 - 1);
                    ((SetHandler)object).cleanup();
                    continue;
                }
                if (gateEvent2 instanceof AnnotationSetEvent) {
                    TypeHandler typeHandler;
                    gateEvent = (AnnotationSetEvent)gateEvent2;
                    object2 = (AnnotationSet)gateEvent.getSource();
                    object = ((AnnotationSetEvent)gateEvent).getAnnotation();
                    if (gateEvent2.getType() == 201) {
                        TypeHandler typeHandler2 = AnnotationSetsView.this.getTypeHandler(object2.getName(), object.getType());
                        if (typeHandler2 == null) {
                            SetHandler setHandler = AnnotationSetsView.this.getSetHandler(object2.getName());
                            typeHandler2 = setHandler.newType(object.getType());
                        }
                        typeHandler2.annotationAdded((Annotation)object);
                        continue;
                    }
                    if (gateEvent2.getType() != 202 || (typeHandler = AnnotationSetsView.this.getTypeHandler(object2.getName(), object.getType())) == null) continue;
                    typeHandler.annotationRemoved((Annotation)object);
                    continue;
                }
                if (!(gateEvent2 instanceof PerformActionEvent)) continue;
                ((PerformActionEvent)gateEvent2).run();
            }
        }

        protected void rebuildDisplay() {
            this.uiDirty = false;
            try {
                GateEvent gateEvent;
                AnnotationSetsView.this.pendingEvents.offer(END_OF_LIST);
                while ((gateEvent = (GateEvent)AnnotationSetsView.this.pendingEvents.poll()) != END_OF_LIST) {
                    if (gateEvent instanceof DocumentEvent || gateEvent instanceof AnnotationSetEvent) continue;
                    AnnotationSetsView.this.pendingEvents.offer(gateEvent);
                }
                AnnotationSetsView.this.storeSelectedTypes();
                for (SetHandler setHandler : AnnotationSetsView.this.setHandlers) {
                    setHandler.typeHandlers.clear();
                    setHandler.typeHandlersByType.clear();
                    setHandler.set.removeAnnotationSetListener(AnnotationSetsView.this);
                }
                AnnotationSetsView.this.setHandlers.clear();
                AnnotationSetsView.this.tableRows.clear();
                AnnotationSetsView.this.listView.removeAnnotations(AnnotationSetsView.this.listView.getAllAnnotations());
                AnnotationSetsView.this.stackView.updateStackView();
                AnnotationSetsView.this.populateUI();
                AnnotationSetsView.this.restoreSelectedTypes();
                AnnotationSetsView.this.tableModel.fireTableDataChanged();
            }
            catch (Throwable throwable) {
                this.uiDirty = true;
            }
        }
    }

    private class PerformActionEvent
    extends GateEvent {
        private Action action;
        private Runnable runnable;

        public PerformActionEvent(Runnable runnable) {
            super(AnnotationSetsView.this, 0);
            this.runnable = runnable;
            this.action = null;
        }

        public PerformActionEvent(Action action) {
            super(AnnotationSetsView.this, 0);
            this.runnable = null;
            this.action = action;
        }

        public void run() {
            if (this.runnable != null) {
                this.runnable.run();
            } else if (this.action != null) {
                this.action.actionPerformed(null);
            }
        }
    }

    protected class SavePreserveFormatAction
    extends AbstractAction {
        public SavePreserveFormatAction() {
            super("Save Preserving Format");
            this.putValue("ShortDescription", "Saves original markups and highlighted annotations");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Object object;
                    Object object2;
                    XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                    ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("XML files", "xml", "gml");
                    xJFileChooser.addChoosableFileFilter(extensionFileFilter);
                    xJFileChooser.setMultiSelectionEnabled(false);
                    xJFileChooser.setFileSelectionMode(0);
                    xJFileChooser.setDialogTitle("Select document to save ...");
                    if (AnnotationSetsView.this.document.getSourceUrl() != null) {
                        object2 = "";
                        try {
                            object2 = AnnotationSetsView.this.document.getSourceUrl().toURI().getPath().trim();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            object2 = AnnotationSetsView.this.document.getSourceUrl().getPath().trim();
                        }
                        if (((String)object2).equals("") || ((String)object2).equals("/")) {
                            if (AnnotationSetsView.this.document.getNamedAnnotationSets().containsKey("Original markups") && !AnnotationSetsView.this.document.getAnnotations("Original markups").get("title").isEmpty()) {
                                try {
                                    object2 = AnnotationSetsView.this.document.getContent().getContent(AnnotationSetsView.this.document.getAnnotations("Original markups").get("title").firstNode().getOffset(), AnnotationSetsView.this.document.getAnnotations("Original markups").get("title").lastNode().getOffset()).toString();
                                }
                                catch (InvalidOffsetException invalidOffsetException) {
                                    invalidOffsetException.printStackTrace();
                                }
                            } else {
                                object2 = AnnotationSetsView.this.document.getSourceUrl().toString();
                            }
                            object2 = ((String)object2).replaceAll("/", "_");
                        } else {
                            object2 = ((String)object2).replaceAll("\\.[a-zA-Z]{1,4}$", ".xml");
                        }
                        object2 = ((String)object2).replaceAll("[^/a-zA-Z0-9._-]", "_");
                        object2 = ((String)object2).replaceAll("__+", "_");
                        if (!((String)object2).endsWith(".xml")) {
                            object2 = (String)object2 + ".xml";
                        }
                        object = new File((String)object2);
                        xJFileChooser.ensureFileIsVisible((File)object);
                        xJFileChooser.setSelectedFile((File)object);
                    }
                    if (xJFileChooser.showSaveDialog(AnnotationSetsView.this.owner) == 0) {
                        object2 = xJFileChooser.getSelectedFile();
                        if (object2 == null) {
                            return;
                        }
                        object = (StatusListener)((Object)MainFrame.getListeners().get("gate.event.StatusListener"));
                        if (object != null) {
                            object.statusChanged("Please wait while dumping annotationsin the original format to " + ((File)object2).toString() + " ...");
                        }
                        HashSet<Annotation> hashSet = new HashSet<Annotation>();
                        for (SetHandler object3 : AnnotationSetsView.this.setHandlers) {
                            for (TypeHandler typeHandler : object3.typeHandlers) {
                                if (!typeHandler.isSelected()) continue;
                                hashSet.addAll(object3.set.get(typeHandler.name));
                            }
                        }
                        try {
                            String exception = ((TextualDocument)AnnotationSetsView.this.document).getEncoding();
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), exception);
                            Boolean bl = Gate.getUserConfig().getBoolean("Save_features_when_preserving_format");
                            boolean bl2 = true;
                            if (bl != null) {
                                bl2 = bl;
                            }
                            outputStreamWriter.write(AnnotationSetsView.this.document.toXml(hashSet, bl2));
                            outputStreamWriter.flush();
                            outputStreamWriter.close();
                            AnnotationSetsView.this.document.setSourceUrl(((File)object2).toURI().toURL());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Out.getPrintWriter());
                        }
                        if (object != null) {
                            object.statusChanged("Finished dumping into the file : " + ((File)object2).toString());
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    protected class NewAnnotationAction
    extends AbstractAction {
        public NewAnnotationAction(String string) {
            super("Create new annotation");
            this.putValue("ShortDescription", "Creates a new annotation from the selection: [" + Strings.crop(string, 30) + "]");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            int n2 = AnnotationSetsView.this.textPane.getSelectionStart();
            if (n2 != (n = AnnotationSetsView.this.textPane.getSelectionEnd())) {
                AnnotationSetsView.this.textPane.setSelectionStart(n2);
                AnnotationSetsView.this.textPane.setSelectionEnd(n2);
                int n3 = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (n3 < 0) {
                    n3 = 0;
                }
                while (!(AnnotationSetsView.this.tableRows.get(n3) instanceof SetHandler)) {
                    --n3;
                }
                AnnotationSet annotationSet = ((SetHandler)AnnotationSetsView.this.tableRows.get((int)n3)).set;
                try {
                    Integer n4 = annotationSet.add(new Long(n2), new Long(n), AnnotationSetsView.this.lastAnnotationType, Factory.newFeatureMap());
                    Annotation annotation = annotationSet.get(n4);
                    if (AnnotationSetsView.this.tableRows.get(n3) instanceof SetHandler) {
                        ((SetHandler)AnnotationSetsView.this.tableRows.get(n3)).setExpanded(true);
                        AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n3, n3);
                    }
                    AnnotationSetsView.this.setTypeSelected(annotationSet.getName(), annotation.getType(), true);
                    AnnotationSetsView.this.pendingEvents.offer(new PerformActionEvent(new EditAnnotationAction(new AnnotationDataImpl(annotationSet, annotation))));
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateRuntimeException(invalidOffsetException);
                }
            }
        }
    }

    protected class NewAnnotationSetAction
    extends AbstractAction {
        public NewAnnotationSetAction() {
            super("New");
            this.putValue("ShortDescription", "Creates a new annotation set");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AnnotationSetsView.this.newSetNameTextField.getText();
            AnnotationSetsView.this.newSetNameTextField.setText("");
            if (string != null && string.length() > 0) {
                AnnotationSet annotationSet = AnnotationSetsView.this.document.getAnnotations(string);
                Iterator iterator = AnnotationSetsView.this.tableRows.iterator();
                int n = -1;
                for (int i = 0; i < AnnotationSetsView.this.tableRows.size() && n < 0; ++i) {
                    if (!(AnnotationSetsView.this.tableRows.get(i) instanceof SetHandler) || ((SetHandler)AnnotationSetsView.this.tableRows.get((int)i)).set != annotationSet) continue;
                    n = i;
                }
                if (n >= 0) {
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        }
    }

    protected class TextMouseListener
    implements MouseInputListener {
        protected TextMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x80) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            if ((n & 0x400) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            int n2 = AnnotationSetsView.this.textPane.viewToModel(mouseEvent.getPoint());
            try {
                block7: {
                    try {
                        Rectangle rectangle = AnnotationSetsView.this.textPane.modelToView(n2);
                        int n3 = 10;
                        rectangle = new Rectangle(rectangle.x - n3, rectangle.y - n3, rectangle.width + 2 * n3, rectangle.height + 2 * n3);
                        if (rectangle.contains(mouseEvent.getPoint())) {
                            AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(n2);
                            break block7;
                        }
                        AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(-1);
                    }
                    catch (BadLocationException badLocationException) {
                        Object var7_8 = null;
                        AnnotationSetsView.this.mouseMovementTimer.restart();
                    }
                }
                Object var7_7 = null;
                AnnotationSetsView.this.mouseMovementTimer.restart();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                AnnotationSetsView.this.mouseMovementTimer.restart();
                throw throwable;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }
    }

    private static class TypeSpec {
        private String setName;
        private String type;

        public TypeSpec(String string, String string2) {
            this.setName = string;
            this.type = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.setName == null ? 0 : this.setName.hashCode());
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TypeSpec typeSpec = (TypeSpec)object;
            if (this.setName == null ? typeSpec.setName != null : !this.setName.equals(typeSpec.setName)) {
                return false;
            }
            return !(this.type == null ? typeSpec.type != null : !this.type.equals(typeSpec.type));
        }
    }

    public class TypeHandler {
        ChangeColourAction changeColourAction;
        boolean selected;
        Map<Integer, Object> hghltTagsForAnnId;
        Map<Integer, AnnotationData> annListTagsForAnn;
        String name;
        SetHandler setHandler;
        Color colour;
        int annotationCount;

        TypeHandler(SetHandler setHandler, String string) {
            this.setHandler = setHandler;
            this.name = string;
            this.colour = AnnotationSetsView.getColor(setHandler.set.getName(), string);
            this.hghltTagsForAnnId = new HashMap<Integer, Object>();
            this.annListTagsForAnn = new HashMap<Integer, AnnotationData>();
            this.changeColourAction = new ChangeColourAction();
            this.annotationCount = 0;
        }

        public Color getColour() {
            return this.colour;
        }

        public void setColour(Color color) {
            int n;
            if (this.colour.equals(color)) {
                return;
            }
            this.colour = color;
            AnnotationSetsView.this.saveColor(this.setHandler.set.getName(), this.name, color);
            if (this.isSelected()) {
                AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnnId.values());
                this.hghltTagsForAnnId.clear();
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
                ArrayList<AnnotationData> arrayList2 = new ArrayList<AnnotationData>();
                for (Annotation annotation : arrayList) {
                    arrayList2.add(new AnnotationDataImpl(this.setHandler.set, annotation));
                }
                List list = AnnotationSetsView.this.textView.addHighlights(arrayList2, this.colour);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.hghltTagsForAnnId.put(((Annotation)arrayList.get(i)).getId(), list.get(i));
                }
            }
            if ((n = AnnotationSetsView.this.tableRows.indexOf(this)) >= 0) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
            }
            if (AnnotationSetsView.this.stackView.isActive()) {
                AnnotationSetsView.this.stackView.updateStackView();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean bl) {
            if (this.selected == bl) {
                return;
            }
            this.selected = bl;
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
            if (bl) {
                this.setHandler.setExpanded(true);
                this.annListTagsForAnn.clear();
                List<AnnotationData> list = AnnotationSetsView.this.listView.addAnnotations(arrayList, this.setHandler.set);
                for (AnnotationData annotationData : list) {
                    this.annListTagsForAnn.put(annotationData.getAnnotation().getId(), annotationData);
                }
                this.hghltTagsForAnnId.clear();
                List list2 = AnnotationSetsView.this.textView.addHighlights(list, this.colour);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.hghltTagsForAnnId.put(((Annotation)arrayList.get(i)).getId(), list2.get(i));
                }
            } else {
                try {
                    AnnotationSetsView.this.listView.removeAnnotations(this.annListTagsForAnn.values());
                    AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnnId.values());
                    Object var7_8 = null;
                    this.hghltTagsForAnnId.clear();
                    this.annListTagsForAnn.clear();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.hghltTagsForAnnId.clear();
                    this.annListTagsForAnn.clear();
                    throw throwable;
                }
            }
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
            AnnotationSetsView.this.saveType(this.setHandler.set.getName(), this.name, bl);
            AnnotationSetsView.this.stackView.updateStackView();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void annotationAdded(Annotation annotation) {
            ++this.annotationCount;
            if (this.selected) {
                if (!this.hghltTagsForAnnId.containsKey(annotation.getId())) {
                    this.hghltTagsForAnnId.put(annotation.getId(), AnnotationSetsView.this.textView.addHighlight(new AnnotationDataImpl(this.setHandler.set, annotation), this.colour));
                }
                if (!this.annListTagsForAnn.containsKey(annotation.getId())) {
                    this.annListTagsForAnn.put(annotation.getId(), AnnotationSetsView.this.listView.addAnnotation(annotation, this.setHandler.set));
                }
                AnnotationSetsView.this.stackView.updateStackView();
            }
        }

        public void annotationRemoved(Annotation annotation) {
            --this.annotationCount;
            if (this.selected) {
                Object object = this.hghltTagsForAnnId.remove(annotation.getId());
                if (object != null) {
                    AnnotationSetsView.this.textView.removeHighlight(object);
                }
                AnnotationData annotationData = this.annListTagsForAnn.remove(annotation.getId());
                if (object != null) {
                    AnnotationSetsView.this.listView.removeAnnotation(annotationData);
                }
                AnnotationSetsView.this.stackView.updateStackView();
            }
            if (this.annotationCount == 0) {
                this.setHandler.removeType(this);
            }
        }

        protected void repairHighlights(int n, int n2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.hghltTagsForAnnId.size());
            ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>(this.hghltTagsForAnnId.size());
            Iterator<Integer> iterator = this.hghltTagsForAnnId.keySet().iterator();
            while (iterator.hasNext()) {
                Annotation annotation = this.setHandler.set.get(iterator.next());
                int n3 = annotation.getStartNode().getOffset().intValue();
                int n4 = annotation.getEndNode().getOffset().intValue();
                if ((n3 > n || n > n4) && (n > n3 || n3 > n2)) continue;
                if (!this.hghltTagsForAnnId.containsKey(annotation.getId())) {
                    System.out.println("Error!!!");
                }
                arrayList.add(this.hghltTagsForAnnId.get(annotation.getId()));
                arrayList2.add(annotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                Annotation annotation = (Annotation)arrayList2.get(i);
                try {
                    AnnotationSetsView.this.textView.moveHighlight(e, annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue());
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected class ChangeColourAction
        extends AbstractAction {
            public ChangeColourAction() {
                super("Change colour");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ENTER"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(AnnotationSetsView.this.mainTable, "Select colour for \"" + TypeHandler.this.name + "\"", TypeHandler.this.colour);
                if (color != null) {
                    Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                    TypeHandler.this.setColour(color2);
                }
            }
        }
    }

    public class SetHandler {
        AnnotationSet set;
        List<TypeHandler> typeHandlers;
        Map typeHandlersByType;
        private boolean expanded = false;

        SetHandler(AnnotationSet annotationSet) {
            this.set = annotationSet;
            this.typeHandlers = new ArrayList<TypeHandler>();
            this.typeHandlersByType = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>(annotationSet.getAllTypes());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                TypeHandler typeHandler = new TypeHandler(this, string);
                typeHandler.annotationCount = annotationSet.get(string).size();
                this.typeHandlers.add(typeHandler);
                this.typeHandlersByType.put(string, typeHandler);
            }
            annotationSet.addAnnotationSetListener(AnnotationSetsView.this);
        }

        public void cleanup() {
            this.set.removeAnnotationSetListener(AnnotationSetsView.this);
            this.typeHandlers.clear();
        }

        public TypeHandler newType(String string) {
            TypeSpec typeSpec;
            int n;
            TypeHandler typeHandler = new TypeHandler(this, string);
            for (n = 0; n < this.typeHandlers.size() && this.typeHandlers.get((int)n).name.compareTo(string) <= 0; ++n) {
            }
            this.typeHandlers.add(n, typeHandler);
            this.typeHandlersByType.put(string, typeHandler);
            int n2 = AnnotationSetsView.this.mainTable.getSelectedRow();
            int n3 = AnnotationSetsView.this.tableRows.indexOf(this);
            if (this.typeHandlers.size() == 1) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n3, n3);
            }
            if (this.expanded) {
                AnnotationSetsView.this.tableRows.add(n3 + n + 1, typeHandler);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(n3 + n + 1, n3 + n + 1);
            }
            if (n2 != -1) {
                AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n2, n2);
            }
            if (AnnotationSetsView.this.visibleAnnotationTypes.remove(typeSpec = new TypeSpec(this.set.getName(), string))) {
                typeHandler.setSelected(true);
            }
            return typeHandler;
        }

        public void removeType(TypeHandler typeHandler) {
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            int n2 = this.typeHandlers.indexOf(typeHandler);
            if (n != -1 && n2 != -1) {
                this.typeHandlers.remove(n2);
                this.typeHandlersByType.remove(typeHandler.name);
                int n3 = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (this.expanded) {
                    AnnotationSetsView.this.tableRows.remove(n + n2 + 1);
                    AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n + n2 + 1, n + n2 + 1);
                }
                if (this.typeHandlers.isEmpty()) {
                    this.setExpanded(false);
                    AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
                }
                if (n3 != -1) {
                    if (AnnotationSetsView.this.mainTable.getRowCount() <= n3) {
                        n3 = AnnotationSetsView.this.mainTable.getRowCount() - 1;
                    }
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n3, n3);
                }
            }
        }

        public void removeType(String string) {
            this.removeType((TypeHandler)this.typeHandlersByType.get(string));
        }

        public TypeHandler getTypeHandler(String string) {
            return (TypeHandler)this.typeHandlersByType.get(string);
        }

        public void setExpanded(boolean bl) {
            if (this.expanded == bl) {
                return;
            }
            this.expanded = bl;
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            if (bl) {
                AnnotationSetsView.this.tableRows.addAll(n + 1, this.typeHandlers);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(n + 1, n + 1 + this.typeHandlers.size());
            } else {
                for (int i = 0; i < this.typeHandlers.size(); ++i) {
                    AnnotationSetsView.this.tableRows.remove(n + 1);
                }
                AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n + 1, n + 1 + this.typeHandlers.size());
            }
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
        }

        public boolean isExpanded() {
            return this.expanded;
        }
    }

    protected class SetsTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JCheckBox currentChk;
        JCheckBox setChk = new JCheckBox();
        JCheckBox typeChk;

        public SetsTableCellEditor() {
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setOpaque(true);
            this.setChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
            this.typeChk = new JCheckBox();
            this.typeChk.setOpaque(false);
            this.typeChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            object = AnnotationSetsView.this.tableRows.get(n);
            if (object instanceof SetHandler) {
                SetHandler setHandler = (SetHandler)object;
                switch (n2) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.setChk.setSelected(setHandler.isExpanded());
                        this.setChk.setEnabled(setHandler.typeHandlers.size() > 0);
                        this.setChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.currentChk = this.setChk;
                        return this.setChk;
                    }
                }
            } else if (object instanceof TypeHandler) {
                TypeHandler typeHandler = (TypeHandler)object;
                switch (n2) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.typeChk.setSelected(typeHandler.isSelected());
                        this.currentChk = this.typeChk;
                        return this.typeChk;
                    }
                }
            }
            return null;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public Object getCellEditorValue() {
            return new Boolean(this.currentChk.isSelected());
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }
    }

    protected class SetsTableCellRenderer
    implements TableCellRenderer {
        protected JLabel typeLabel = new JLabel(){

            public void repaint(long l, int n, int n2, int n3, int n4) {
            }

            public void repaint(Rectangle rectangle) {
            }

            public void validate() {
            }

            public void revalidate() {
            }

            protected void firePropertyChange(String string, Object object, Object object2) {
            }
        };
        protected JLabel setLabel;
        protected JCheckBox setChk;
        protected JCheckBox typeChk;
        protected Border selectedBorder;
        protected Border normalBorder;

        public SetsTableCellRenderer() {
            this.typeLabel.setOpaque(true);
            this.typeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, AnnotationSetsView.this.mainTable.getBackground()), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setLabel = new JLabel(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.setLabel.setOpaque(true);
            this.setLabel.setFont(this.setLabel.getFont().deriveFont(1));
            this.setLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.typeChk = new JCheckBox(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.typeChk.setOpaque(true);
            this.setChk = new JCheckBox(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setMaximumSize(this.setChk.getMinimumSize());
            this.setChk.setOpaque(true);
            this.normalBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getBackground(), 2);
            this.selectedBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getSelectionBackground(), 2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            object = AnnotationSetsView.this.tableRows.get(n);
            if (object instanceof SetHandler) {
                SetHandler setHandler = (SetHandler)object;
                switch (n2) {
                    case 1: {
                        this.setLabel.setText(setHandler.set.getName());
                        this.setLabel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        return this.setLabel;
                    }
                    case 0: {
                        this.setChk.setSelected(setHandler.isExpanded());
                        this.setChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.setChk.setEnabled(setHandler.typeHandlers.size() > 0);
                        return this.setChk;
                    }
                }
            } else if (object instanceof TypeHandler) {
                TypeHandler typeHandler = (TypeHandler)object;
                switch (n2) {
                    case 1: {
                        this.typeLabel.setBackground(typeHandler.colour);
                        this.typeLabel.setText(typeHandler.name);
                        this.typeLabel.setBorder(bl ? this.selectedBorder : this.normalBorder);
                        return this.typeLabel;
                    }
                    case 0: {
                        this.typeChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.typeChk.setSelected(typeHandler.isSelected());
                        return this.typeChk;
                    }
                }
            }
            this.typeLabel.setText("?");
            return this.typeLabel;
        }
    }

    protected class SetsTableModel
    extends AbstractTableModel {
        protected SetsTableModel() {
        }

        public int getRowCount() {
            return AnnotationSetsView.this.tableRows.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 1: {
                    return e;
                }
                case 0: {
                    if (e instanceof SetHandler) {
                        return new Boolean(((SetHandler)e).isExpanded());
                    }
                    if (!(e instanceof TypeHandler)) break;
                    return new Boolean(((TypeHandler)e).isSelected());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (e instanceof SetHandler) {
                        return ((SetHandler)e).typeHandlers.size() > 0;
                    }
                    if (!(e instanceof TypeHandler)) break;
                    return true;
                }
            }
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 0: {
                    if (e instanceof SetHandler) {
                        ((SetHandler)e).setExpanded((Boolean)object);
                        break;
                    }
                    if (!(e instanceof TypeHandler)) break;
                    ((TypeHandler)e).setSelected((Boolean)object);
                    break;
                }
            }
        }
    }
}

