/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.DataStore;
import gate.Document;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.QueryResult;
import gate.creole.ir.QueryResultList;
import gate.creole.ir.SearchPR;
import gate.event.ProgressListener;
import gate.gui.MainFrame;
import gate.swing.XJTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class SearchPRViewer
extends AbstractVisualResource
implements ProgressListener {
    SearchPR target;
    XJTable resultsTable;
    ResultsTableModel resultsTableModel;
    List results;

    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.results = new ArrayList();
    }

    protected void initGuiComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.resultsTableModel = new ResultsTableModel();
        this.resultsTable = new XJTable(this.resultsTableModel);
        this.resultsTable.getColumnModel().getColumn(1).setCellRenderer(new FloatRenderer());
        this.add(new JScrollPane(this.resultsTable));
    }

    protected void initListeners() {
        this.resultsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SearchPRViewer.this.selectDocument((String)SearchPRViewer.this.resultsTable.getValueAt(SearchPRViewer.this.resultsTable.rowAtPoint(mouseEvent.getPoint()), 0));
                }
            }
        });
    }

    protected void selectDocument(String string) {
        int n;
        IndexedCorpus indexedCorpus = this.target.getCorpus();
        for (n = 0; n < indexedCorpus.size() && !indexedCorpus.getDocumentName(n).equals(string); ++n) {
        }
        if (indexedCorpus.getDocumentName(n).equals(string)) {
            Document document = (Document)indexedCorpus.get(n);
            Component component = SwingUtilities.getRoot(this);
            if (component instanceof MainFrame) {
                MainFrame mainFrame = (MainFrame)component;
                mainFrame.select(document);
            }
        }
    }

    public void setTarget(Object object) {
        if (!(object instanceof SearchPR)) {
            throw new IllegalArgumentException("The GATE IR results viewer can only be used with a GATE search PR!\n" + object.getClass().toString() + " is not a GATE search PR!");
        }
        this.target = (SearchPR)object;
        this.target.addProgressListener(this);
    }

    public void progressChanged(int n) {
    }

    public void processFinished() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.results.clear();
        if (this.target != null) {
            QueryResultList queryResultList = this.target.getResult();
            Iterator iterator = queryResultList.getQueryResults();
            while (iterator.hasNext()) {
                this.results.add(iterator.next());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchPRViewer.this.resultsTableModel.fireTableDataChanged();
                }
            });
        }
    }

    protected class FloatRenderer
    extends JProgressBar
    implements TableCellRenderer {
        NumberFormat numberFormat;

        public FloatRenderer() {
            this.setStringPainted(true);
            this.setForeground(new Color(150, 75, 150));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setMinimum(0);
            this.setMaximum(1000);
            this.numberFormat = NumberFormat.getInstance(Locale.getDefault());
            this.numberFormat.setMaximumFractionDigits(3);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            float f = ((Float)object).floatValue();
            this.setValue((int)(f * 1000.0f));
            this.setBackground(jTable.getBackground());
            this.setString(this.numberFormat.format(object));
            return this;
        }

        public boolean isOpaque() {
            Color color = this.getBackground();
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
            return !bl && super.isOpaque();
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text") {
                super.firePropertyChange(string, object, object2);
            }
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    protected class ResultsTableModel
    extends AbstractTableModel {
        private static final int DOC_NAME_COLUMN = 0;
        private static final int DOC_SCORE_COLUMN = 1;

        protected ResultsTableModel() {
        }

        public int getRowCount() {
            return SearchPRViewer.this.results.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Document";
                }
                case 1: {
                    return "Score";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Float.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            QueryResult queryResult = (QueryResult)SearchPRViewer.this.results.get(n);
            switch (n2) {
                case 0: {
                    return this.guessDocName(queryResult.getDocumentID()).toString();
                }
                case 1: {
                    return new Float(queryResult.getScore());
                }
            }
            return null;
        }

        protected Object guessDocName(Object object) {
            IndexedCorpus indexedCorpus = SearchPRViewer.this.target.getCorpus();
            DataStore dataStore = indexedCorpus.getDataStore();
            if (dataStore != null) {
                try {
                    return dataStore.getLrName(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }
    }
}

