/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ResourceData;
import gate.gui.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ResourceRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
TreeCellRenderer {
    public ResourceRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.prepareRendererList(jList, object, bl, this.hasFocus());
        return this;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.prepareRendererTable(jTable, object, bl, bl2, n, n2);
        return this;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.prepareRendererTree(jTree, object, bl, bl4);
        return this;
    }

    private void prepareRendererTable(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        this.setName("Table.cellRenderer");
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            Color color;
            object2 = jTable.getBackground();
            if ((object2 == null || object2 instanceof UIResource) && (color = UIManager.getColor("Table.alternateRowColor")) != null && n % 2 == 0) {
                object2 = color;
            }
            super.setForeground(jTable.getForeground());
            super.setBackground((Color)object2);
        }
        if (bl2) {
            object2 = null;
            if (bl) {
                object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (object2 == null) {
                object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder((Border)object2);
        } else {
            this.setBorder(UIManager.getBorder("Table.cellNoFocusBorder"));
        }
        this.prepareRendererCommon(jTable, object, bl, bl2);
    }

    private void prepareRendererList(JList jList, Object object, boolean bl, boolean bl2) {
        if (bl) {
            this.setForeground(jList.getSelectionForeground());
            this.setBackground(jList.getSelectionBackground());
        } else {
            this.setForeground(jList.getForeground());
            this.setBackground(jList.getBackground());
        }
        this.prepareRendererCommon(jList, object, bl, bl2);
    }

    private void prepareRendererTree(JTree jTree, Object object, boolean bl, boolean bl2) {
        if (bl) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.setForeground(jTree.getForeground());
            this.setBackground(jTree.getBackground());
        }
        this.prepareRendererCommon(jTree, object, bl, bl2);
    }

    private void prepareRendererCommon(JComponent jComponent, Object object, boolean bl, boolean bl2) {
        Icon icon;
        String string;
        String string2;
        this.setFont(jComponent.getFont());
        ResourceData resourceData = null;
        if (object instanceof Resource) {
            string2 = ((Resource)object).getName();
            resourceData = (ResourceData)Gate.getCreoleRegister().get(object.getClass().getName());
        } else {
            String string3 = string2 = object == null ? "<null>" : object.toString();
            if (object == null) {
                this.setForeground(Color.red);
            }
        }
        if (resourceData != null) {
            string = "<HTML>Type: <b>" + resourceData.getName() + "</b></HTML>";
            String string4 = resourceData.getIcon();
            if (string4 == null) {
                if (object instanceof LanguageResource) {
                    string4 = "lr";
                } else if (object instanceof ProcessingResource) {
                    string4 = "pr";
                } else if (object instanceof Controller) {
                    string4 = "application";
                }
            }
            icon = string4 == null ? null : MainFrame.getIcon(string4);
        } else {
            icon = null;
            string = null;
        }
        this.setText(string2);
        this.setIcon(icon);
        this.setToolTipText(string);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension != null) {
            dimension.width = Integer.MAX_VALUE;
            this.setMaximumSize(dimension);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void repaint() {
    }
}

