/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.swing.XJTextPane;
import gate.util.Err;
import gate.util.Out;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogArea
extends XJTextPane {
    protected LogArea thisLogArea = this;
    protected JPopupMenu popup = null;
    protected Position startPos;
    protected Position endPos;
    protected PrintStream originalOut;
    protected PrintStream originalErr;
    protected SelectAllAction selectAllAction = null;
    protected CopyAction copyAction = null;
    protected ClearAllAction clearAllAction = null;

    public LogArea() {
        this.setEditable(false);
        LogAreaOutputStream logAreaOutputStream = new LogAreaOutputStream(true);
        LogAreaOutputStream logAreaOutputStream2 = new LogAreaOutputStream(false);
        try {
            Err.setPrintWriter(new UTF8PrintWriter(logAreaOutputStream, true));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        try {
            Out.setPrintWriter(new UTF8PrintWriter(logAreaOutputStream2, true));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.originalOut = System.out;
        try {
            System.setOut(new UTF8PrintStream(logAreaOutputStream2, true));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.originalErr = System.err;
        try {
            System.setErr(new UTF8PrintStream(logAreaOutputStream, true));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace(this.originalErr);
        }
        this.popup = new JPopupMenu();
        this.selectAllAction = new SelectAllAction();
        this.copyAction = new CopyAction();
        this.clearAllAction = new ClearAllAction();
        this.startPos = this.getDocument().getStartPosition();
        this.endPos = this.getDocument().getEndPosition();
        this.popup.add(this.selectAllAction);
        this.popup.add(this.copyAction);
        this.popup.addSeparator();
        this.popup.add(this.clearAllAction);
        this.initListeners();
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        this.startPos = document.getStartPosition();
        this.endPos = document.getEndPosition();
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        this.setDocument(styledDocument);
    }

    public void initListeners() {
        super.initListeners();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    LogArea.this.popup.show(LogArea.this.thisLogArea, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        });
    }

    public PrintStream getOriginalErr() {
        return this.originalErr;
    }

    public PrintStream getOriginalOut() {
        return this.originalOut;
    }

    private void handleBadLocationException(BadLocationException badLocationException, String string, Style style) {
        this.originalErr.println("BadLocationException encountered when writing to the log area: " + badLocationException);
        this.originalErr.println("trying to recover...");
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("An error occurred when trying to write a message to the log area.  The log\n");
            stringBuilder.append("has been cleared to try and recover from this problem.\n\n");
            stringBuilder.append(string);
            defaultStyledDocument.insertString(0, stringBuilder.toString(), style);
        }
        catch (BadLocationException badLocationException2) {
            badLocationException2.printStackTrace(this.originalErr);
            return;
        }
        this.setDocument(defaultStyledDocument);
    }

    class LogAreaOutputStream
    extends OutputStream {
        private boolean isErr = false;
        private Style style = null;

        public LogAreaOutputStream(boolean bl) {
            this.isErr = bl;
            if (this.isErr) {
                this.style = LogArea.this.addStyle("error", LogArea.this.getStyle("default"));
                StyleConstants.setForeground(this.style, Color.red);
            } else {
                this.style = LogArea.this.addStyle("out", LogArea.this.getStyle("default"));
                StyleConstants.setForeground(this.style, Color.black);
            }
        }

        public void write(int n) {
            char c = (char)(n &= 0xFF);
            SwingUtilities.invokeLater(new SwingWriter(String.valueOf(c), this.style));
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                SwingUtilities.invokeLater(new SwingWriter(new String(byArray, n, n2, "UTF-8"), this.style));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace(LogArea.this.originalErr);
            }
        }
    }

    protected class ClearAllAction
    extends AbstractAction {
        public ClearAllAction() {
            super("Clear all");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LogArea.this.thisLogArea.getDocument().remove(LogArea.this.startPos.getOffset(), LogArea.this.endPos.getOffset() - LogArea.this.startPos.getOffset() - 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    public static class UTF8PrintStream
    extends PrintStream {
        public UTF8PrintStream(OutputStream outputStream) throws UnsupportedEncodingException {
            this(outputStream, true);
        }

        public UTF8PrintStream(OutputStream outputStream, boolean bl) throws UnsupportedEncodingException {
            super(outputStream, bl);
        }

        public void print(String string) {
            try {
                this.write(string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                this.setError();
            }
        }

        public void print(char[] cArray) {
            this.print(String.valueOf(cArray));
        }
    }

    public static class UTF8PrintWriter
    extends PrintWriter {
        public UTF8PrintWriter(OutputStream outputStream) throws UnsupportedEncodingException {
            this(outputStream, true);
        }

        public UTF8PrintWriter(OutputStream outputStream, boolean bl) throws UnsupportedEncodingException {
            super((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), bl);
        }
    }

    protected class SwingWriter
    implements Runnable {
        String text;
        Style style;

        SwingWriter(String string, Style style) {
            this.text = string;
            this.style = style;
        }

        public void run() {
            try {
                Rectangle rectangle;
                if (LogArea.this.endPos.getOffset() > 1 && (rectangle = LogArea.this.modelToView(LogArea.this.endPos.getOffset() - 1)) != null) {
                    LogArea.this.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                LogArea.this.originalErr.println("Exception encountered when trying to scroll to end of messages pane: " + badLocationException);
            }
            try {
                LogArea.this.getDocument().insertString(LogArea.this.endPos.getOffset() - 1, this.text, this.style);
            }
            catch (BadLocationException badLocationException) {
                LogArea.this.handleBadLocationException(badLocationException, this.text, this.style);
            }
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LogArea.this.thisLogArea.copy();
        }
    }

    protected class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select all");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LogArea.this.thisLogArea.selectAll();
        }
    }
}

