/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.FeatureMapListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.ResizableVisualResource;
import gate.swing.XJTable;
import gate.util.FeatureBearer;
import gate.util.GateRuntimeException;
import gate.util.ObjectComparator;
import gate.util.Strings;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

@CreoleResource(name="Features", guiType=GuiType.SMALL, resourceDisplayed="gate.util.FeatureBearer")
public class FeaturesSchemaEditor
extends XJTable
implements ResizableVisualResource,
FeatureMapListener {
    FeatureMap targetFeatures;
    FeatureBearer target;
    Feature emptyFeature;
    AnnotationSchema schema;
    FeaturesTableModel featuresModel;
    List<Feature> featureList;
    FeatureEditorRenderer featureEditorRenderer;
    FeaturesSchemaEditor instance = this;
    private static final int COLUMNS = 4;
    private static final int ICON_COL = 0;
    private static final int NAME_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int DELETE_COL = 3;
    private static final Color REQUIRED_WRONG = Color.RED;
    private static final Color OPTIONAL_WRONG = Color.ORANGE;
    protected FeatureMap features;
    protected Handle handle;

    public void setTargetFeatures(FeatureMap featureMap) {
        if (this.targetFeatures != null) {
            this.targetFeatures.removeFeatureMapListener(this);
        }
        this.targetFeatures = featureMap;
        this.populate();
        if (this.targetFeatures != null) {
            this.targetFeatures.addFeatureMapListener(this);
        }
    }

    public void cleanup() {
        if (this.targetFeatures != null) {
            this.targetFeatures.removeFeatureMapListener(this);
            this.targetFeatures = null;
        }
        this.target = null;
        this.schema = null;
    }

    public void setTarget(Object object) {
        this.target = (FeatureBearer)object;
        this.setTargetFeatures(this.target.getFeatures());
    }

    public void setSchema(AnnotationSchema annotationSchema) {
        this.schema = annotationSchema;
        this.featuresModel.fireTableRowsUpdated(0, this.featureList.size() - 1);
    }

    public void featureMapUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FeaturesSchemaEditor.this.populate();
            }
        });
    }

    public Resource init() throws ResourceInstantiationException {
        this.featureList = new ArrayList<Feature>();
        this.emptyFeature = new Feature("", null);
        this.featureList.add(this.emptyFeature);
        this.initGUI();
        return this;
    }

    protected void initGUI() {
        this.featuresModel = new FeaturesTableModel();
        this.setModel(this.featuresModel);
        this.setTableHeader(null);
        this.setSortable(false);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setBackground(this.getBackground());
        this.setIntercellSpacing(new Dimension(2, 2));
        this.setTabSkipUneditableCell(true);
        this.setEditCellAsSoonAsFocus(true);
        this.featureEditorRenderer = new FeatureEditorRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(1).setCellEditor(this.featureEditorRenderer);
        this.getColumnModel().getColumn(2).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(2).setCellEditor(this.featureEditorRenderer);
        this.getColumnModel().getColumn(3).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(3).setCellEditor(this.featureEditorRenderer);
        Color color = this.getBackground();
        color = new Color(color.getRGB());
        this.setBackground(color);
        this.setSurrendersFocusOnKeystroke(true);
        this.setFocusCycleRoot(true);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        hashSet.remove(KeyStroke.getKeyStroke("control TAB"));
        this.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        hashSet.remove(KeyStroke.getKeyStroke("shift control TAB"));
        this.setFocusTraversalKeys(1, hashSet);
        hashSet.clear();
        hashSet.add(KeyStroke.getKeyStroke("control TAB"));
        this.setFocusTraversalKeys(2, hashSet);
        hashSet.clear();
        hashSet.add(KeyStroke.getKeyStroke("shift control TAB"));
        this.setFocusTraversalKeys(3, hashSet);
    }

    protected void populate() {
        this.featureList.clear();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.targetFeatures != null) {
            hashSet.addAll(this.targetFeatures.keySet());
            if (this.schema != null && this.schema.getFeatureSchemaSet() != null) {
                for (FeatureSchema object2 : this.schema.getFeatureSchemaSet()) {
                    hashSet.add(object2.getFeatureName());
                }
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = (String)e;
                Object v = this.targetFeatures.get(string);
                this.featureList.add(new Feature(string, v));
            }
        }
        if (!this.featureList.contains(this.emptyFeature)) {
            this.featureList.add(this.emptyFeature);
        }
        this.featuresModel.fireTableDataChanged();
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public Object getParameterValue(String string) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, string);
    }

    public void setParameterValue(String string, Object object) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        AbstractResource.setParameterValue(this, beanInfo, string, object);
    }

    public void setParameterValues(FeatureMap featureMap) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, featureMap);
    }

    protected class FeatureEditorRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        JLabel requiredIconLabel;
        JLabel optionalIconLabel;
        JLabel nonSchemaIconLabel;
        JComboBox editorCombo;
        JComboBox rendererCombo;
        JButton deleteButton;
        ObjectComparator defaultComparator;

        public FeatureEditorRenderer() {
            super(new JComboBox());
            this.defaultComparator = new ObjectComparator();
            this.editorCombo = (JComboBox)this.editorComponent;
            this.editorCombo.setModel(new DefaultComboBoxModel());
            this.editorCombo.setBackground(FeaturesSchemaEditor.this.getBackground());
            this.editorCombo.setEditable(true);
            this.editorCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FeatureEditorRenderer.this.stopCellEditing();
                }
            });
            this.rendererCombo = new JComboBox(){

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.rendererCombo.setModel(new DefaultComboBoxModel());
            this.rendererCombo.setBackground(FeaturesSchemaEditor.this.getBackground());
            this.rendererCombo.setEditable(true);
            this.rendererCombo.setOpaque(false);
            this.requiredIconLabel = new JLabel(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.requiredIconLabel.setIcon(MainFrame.getIcon("r"));
            this.requiredIconLabel.setOpaque(false);
            this.requiredIconLabel.setToolTipText("Required feature");
            this.optionalIconLabel = new JLabel(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.optionalIconLabel.setIcon(MainFrame.getIcon("o"));
            this.optionalIconLabel.setOpaque(false);
            this.optionalIconLabel.setToolTipText("Optional feature");
            this.nonSchemaIconLabel = new JLabel(MainFrame.getIcon("c")){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.nonSchemaIconLabel.setToolTipText("Custom feature");
            this.nonSchemaIconLabel.setOpaque(false);
            this.deleteButton = new JButton(MainFrame.getIcon("delete"));
            this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
            this.deleteButton.setToolTipText("Delete");
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FeaturesSchemaEditor.this.getEditingRow();
                    if (n < 0) {
                        return;
                    }
                    Feature feature = FeaturesSchemaEditor.this.featureList.get(n);
                    if (feature == FeaturesSchemaEditor.this.emptyFeature) {
                        feature.value = null;
                    } else {
                        FeaturesSchemaEditor.this.featureList.remove(n);
                        FeaturesSchemaEditor.this.targetFeatures.remove(feature.name);
                        FeaturesSchemaEditor.this.featuresModel.fireTableRowsDeleted(n, n);
                    }
                }
            });
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(n);
            switch (n2) {
                case 0: {
                    return feature.isSchemaFeature() ? (feature.isRequired() ? this.requiredIconLabel : this.optionalIconLabel) : this.nonSchemaIconLabel;
                }
                case 1: {
                    this.prepareCombo(this.rendererCombo, n, n2);
                    this.rendererCombo.getPreferredSize();
                    return this.rendererCombo;
                }
                case 2: {
                    this.prepareCombo(this.rendererCombo, n, n2);
                    return this.rendererCombo;
                }
                case 3: {
                    return this.deleteButton;
                }
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            switch (n2) {
                case 1: {
                    this.prepareCombo(this.editorCombo, n, n2);
                    return this.editorCombo;
                }
                case 2: {
                    this.prepareCombo(this.editorCombo, n, n2);
                    return this.editorCombo;
                }
                case 3: {
                    return this.deleteButton;
                }
            }
            return null;
        }

        protected void prepareCombo(JComboBox jComboBox, int n, int n2) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(n);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            defaultComboBoxModel.removeAllElements();
            switch (n2) {
                case 1: {
                    Iterator<Object> iterator;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (FeaturesSchemaEditor.this.schema != null && FeaturesSchemaEditor.this.schema.getFeatureSchemaSet() != null) {
                        iterator = FeaturesSchemaEditor.this.schema.getFeatureSchemaSet().iterator();
                        while (iterator.hasNext()) {
                            arrayList.add(((FeatureSchema)iterator.next()).getFeatureName());
                        }
                    }
                    if (!arrayList.contains(feature.name)) {
                        arrayList.add(feature.name);
                    }
                    Collections.sort(arrayList);
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        defaultComboBoxModel.addElement(iterator.next());
                    }
                    jComboBox.getEditor().getEditorComponent().setBackground(FeaturesSchemaEditor.this.getBackground());
                    jComboBox.setSelectedItem(feature.name);
                    break;
                }
                case 2: {
                    Object object;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (feature.isSchemaFeature() && (object = FeaturesSchemaEditor.this.schema.getFeatureSchema(feature.name).getPermittedValues()) != null) {
                        arrayList.addAll((Collection<Object>)object);
                    }
                    if (!arrayList.contains(feature.value)) {
                        arrayList.add(feature.value);
                    }
                    Collections.sort(arrayList, this.defaultComparator);
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        defaultComboBoxModel.addElement(object.next());
                    }
                    jComboBox.getEditor().getEditorComponent().setBackground(feature.isCorrect() ? FeaturesSchemaEditor.this.getBackground() : (feature.isRequired() ? REQUIRED_WRONG : OPTIONAL_WRONG));
                    jComboBox.setSelectedItem(feature.value);
                    break;
                }
            }
        }
    }

    protected class FeaturesTableModel
    extends AbstractTableModel {
        protected FeaturesTableModel() {
        }

        public int getRowCount() {
            return FeaturesSchemaEditor.this.featureList.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int n, int n2) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(n);
            switch (n2) {
                case 1: {
                    return feature.name;
                }
                case 2: {
                    return feature.value;
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 || n2 == 1 || n2 == 3;
        }

        public void setValueAt(Object object, int n, int n2) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(n);
            if (feature == null) {
                return;
            }
            if (FeaturesSchemaEditor.this.targetFeatures == null) {
                FeaturesSchemaEditor.this.targetFeatures = Factory.newFeatureMap();
                FeaturesSchemaEditor.this.target.setFeatures(FeaturesSchemaEditor.this.targetFeatures);
                FeaturesSchemaEditor.this.setTargetFeatures(FeaturesSchemaEditor.this.targetFeatures);
            }
            switch (n2) {
                case 2: {
                    if (feature.value != null && feature.value.equals(object)) {
                        return;
                    }
                    feature.value = object;
                    if (feature.name == null || feature.name.length() <= 0) break;
                    FeaturesSchemaEditor.this.targetFeatures.removeFeatureMapListener(FeaturesSchemaEditor.this.instance);
                    FeaturesSchemaEditor.this.targetFeatures.put(feature.name, object);
                    FeaturesSchemaEditor.this.targetFeatures.addFeatureMapListener(FeaturesSchemaEditor.this.instance);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FeaturesSchemaEditor.this.editCellAt(FeaturesSchemaEditor.this.getRowCount() - 1, 1);
                        }
                    });
                    break;
                }
                case 1: {
                    int n3;
                    if (feature.name.equals(object)) {
                        return;
                    }
                    FeaturesSchemaEditor.this.targetFeatures.remove(feature.name);
                    feature.name = (String)object;
                    FeaturesSchemaEditor.this.targetFeatures.put(feature.name, feature.value);
                    if (feature == FeaturesSchemaEditor.this.emptyFeature) {
                        FeaturesSchemaEditor.this.emptyFeature = new Feature("", null);
                    }
                    FeaturesSchemaEditor.this.populate();
                    for (n3 = 0; n3 < FeaturesSchemaEditor.this.getRowCount() && !FeaturesSchemaEditor.this.getValueAt(n3, 1).equals(feature.name); ++n3) {
                    }
                    final int n4 = n3;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FeaturesSchemaEditor.this.editCellAt(n4, 2);
                        }
                    });
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new GateRuntimeException("Non editable cell!");
                }
            }
        }

        public String getColumnName(int n) {
            switch (n) {
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Value";
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }
    }

    protected class Feature {
        String name;
        Object value;

        public Feature(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        boolean isSchemaFeature() {
            return FeaturesSchemaEditor.this.schema != null && FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name) != null;
        }

        boolean isCorrect() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return true;
            }
            FeatureSchema featureSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return featureSchema == null || featureSchema.getPermittedValues() == null || featureSchema.getPermittedValues().contains(this.value);
        }

        boolean isRequired() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return false;
            }
            FeatureSchema featureSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return featureSchema != null && featureSchema.isRequired();
        }

        Object getDefaultValue() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return null;
            }
            FeatureSchema featureSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return featureSchema == null ? null : featureSchema.getFeatureValue();
        }
    }
}

