/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.gui.FeaturesSchemaEditor;
import gate.util.FeatureBearer;
import gate.util.LuckyException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FeatureMapEditorDialog
extends JDialog {
    FeatureBearer tempFMHolder = new FeatureBearer(){
        private FeatureMap fm;

        public void setFeatures(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public FeatureMap getFeatures() {
            return this.fm;
        }
    };
    FeaturesSchemaEditor fmView;
    JButton okButton;
    JButton cancelButton;
    boolean userCancelled;

    public FeatureMapEditorDialog(Component component, FeatureMap featureMap) {
        this.setLocationRelativeTo(component);
        this.initLocalData(featureMap);
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData(FeatureMap featureMap) {
        if (featureMap != null) {
            FeatureMap featureMap2 = Factory.newFeatureMap();
            featureMap2.putAll(featureMap);
            this.tempFMHolder.setFeatures(featureMap2);
        }
    }

    protected void initGuiComponents() {
        this.setMinimumSize(new Dimension(150, 300));
        this.getContentPane().setLayout(new BorderLayout());
        this.fmView = new FeaturesSchemaEditor();
        try {
            this.fmView.init();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new LuckyException("FeaturesSchemaEditor.init() threw ResourceInstantiationException!");
        }
        this.fmView.setTarget(this.tempFMHolder);
        Dimension dimension = this.fmView.getPreferredSize();
        if (dimension.height < 150) {
            dimension.height = 150;
        } else if (dimension.height > 300) {
            dimension.height = 300;
        }
        this.fmView.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.fmView, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        box.add(this.okButton);
        box.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton("Cancel");
        box.add(this.cancelButton);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)box, "South");
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FeatureMapEditorDialog.this.userCancelled = false;
                FeatureMapEditorDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FeatureMapEditorDialog.this.userCancelled = true;
                FeatureMapEditorDialog.this.setVisible(false);
            }
        });
    }

    public FeatureMap showDialog() {
        this.pack();
        this.userCancelled = true;
        this.setModal(true);
        super.setVisible(true);
        return this.userCancelled ? null : this.tempFMHolder.getFeatures();
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo frame");
        FeatureMapEditorDialog featureMapEditorDialog = new FeatureMapEditorDialog((Component)jFrame, null);
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
        System.out.println(featureMapEditorDialog.showDialog());
    }
}

