/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.fsm.RuleTime;
import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.JapeConstants;
import gate.jape.RightHandSide;
import gate.util.SimpleArraySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements JapeConstants {
    private static final boolean DEBUG = false;
    public static final int UNKNOWN_INDEX = 1;
    public static final int VISITED_INDEX = -2;
    public static final int UNVISITED_INDEX = 2;
    public static final int INITIAL_INDEX = 0;
    public static final String INITIAL_RULE = "_____Initial_State_for_all_rules";
    public static final String UNKNOWN_RULE = "___UNKNOWN_RULES_TYPE_1";
    public static final String UNVISITED_RULE = "___UNKNOWN_RULES_TYPE_2";
    private int indexInRuleList = 2;
    private SimpleArraySet<Transition> transitions = new SimpleArraySet();
    protected boolean isFinal = false;
    protected RightHandSide action = null;
    protected int myIndex = index++;
    protected static int index = 0;
    protected int fileIndex = 0;
    protected int priority = -1;

    public int getIndexInRuleList() {
        return this.indexInRuleList;
    }

    void setIndexInRuleList(int n) {
        this.indexInRuleList = n;
    }

    public int getRuleForState(HashMap<String, Integer> hashMap, ArrayList<RuleTime> arrayList) {
        if (this.getIndexInRuleList() != 2) {
            return this.getIndexInRuleList();
        }
        if (this.isFinal()) {
            int n;
            String string = this.getAction().getRuleName();
            if (hashMap.containsKey(string)) {
                n = hashMap.get(string);
            } else {
                arrayList.add(new RuleTime(0L, string));
                hashMap.put(string, arrayList.size() - 1);
                n = arrayList.size() - 1;
            }
            this.setIndexInRuleList(n);
            return n;
        }
        this.setIndexInRuleList(-2);
        int n = 1;
        for (Transition transition : this.getTransitions()) {
            int n2 = transition.getTarget().getRuleForState(hashMap, arrayList);
            if (n2 == 1 || n2 == -2) continue;
            n = n2;
        }
        if (n == 1) {
            this.setIndexInRuleList(n);
        } else {
            this.propogateRuleForward(n);
        }
        return n;
    }

    private void propogateRuleForward(int n) {
        this.setIndexInRuleList(n);
        for (Transition transition : this.getTransitions()) {
            if (transition.getTarget().getIndexInRuleList() != 1) continue;
            transition.getTarget().propogateRuleForward(n);
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public SimpleArraySet<Transition> getTransitions() {
        return this.transitions;
    }

    protected void setAction(RightHandSide rightHandSide) {
        this.action = rightHandSide;
        this.isFinal = this.action != null;
    }

    protected void setFileIndex(int n) {
        this.fileIndex = n;
    }

    protected void setPriority(int n) {
        this.priority = n;
    }

    public RightHandSide getAction() {
        return this.action;
    }

    int getFileIndex() {
        return this.fileIndex;
    }

    int getPriority() {
        return this.priority;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public int getIndex() {
        return this.myIndex;
    }

    public String getEdgesGML() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        for (Transition transition : this.transitions) {
            stringBuffer.append("edge [ source ");
            stringBuffer.append(this.myIndex);
            stringBuffer.append(" target ");
            stringBuffer.append(transition.getTarget().getIndex());
            stringBuffer.append(" label \"");
            stringBuffer.append(transition.shortDesc());
            stringBuffer.append(":");
            BasicPatternElement basicPatternElement = transition.getConstraints();
            if (basicPatternElement == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(basicPatternElement.shortDesc());
            }
            stringBuffer.append(" :");
            stringBuffer.append(transition.getBindings());
            stringBuffer.append("\" ]\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.isFinal()) {
            stringBuffer.append("\nFinal!");
        }
        stringBuffer.append("\nTransitions:\n");
        Iterator<Transition> iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Object)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }
}

