/*
 * Decompiled with CFR 0.152.
 */
package gate.email;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.event.StatusListener;
import gate.util.InvalidOffsetException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Assert;

public class EmailDocumentHandler {
    private static final boolean DEBUG = false;
    private String content = null;
    private long documentSize = 0L;
    private static final int EMAILS_RATE = 16;
    private String tmpDocContent = null;
    private Document gateDocument = null;
    private AnnotationSet basicAS = null;
    private Map markupElementsMap = null;
    private Map element2StringMap = null;
    protected List myStatusListeners = new LinkedList();
    private int emails = 0;
    private String fieldName = null;
    private Collection day = null;
    private Collection month = null;
    private Collection zone = null;

    public EmailDocumentHandler() {
        this.setUp();
    }

    public EmailDocumentHandler(Document document, Map map, Map map2) {
        this.gateDocument = document;
        if (this.basicAS == null) {
            this.basicAS = this.gateDocument.getAnnotations("Original markups");
        }
        this.markupElementsMap = map;
        this.element2StringMap = map2;
        this.setUp();
    }

    public void annotateMessages() throws IOException, InvalidOffsetException {
        BufferedReader bufferedReader = null;
        this.content = this.gateDocument.getContent().toString();
        this.documentSize = this.gateDocument.getContent().size();
        bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.content.getBytes())));
        String string = null;
        String string2 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l10 = this.detectNLSize();
        while ((string = bufferedReader.readLine()) != null) {
            if (this.lineBeginsMessage(string)) {
                if (++this.emails % 16 == 0) {
                    this.fireStatusChangedEvent("Reading emails : " + this.emails);
                }
                if (bl4) {
                    l2 = l - l10;
                    l6 = l - l10;
                    this.createAnnotation("Body", l7, l6, null);
                    this.createAnnotation("Message", l3, l2, null);
                }
                bl4 = true;
                l3 = l;
                l5 = l;
                l += (long)string.length() + l10;
                bl = true;
                bl2 = true;
                bl5 = false;
                continue;
            }
            if (!bl) {
                l += (long)string.length() + l10;
                continue;
            }
            if (bl2) {
                if (string.equals("")) {
                    bl2 = false;
                    l4 = l - l10;
                    l7 = l += (long)string.length() + l10;
                    if (!bl5) continue;
                    l8 = l4;
                    this.createAnnotation(string2, l9, l8, null);
                    this.createAnnotation("Header", l5, l4, null);
                    continue;
                }
                if (this.lineBeginsWithField(string)) {
                    if (bl5) {
                        l8 = l - l10;
                        this.createAnnotation(string2, l9, l8, null);
                    }
                    bl5 = true;
                    string2 = this.getFieldName();
                    l9 = l + (long)string2.length() + (long)":".length();
                }
                l += (long)string.length() + l10;
                continue;
            }
            l += (long)string.length() + l10;
        }
        if (bl4) {
            l6 = l - l10;
            l2 = l - l10;
            this.createAnnotation("Body", l7, l6, null);
            this.createAnnotation("Message", l3, l2, null);
        }
    }

    private int detectNLSize() {
        char[] cArray = null;
        cArray = this.gateDocument.getContent().toString().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            if (i + 1 < cArray.length && cArray[i + 1] == '\r' || i - 1 >= 0 && cArray[i - 1] == '\r') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void createAnnotation(String string, long l, long l2, FeatureMap featureMap) throws InvalidOffsetException {
        if (this.canCreateAnnotation(l, l2, this.documentSize)) {
            if (featureMap == null) {
                featureMap = Factory.newFeatureMap();
            }
            this.basicAS.add(new Long(l), new Long(l2), string.toLowerCase(), featureMap);
        }
    }

    private boolean canCreateAnnotation(long l, long l2, long l3) {
        if (l < 0L || l2 < 0L) {
            return false;
        }
        if (l > l2) {
            return false;
        }
        return l <= l3 && l2 <= l3;
    }

    private boolean lineBeginsMessage(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = null;
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string2.trim();
        if (!string2.equals("From")) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3.trim();
            if (!this.hasAMeaning(string3)) continue;
            ++n;
        }
        return n >= 5;
    }

    private boolean lineBeginsWithField(String string) {
        if (this.containsSemicolon(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string2 = null;
            if (!stringTokenizer.hasMoreTokens()) {
                return false;
            }
            string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                string2.trim();
                if (this.containsWhiteSpaces(string2)) {
                    return false;
                }
                this.fieldName = string2;
            }
            return true;
        }
        return false;
    }

    private boolean containsWhiteSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean containsSemicolon(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            return true;
        }
        return false;
    }

    private boolean hasAMeaning(String string) {
        if (this.day.contains(string)) {
            return true;
        }
        if (this.month.contains(string)) {
            return true;
        }
        if (this.zone.contains(string)) {
            return true;
        }
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        if (n != null) {
            int n2 = n;
            if (n2 > 0 && n2 < 32) {
                return true;
            }
            if (n2 > 1900 && n2 < 3000) {
                return true;
            }
            if (n2 >= 0 && n2 <= 99) {
                return true;
            }
        }
        return this.isTime(string);
    }

    private boolean isTime(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2 == null) {
            return false;
        }
        Integer n = null;
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        if (n == null) {
            return false;
        }
        int n2 = n;
        if (n2 < 0 || n2 > 23) {
            return false;
        }
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 == null) {
            return false;
        }
        Integer n3 = null;
        try {
            n3 = new Integer(string3);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = null;
        }
        if (n3 == null) {
            return false;
        }
        int n4 = n3;
        if (n4 < 0 || n4 > 59) {
            return false;
        }
        String string4 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string4 == null) {
            return false;
        }
        Integer n5 = null;
        try {
            n5 = new Integer(string4);
        }
        catch (NumberFormatException numberFormatException) {
            n5 = null;
        }
        if (n5 == null) {
            return false;
        }
        int n6 = n5;
        if (n6 < 0 || n6 > 59) {
            return false;
        }
        return !stringTokenizer.hasMoreTokens();
    }

    private void setUp() {
        this.day = new HashSet();
        this.day.add("Mon");
        this.day.add("Tue");
        this.day.add("Wed");
        this.day.add("Thu");
        this.day.add("Fri");
        this.day.add("Sat");
        this.day.add("Sun");
        this.month = new HashSet();
        this.month.add("Jan");
        this.month.add("Feb");
        this.month.add("Mar");
        this.month.add("Apr");
        this.month.add("May");
        this.month.add("Jun");
        this.month.add("Jul");
        this.month.add("Aug");
        this.month.add("Sep");
        this.month.add("Oct");
        this.month.add("Nov");
        this.month.add("Dec");
        this.zone = new HashSet();
        this.zone.add("UT");
        this.zone.add("GMT");
        this.zone.add("EST");
        this.zone.add("EDT");
        this.zone.add("CST");
        this.zone.add("CDT");
        this.zone.add("MST");
        this.zone.add("MDT");
        this.zone.add("PST");
        this.zone.add("PDT");
    }

    private String getFieldName() {
        if (this.fieldName == null) {
            return new String("");
        }
        return this.fieldName;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).statusChanged(string);
        }
    }

    private void testContainsSemicolon() {
        String string = "X-Sender: oana@derwent";
        String string2 = "X-Sender oana@derwent";
        String string3 = ":X-Sender oana@derwent";
        String string4 = "X-Sender oana@derwent:";
        Assert.assertTrue((this.containsSemicolon(string) ? 1 : 0) != 0);
        Assert.assertTrue((!this.containsSemicolon(string2) ? 1 : 0) != 0);
        Assert.assertTrue((this.containsSemicolon(string3) ? 1 : 0) != 0);
        Assert.assertTrue((this.containsSemicolon(string4) ? 1 : 0) != 0);
    }

    private void testContainsWhiteSpaces() {
        String string = "Content-Type: TEXT/PLAIN; charset=US-ASCII";
        String string2 = "Content-Type:TEXT/PLAIN;charset=US-ASCII";
        String string3 = " Content-Type:TEXT/PLAIN;charset=US-ASCII";
        String string4 = "Content-Type:TEXT/PLAIN;charset=US-ASCII ";
        Assert.assertTrue((this.containsWhiteSpaces(string) ? 1 : 0) != 0);
        Assert.assertTrue((!this.containsWhiteSpaces(string2) ? 1 : 0) != 0);
        Assert.assertTrue((this.containsWhiteSpaces(string3) ? 1 : 0) != 0);
        Assert.assertTrue((this.containsWhiteSpaces(string4) ? 1 : 0) != 0);
    }

    private void testHasAMeaning() {
        String string = "12:05:22";
        String string2 = "Sep";
        String string3 = "Fri";
        String string4 = "2000";
        String string5 = "GMT";
        String string6 = "Date: Wed, 13 Sep 2000 13:05:22 +0100 (BST)";
        String string7 = "12:75:22";
        String string8 = "September";
        String string9 = "Friday";
        Assert.assertTrue((this.hasAMeaning(string) ? 1 : 0) != 0);
        Assert.assertTrue((this.hasAMeaning(string2) ? 1 : 0) != 0);
        Assert.assertTrue((this.hasAMeaning(string3) ? 1 : 0) != 0);
        Assert.assertTrue((this.hasAMeaning(string4) ? 1 : 0) != 0);
        Assert.assertTrue((this.hasAMeaning(string5) ? 1 : 0) != 0);
        Assert.assertTrue((!this.hasAMeaning(string6) ? 1 : 0) != 0);
        Assert.assertTrue((!this.hasAMeaning(string7) ? 1 : 0) != 0);
        Assert.assertTrue((!this.hasAMeaning(string8) ? 1 : 0) != 0);
        Assert.assertTrue((!this.hasAMeaning(string9) ? 1 : 0) != 0);
    }

    private void testIsTime() {
        String string = "13:05:22";
        String string2 = "13/05/22";
        String string3 = "24:05:22";
        Assert.assertTrue((this.isTime(string) ? 1 : 0) != 0);
        Assert.assertTrue((!this.isTime(string2) ? 1 : 0) != 0);
        Assert.assertTrue((!this.isTime(string3) ? 1 : 0) != 0);
    }

    private void testLineBeginsMessage() {
        String string = "From oana@dcs.shef.ac.uk Wed Sep 13 13:05:23 2000";
        String string2 = "Date: Wed, 13 Sep 2000 13:05:22 +0100 (BST)";
        String string3 = "From oana@dcs.shef.ac.uk Sep 13 13:05:23 2000";
        Assert.assertTrue((this.lineBeginsMessage(string) ? 1 : 0) != 0);
        Assert.assertTrue((!this.lineBeginsMessage(string2) ? 1 : 0) != 0);
        Assert.assertTrue((!this.lineBeginsMessage(string3) ? 1 : 0) != 0);
    }

    private void testLineBeginsWithField() {
        String string = "Message-ID: <Pine.SOL.3.91.1000913130311.19537A-10@derwent>";
        String string2 = "%:ContentType TEXT/PLAIN; charset=US-ASCII";
        Assert.assertTrue((this.lineBeginsWithField(string) ? 1 : 0) != 0);
        Assert.assertTrue((this.lineBeginsWithField(string2) ? 1 : 0) != 0);
    }

    public void testSelf() {
        this.testContainsSemicolon();
        this.testContainsWhiteSpaces();
        this.testHasAMeaning();
        this.testIsTime();
        this.testLineBeginsMessage();
        this.testLineBeginsWithField();
    }
}

