/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.orthomatcher.OrthoMatcherRule;
import gate.util.InvalidOffsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthoMatcherHelper {
    protected static final Logger log = Logger.getLogger(OrthoMatcherHelper.class);
    public static boolean[] rulesUsedTable = null;

    public static boolean straightCompare(String string, String string2, boolean bl) {
        boolean bl2 = false;
        bl2 = !bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
        return bl2;
    }

    public static boolean initialMatch(String string, String string2) {
        return string.length() == 1 ^ string2.length() == 1 && string.charAt(0) == string2.charAt(0);
    }

    public static String getStringForSpan(Long l, Long l2, Document document) throws ExecutionException {
        try {
            return document.getContent().getContent(l, l2).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new ExecutionException(invalidOffsetException);
        }
    }

    public static boolean executeDisjunction(Map<Integer, OrthoMatcherRule> map, int[] nArray, String string, String string2, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl2;
            blArray[nArray[i]] = bl2 = map.get(nArray[i]).value(string, string2);
            bl = bl || bl2;
        }
        return bl;
    }

    public static Double round2Places(Double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static void usedRule(int n) {
        if (rulesUsedTable == null) {
            rulesUsedTable = new boolean[18];
            for (int i = 0; i < rulesUsedTable.length; ++i) {
                OrthoMatcherHelper.rulesUsedTable[i] = false;
            }
        }
        OrthoMatcherHelper.rulesUsedTable[n] = true;
    }

    public static void saveUsedTable() {
        if (rulesUsedTable != null) {
            log.debug((Object)"Saving table of used orthomatcher rules:");
            String string = "";
            for (int i = 0; i < rulesUsedTable.length; ++i) {
                string = string + "Rule: " + i + " fired: " + rulesUsedTable[i] + "\r\n";
            }
            log.debug((Object)string);
            log.debug((Object)"End of table of used Orthomatcher rules");
        } else {
            log.debug((Object)"Could not save the table of used orthomatcher rules. This also results when no Orthomatcher rule has returned 'true'.");
        }
    }

    public static int[] convertArrayToInteger(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i].trim());
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String SortByStartPosition(String string) {
        int n = 100000;
        String[] stringArray = string.trim().split(",");
        int[] nArray = new int[stringArray.length];
        if (stringArray.length > 1) {
            void var5_7;
            int n2;
            int n3 = 0;
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split(":");
                nArray[n3] = n2 = Integer.parseInt(stringArray2[0].trim()) * n + Integer.parseInt(stringArray2[1].trim());
                ++n3;
            }
            Arrays.sort(nArray);
            String string3 = "";
            for (int n4 : nArray) {
                n2 = n4 / n;
                int n5 = n4 % n;
                String string4 = (String)var5_7 + n2 + ":" + n5 + ", ";
            }
            return var5_7;
        }
        return string;
    }

    protected static void setMatchesPositions(AnnotationSet annotationSet) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("matches");
        AnnotationSet annotationSet2 = annotationSet.get(null, hashSet);
        if (annotationSet2 == null || annotationSet2.isEmpty()) {
            return;
        }
        for (Annotation annotation : annotationSet2) {
            String string = annotation.getFeatures().get("matches").toString();
            string = string.substring(1);
            string = string.substring(0, string.length() - 1);
            String[] stringArray = string.split(",");
            String string2 = "";
            String string3 = ", ";
            int[] nArray = OrthoMatcherHelper.convertArrayToInteger(stringArray);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Annotation annotation2 = null;
                Iterator<Annotation> iterator = annotationSet.iterator();
                if (annotation.getId() == n) {
                    annotation2 = annotation;
                } else {
                    while (iterator.hasNext()) {
                        Annotation annotation3 = iterator.next();
                        if (annotation3.getId() != n) continue;
                        annotation2 = annotation3;
                        break;
                    }
                }
                if (annotation2 == null) continue;
                string2 = string2 + annotation2.getStartNode().getOffset() + ":" + annotation2.getEndNode().getOffset() + string3;
            }
            if ((string2 = OrthoMatcherHelper.SortByStartPosition(string2)).endsWith(string3)) {
                string2 = string2.substring(0, string2.length() - string3.length());
            }
            string2 = "[" + string2 + "]";
            annotation.getFeatures().put("matches_positions", string2);
        }
    }
}

