/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ir.lucene;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.creole.ir.IndexDefinition;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexManager;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.util.GateRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class LuceneIndexManager
implements IndexManager {
    public static final String DOCUMENT_ID = "DOCUMENT_ID";
    private IndexDefinition indexDefinition;
    private Corpus corpus;
    public static final String CORPUS_INDEX_FEATURE = "CorpusIndexFeature";
    public static final String CORPUS_INDEX_FEATURE_VALUE = "IR";

    public void createIndex() throws IndexException {
        if (this.indexDefinition == null) {
            throw new GateRuntimeException("Index definition is null!");
        }
        if (this.corpus == null) {
            throw new GateRuntimeException("Corpus is null!");
        }
        String string = this.indexDefinition.getIndexLocation();
        try {
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory() && file.listFiles().length > 0) {
                    throw new IndexException(string + " is not empty directory");
                }
                if (!file.isDirectory()) {
                    throw new IndexException("Only empty directory can be index path");
                }
            }
            this.corpus.getFeatures().put(CORPUS_INDEX_FEATURE, CORPUS_INDEX_FEATURE_VALUE);
            IndexWriter indexWriter = new IndexWriter(string, (Analyzer)new SimpleAnalyzer(), true);
            for (int i = 0; i < this.corpus.size(); ++i) {
                boolean bl = this.corpus.isDocumentLoaded(i);
                Document document = (Document)this.corpus.get(i);
                indexWriter.addDocument(this.getLuceneDoc(document));
                if (bl) continue;
                this.corpus.unloadDocument(document);
                Factory.deleteResource(document);
            }
            indexWriter.close();
            this.corpus.sync();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException.getMessage());
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    public void optimizeIndex() throws IndexException {
        if (this.indexDefinition == null) {
            throw new GateRuntimeException("Index definition is null!");
        }
        try {
            IndexWriter indexWriter = new IndexWriter(this.indexDefinition.getIndexLocation(), (Analyzer)new SimpleAnalyzer(), false);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException.getMessage());
        }
    }

    public void deleteIndex() throws IndexException {
        if (this.indexDefinition == null) {
            throw new GateRuntimeException("Index definition is null!");
        }
        boolean bl = true;
        File file = new File(this.indexDefinition.getIndexLocation());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                bl = file2.delete();
            }
        }
        file.delete();
        if (!bl) {
            throw new IndexException("Can't delete directory" + this.indexDefinition.getIndexLocation());
        }
    }

    public void sync(List list, List list2, List list3) throws IndexException {
        String string = this.indexDefinition.getIndexLocation();
        try {
            int n;
            Object object;
            Object object2;
            int n2;
            IndexReader indexReader = IndexReader.open((String)string);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                object2 = list2.get(n2).toString();
                object = new Term(DOCUMENT_ID, (String)object2);
                indexReader.deleteDocuments(object);
            }
            for (n2 = 0; n2 < list3.size(); ++n2) {
                object2 = (Document)list3.get(n2);
                object = object2.getLRPersistenceId().toString();
                Term term = new Term(DOCUMENT_ID, (String)object);
                indexReader.deleteDocuments(term);
            }
            indexReader.close();
            IndexWriter indexWriter = new IndexWriter(string, (Analyzer)new SimpleAnalyzer(), false);
            for (n = 0; n < list.size(); ++n) {
                object = (Document)list.get(n);
                indexWriter.addDocument(this.getLuceneDoc((Document)object));
            }
            for (n = 0; n < list3.size(); ++n) {
                object = (Document)list3.get(n);
                indexWriter.addDocument(this.getLuceneDoc((Document)object));
            }
            indexWriter.close();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException.getMessage());
        }
    }

    private org.apache.lucene.document.Document getLuceneDoc(Document document) {
        org.apache.lucene.document.Document document2 = new org.apache.lucene.document.Document();
        Iterator iterator = this.indexDefinition.getIndexFields();
        document2.add((Fieldable)new Field(DOCUMENT_ID, document.getLRPersistenceId().toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        while (iterator.hasNext()) {
            IndexField indexField = (IndexField)iterator.next();
            String string = indexField.getReader() == null ? document.getFeatures().get(indexField.getName()).toString() : indexField.getReader().getPropertyValue(document);
            if (indexField.isPreseved()) {
                document2.add((Fieldable)new Field(indexField.getName(), string, Field.Store.YES, Field.Index.UN_TOKENIZED));
                continue;
            }
            document2.add((Fieldable)new Field(indexField.getName(), string, Field.Store.NO, Field.Index.TOKENIZED));
        }
        return document2;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public IndexDefinition getIndexDefinition() {
        return this.indexDefinition;
    }

    public void setIndexDefinition(IndexDefinition indexDefinition) {
        this.indexDefinition = indexDefinition;
    }
}

