/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.LinearNode;
import gate.util.Files;
import gate.util.protocols.gate.Handler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class LinearDefinition
extends AbstractLanguageResource
implements List {
    private static final long serialVersionUID = 4050479036709221175L;
    private static final String ENCODING = "UTF-8";
    private List nodes = new ArrayList();
    private URL url;
    private List lists = new ArrayList();
    private String encoding = "UTF-8";
    private Map nodesByList = new HashMap();
    private Map gazListsByNode = new HashMap();
    private boolean isModified = false;
    private String separator;

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map loadLists() throws ResourceInstantiationException {
        try {
            this.gazListsByNode = new HashMap();
            for (LinearNode linearNode : this.nodes) {
                GazetteerList gazetteerList = new GazetteerList();
                gazetteerList.setSeparator(this.separator);
                URL uRL = new URL(this.url, linearNode.getList());
                gazetteerList.setURL(uRL);
                gazetteerList.setEncoding(this.encoding);
                gazetteerList.load();
                this.gazListsByNode.put(linearNode, gazetteerList);
            }
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
        return this.gazListsByNode;
    }

    public GazetteerList loadSingleList(String string) throws ResourceInstantiationException {
        GazetteerList gazetteerList = new GazetteerList();
        gazetteerList.setSeparator(this.separator);
        try {
            URL uRL = this.url;
            if (-1 != this.url.getProtocol().indexOf("gate")) {
                uRL = Handler.class.getResource(Files.getResourcePath() + this.url.getPath());
            }
            try {
                URL uRL2 = new URL(this.url, string);
                gazetteerList.setURL(uRL2);
                gazetteerList.load();
            }
            catch (Exception exception) {
                File file;
                String string2 = uRL.getPath();
                int n = string2.lastIndexOf("/");
                if (-1 != n) {
                    string2 = string2.substring(0, n + 1);
                }
                if (!(file = new File(string2 + string)).exists()) {
                    file.createNewFile();
                }
                URL uRL3 = new URL(this.url, string);
                gazetteerList.setURL(uRL3);
                gazetteerList.load();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceInstantiationException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        return gazetteerList;
    }

    public Map getListsByNode() {
        return this.gazListsByNode;
    }

    public Map getNodesByListNames() {
        return this.nodesByList;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public void load() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream(), ENCODING));
            while (null != (string = bufferedReader.readLine())) {
                LinearNode linearNode = new LinearNode(string);
                this.add(linearNode);
            }
            bufferedReader.close();
            this.isModified = false;
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
    }

    public void store() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set.(null)");
        }
        try {
            URL uRL = this.url;
            if (-1 != this.url.getProtocol().indexOf("gate")) {
                uRL = Handler.class.getResource(Files.getResourcePath() + this.url.getPath());
            }
            File file = new File(uRL.getFile());
            file.delete();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write(iterator.next().toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            this.isModified = false;
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
    }

    public List getLists() {
        return new ArrayList(this.lists);
    }

    public List getNodes() {
        return new ArrayList(this.nodes);
    }

    public Set getMajors() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String string = ((LinearNode)this.nodes.get(i)).getMajorType();
            if (null == string) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set getMinors() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String string = ((LinearNode)this.nodes.get(i)).getMinorType();
            if (null == string) continue;
            hashSet.add(string);
        }
        hashSet.add("");
        return hashSet;
    }

    public Set getLanguages() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String string = ((LinearNode)this.nodes.get(i)).getLanguage();
            if (null == string) continue;
            hashSet.add(string);
        }
        hashSet.add("");
        return hashSet;
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = this.nodes.size();
        for (Object e : collection) {
            if (!(e instanceof LinearNode)) continue;
            this.add(n, e);
        }
        boolean bl = n2 != this.nodes.size();
        this.isModified |= bl;
        return bl;
    }

    public Object get(int n) {
        return this.nodes.get(n);
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("this method has not been implemented");
    }

    public void add(int n, Object object) {
        String string;
        if (object instanceof LinearNode && !this.nodesByList.containsKey(string = ((LinearNode)object).getList())) {
            try {
                GazetteerList gazetteerList = this.loadSingleList(string);
                this.gazListsByNode.put(object, gazetteerList);
                this.nodes.add(n, object);
                this.nodesByList.put(string, object);
                this.lists.add(string);
                this.isModified = true;
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                // empty catch block
            }
        }
    }

    public Object remove(int n) {
        Object var2_2 = null;
        int n2 = this.nodes.size();
        var2_2 = this.nodes.remove(n);
        if (null != var2_2) {
            String string = ((LinearNode)var2_2).getList();
            this.lists.remove(string);
            this.nodesByList.remove(string);
            this.gazListsByNode.remove(var2_2);
            this.isModified |= n2 != this.nodes.size();
        }
        return var2_2;
    }

    public int indexOf(Object object) {
        return this.nodes.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.nodes.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    public ListIterator listIterator(int n) {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    public List subList(int n, int n2) {
        return this.nodes.subList(n, n2);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return 0 == this.nodes.size();
    }

    public boolean contains(Object object) {
        return this.nodes.contains(object);
    }

    public Iterator iterator() {
        return new SafeIterator();
    }

    public Object[] toArray() {
        return this.nodes.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.nodes.toArray(objectArray);
    }

    public boolean add(Object object) {
        String string;
        boolean bl = false;
        if (object instanceof LinearNode && !this.nodesByList.containsKey(string = ((LinearNode)object).getList())) {
            try {
                GazetteerList gazetteerList = this.loadSingleList(string);
                this.gazListsByNode.put(object, gazetteerList);
                bl = this.nodes.add(object);
                this.nodesByList.put(string, object);
                this.lists.add(string);
                this.isModified = true;
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = false;
        int n = this.nodes.size();
        if (object instanceof LinearNode) {
            bl = this.nodes.remove(object);
            String string = ((LinearNode)object).getList();
            this.lists.remove(string);
            this.nodesByList.remove(string);
            this.gazListsByNode.remove(object);
            this.isModified |= n != this.nodes.size();
        }
        return bl;
    }

    public boolean containsAll(Collection collection) {
        return this.nodes.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            if (!(e instanceof LinearNode)) continue;
            bl |= this.add(e);
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl |= this.remove(e);
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        int n = this.nodes.size();
        ArrayList<LinearNode> arrayList = new ArrayList<LinearNode>();
        for (LinearNode linearNode : this.nodes) {
            if (!collection.contains(linearNode)) continue;
            arrayList.add(linearNode);
        }
        this.removeAll(arrayList);
        this.isModified |= n != this.nodes.size();
        return n != this.nodes.size();
    }

    public void clear() {
        this.nodes.clear();
        this.lists.clear();
        this.nodesByList.clear();
        this.gazListsByNode.clear();
        this.isModified = true;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LinearDefinition) {
            LinearDefinition linearDefinition = (LinearDefinition)object;
            bl &= ((Object)this.nodes).equals(linearDefinition.nodes);
            bl &= ((Object)this.lists).equals(linearDefinition.lists);
            bl &= ((Object)this.nodesByList).equals(linearDefinition.lists);
        }
        return bl;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    private class SafeIterator
    implements Iterator {
        private Iterator iter;
        private boolean removeCalled;
        private Object last;

        private SafeIterator() {
            this.iter = LinearDefinition.this.nodes.iterator();
            this.removeCalled = false;
            this.last = null;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.removeCalled = false;
            this.last = this.iter.next();
            return this.last;
        }

        public void remove() {
            if (!this.removeCalled && null != this.last) {
                LinearDefinition.this.remove(this.last);
            }
            this.removeCalled = true;
        }
    }
}

