/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GazetteerNode {
    private String entry;
    private Map featureMap = null;
    private String separator;

    public GazetteerNode(String string, Map map) {
        this.entry = string;
        this.featureMap = map;
    }

    public GazetteerNode(String string) {
        this(string, (String)null);
    }

    public GazetteerNode(String string, String string2) {
        int n;
        String string3 = this.separator = string2 != null && string2.length() == 0 ? null : string2;
        if (this.separator == null || (n = string.indexOf(this.separator)) == -1) {
            this.entry = string;
        } else {
            this.entry = string.substring(0, n);
            String string4 = string.substring(n + 1);
            this.featureMap = this.getFeatures(string4);
        }
    }

    private Map getFeatures(String string) {
        String[] stringArray;
        if (this.separator == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(this.separator, n);
        while (n2 != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(this.separator, n);
        }
        String string2 = string.substring(n);
        if (string2.length() != 0) {
            arrayList.add(string2);
        }
        if ((stringArray = arrayList.toArray(new String[arrayList.size()])).length == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n3 = string3.indexOf(61);
            if (n3 == -1) {
                throw new GateRuntimeException("Correct format for gazetteer entry features is: [entry]([separator][featureName]=[featureValue])*");
            }
            String string4 = string3.substring(0, n3).trim();
            String string5 = string3.substring(n3 + 1).trim();
            if (string4.length() <= 0 || string5.length() <= 0) continue;
            hashMap.put(string4, string5);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return hashMap;
    }

    public String featureMapToString(Map map) {
        String string = "";
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            string = string + this.separator + string2 + "=" + map.get(string2);
        }
        return string;
    }

    public String toString() {
        if (this.featureMap == null || this.separator == null) {
            return this.entry;
        }
        return this.entry + this.featureMapToString(this.featureMap);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof GazetteerNode) {
            bl = this.toString().equals(object.toString());
        }
        return bl;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String string) {
        this.entry = string;
    }

    public Map getFeatureMap() {
        return this.featureMap;
    }

    public void setFeatureMap(Map map) {
        this.featureMap = map;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }
}

