/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annotransfer;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.InvalidOffsetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSetTransfer
extends AbstractLanguageAnalyser
implements ProcessingResource,
Serializable {
    private String tagASName = "Original markups";
    private String outputASName;
    private String inputASName;
    private String textTagName;
    private URL configURL;
    private Boolean copyAnnotations;
    private Boolean transferAllUnlessFound;
    private AnnotationSet bodyAnnotations = null;
    private List<String> annotationTypes = null;
    Map<String, Mapping> mappings = new HashMap<String, Mapping>();

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute() throws ExecutionException {
        Object object;
        Object object2;
        Object object32;
        ArrayList<Annotation> arrayList;
        AnnotationSet annotationSet = this.document.getAnnotations(this.inputASName);
        AnnotationSet annotationSet2 = this.document.getAnnotations(this.outputASName);
        AnnotationSet annotationSet3 = this.document.getAnnotations(this.tagASName);
        AnnotationSet annotationSet4 = null;
        this.mappings.clear();
        if (this.configURL != null) {
            try {
                void var6_8;
                arrayList = new BufferedReader(new InputStreamReader(this.configURL.openStream()));
                String object4 = ((BufferedReader)((Object)arrayList)).readLine();
                while (var6_8 != null) {
                    if (!var6_8.trim().equals("")) {
                        object32 = var6_8.split("=", 2);
                        object2 = object32[0].trim();
                        object = ((String[])object32).length == 2 ? object32[1].trim() : null;
                        this.mappings.put((String)object2, new Mapping((String)object2, (String)object));
                    }
                    String string = ((BufferedReader)((Object)arrayList)).readLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.annotationTypes != null) {
            for (String string : this.annotationTypes) {
                object32 = string.split("=", 2);
                object2 = object32[0].trim();
                object = ((String[])object32).length == 2 ? object32[1].trim() : null;
                this.mappings.put((String)object2, new Mapping((String)object2, (String)object));
            }
        }
        annotationSet4 = this.mappings.size() > 0 ? annotationSet.get(this.mappings.keySet()) : annotationSet.get();
        if (annotationSet4 == null || annotationSet4.size() == 0) {
            return;
        }
        if (this.textTagName == null || this.textTagName.equals("")) {
            this.transferAnnotations(new ArrayList<Annotation>(annotationSet4), annotationSet2);
            if (!this.copyAnnotations.booleanValue()) {
                annotationSet.removeAll(annotationSet4);
            }
            return;
        }
        this.bodyAnnotations = annotationSet3.get(this.textTagName);
        if (this.bodyAnnotations == null || this.bodyAnnotations.isEmpty()) {
            if (this.transferAllUnlessFound.booleanValue()) {
                this.transferAnnotations(new ArrayList<Annotation>(annotationSet4), annotationSet2);
                if (!this.copyAnnotations.booleanValue()) {
                    annotationSet.removeAll(annotationSet4);
                }
            }
            return;
        }
        arrayList = new ArrayList<Annotation>();
        for (Object object32 : this.bodyAnnotations) {
            object2 = object32.getStartNode().getOffset();
            object = object32.getEndNode().getOffset();
            AnnotationSet annotationSet5 = annotationSet4.getContained((Long)object2, (Long)object);
            arrayList.addAll(annotationSet5);
        }
        this.transferAnnotations(arrayList, annotationSet2);
        if (!this.copyAnnotations.booleanValue()) {
            annotationSet.removeAll(arrayList);
        }
    }

    private void transferAnnotations(List<Annotation> list, AnnotationSet annotationSet) throws ExecutionException {
        for (Annotation annotation : list) {
            Mapping mapping = this.mappings.get(annotation.getType());
            String string = mapping == null || mapping.newName == null ? annotation.getType() : mapping.newName;
            try {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.putAll(annotation.getFeatures());
                annotationSet.add(annotation.getId(), annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), string, featureMap);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException(invalidOffsetException);
            }
        }
    }

    public void setTagASName(String string) {
        this.tagASName = "".equals(string) ? null : string;
    }

    public String getTagASName() {
        return this.tagASName;
    }

    public void setInputASName(String string) {
        this.inputASName = string;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public void setTextTagName(String string) {
        this.textTagName = string;
    }

    public String getTextTagName() {
        return this.textTagName;
    }

    public List<String> getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List<String> list) {
        this.annotationTypes = list;
    }

    public void setConfigURL(URL uRL) {
        this.configURL = uRL;
    }

    public URL getConfigURL() {
        return this.configURL;
    }

    public Boolean getCopyAnnotations() {
        return this.copyAnnotations;
    }

    public void setCopyAnnotations(Boolean bl) {
        this.copyAnnotations = bl;
    }

    public Boolean getTransferAllUnlessFound() {
        return this.transferAllUnlessFound;
    }

    public void setTransferAllUnlessFound(Boolean bl) {
        this.transferAllUnlessFound = bl;
    }

    class Mapping {
        String oldName;
        String newName;

        public Mapping(String string, String string2) {
            this.oldName = string;
            this.newName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.oldName);
            if (this.newName != null) {
                stringBuilder.append("=").append(this.newName);
            }
            return stringBuilder.toString();
        }
    }
}

