/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.lucene.LuceneIndexSearcher;
import gate.creole.annic.lucene.LuceneQueryResult;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.creole.annic.lucene.PatternValidator;
import gate.creole.annic.lucene.QueryParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchThread {
    private static boolean DEBUG = false;
    private int contextWindow;
    private String indexLocation;
    private QueryParser queryParser;
    private String baseTokenAnnotationType;
    private LuceneSearcher luceneSearcher;
    public boolean finished = false;
    private int serializedFileIDIndex = 0;
    private int queryItemIndex = 0;
    private List<String> serializedFilesIDsList = new ArrayList<String>();
    private Map<String, List<QueryItem>> searchResultInfoMap = new HashMap<String, List<QueryItem>>();
    private int ftpIndex = 0;
    private boolean success = false;
    private boolean fwdIterationEnded = false;
    private String serializedFileIDInUse = null;
    private List<Token> tokenStreamInUse = null;
    private String query = null;
    private List ftp;

    private String getCompatibleName(String string) {
        return string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean search(String string, int n, String string2, String string3, String string4, LuceneSearcher luceneSearcher) throws SearchException {
        this.query = string;
        this.contextWindow = n;
        this.indexLocation = string2;
        this.queryParser = new QueryParser();
        this.luceneSearcher = luceneSearcher;
        this.searchResultInfoMap = new HashMap<String, List<QueryItem>>();
        this.serializedFileIDIndex = 0;
        this.queryItemIndex = 0;
        this.serializedFilesIDsList = new ArrayList<String>();
        this.ftpIndex = -1;
        this.success = false;
        this.fwdIterationEnded = false;
        try {
            Query[] queryArray;
            Object object;
            String string5 = "";
            for (int i = 0; i < string2.length(); ++i) {
                string5 = string2.charAt(i) == '\\' ? string5 + "/" : string5 + string2.charAt(i);
            }
            string2 = string5;
            File file = new File(string2);
            if (!file.isDirectory()) {
                System.out.println("Skipping the invalid Index Location :" + string2);
                return false;
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!(file = new File(string2 + "LuceneIndexDefinition.xml")).exists()) {
                System.out.println("Index Definition file not found - Skipping the invalid Index Location :" + string2 + "LuceneIndexDefinition.xml");
                return false;
            }
            FileReader fileReader = new FileReader(string2 + "LuceneIndexDefinition.xml");
            HashMap hashMap = null;
            try {
                object = new XStream((HierarchicalStreamDriver)new StaxDriver());
                hashMap = (HashMap)object.fromXML((Reader)fileReader);
                queryArray = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                fileReader.close();
                throw throwable;
            }
            fileReader.close();
            object = (String)hashMap.get("CorpusIndexFeature");
            if (object == null || !((String)object).equals("AnnicIR")) {
                System.out.println("This corpus was not indexed by Annic Index PR - Skipping the invalid Index");
                return false;
            }
            this.baseTokenAnnotationType = ((String)hashMap.get("BASE_TOKEN_ANNOTATION_TYPE")).trim();
            int n2 = this.baseTokenAnnotationType.lastIndexOf(46);
            if (n2 >= 0) {
                this.baseTokenAnnotationType = this.baseTokenAnnotationType.substring(n2 + 1);
            }
            queryArray = this.queryParser.parse("contents", string, this.baseTokenAnnotationType, string3, string4);
            if (this.queryParser.needValidation()) {
                if (DEBUG) {
                    System.out.println("Validation enabled!");
                }
            } else if (DEBUG) {
                System.out.println("Validation disabled!");
            }
            LuceneIndexSearcher luceneIndexSearcher = new LuceneIndexSearcher(string2);
            try {
                for (int i = 0; i < queryArray.length; ++i) {
                    luceneIndexSearcher.initializeTermPositions();
                    Hits hits = luceneIndexSearcher.search(queryArray[i]);
                    ArrayList[] arrayListArray = luceneIndexSearcher.getFirstTermPositions();
                    if (arrayListArray[0].size() == 0) continue;
                    for (int j = 0; j < hits.length(); ++j) {
                        int n3 = arrayListArray[0].indexOf(new Integer(hits.id(j)));
                        ArrayList arrayList = (ArrayList)arrayListArray[1].get(n3);
                        int n4 = (Integer)arrayListArray[2].get(n3);
                        int n5 = (Integer)arrayListArray[3].get(n3);
                        String string6 = hits.doc(j).get("DOCUMENT_ID_FOR_SERIALIZED_FILE");
                        QueryItem queryItem = new QueryItem();
                        queryItem.annotationSetName = hits.doc(j).get("ANNOTATION_SET_ID").intern();
                        queryItem.id = hits.id(j);
                        queryItem.documentID = hits.doc(j).get("DOCUMENT_ID").intern();
                        queryItem.ftp = arrayList;
                        queryItem.patLen = n4;
                        queryItem.qType = n5;
                        queryItem.query = queryArray[i];
                        queryItem.queryString = this.queryParser.getQueryString(i).intern();
                        List<QueryItem> list = this.searchResultInfoMap.get(string6);
                        if (list == null) {
                            list = new ArrayList<QueryItem>();
                            list.add(queryItem);
                            this.searchResultInfoMap.put(string6, list);
                            this.serializedFilesIDsList.add(string6);
                            continue;
                        }
                        list.add(queryItem);
                    }
                }
                Object var27_30 = null;
            }
            catch (Throwable throwable) {
                Object var27_31 = null;
                luceneIndexSearcher.close();
                throw throwable;
            }
            luceneIndexSearcher.close();
            this.success = this.searchResultInfoMap.size() > 0;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
        return this.success;
    }

    public List<Pattern> next(int n) throws Exception {
        if (!this.success) {
            return null;
        }
        if (this.fwdIterationEnded) {
            return null;
        }
        int n2 = n;
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        while (this.serializedFileIDIndex < this.serializedFilesIDsList.size()) {
            block13: {
                String string = this.serializedFilesIDsList.get(this.serializedFileIDIndex);
                List<QueryItem> list = this.searchResultInfoMap.get(string);
                if (!list.isEmpty()) {
                    String string2 = list.get((int)0).documentID.intern();
                    if (this.serializedFileIDInUse == null || !this.serializedFileIDInUse.equals(string) || this.tokenStreamInUse == null) {
                        this.serializedFileIDInUse = string;
                        try {
                            this.tokenStreamInUse = this.getTokenStreamFromDisk(this.indexLocation, this.getCompatibleName(string2), this.getCompatibleName(string));
                        }
                        catch (Exception exception) {
                            break block13;
                        }
                    }
                    while (this.queryItemIndex < list.size()) {
                        QueryItem queryItem = list.get(this.queryItemIndex);
                        int n3 = queryItem.qType;
                        int n4 = queryItem.patLen;
                        if (this.ftp == null) {
                            this.ftp = queryItem.ftp;
                        } else {
                            n3 = 1;
                            n4 = 1;
                        }
                        PatternResult patternResult = this.getPatternResult(this.tokenStreamInUse, queryItem.annotationSetName, n4, n3, this.contextWindow, queryItem.queryString, this.baseTokenAnnotationType, n2);
                        if (patternResult != null && patternResult.numberOfPatterns != 0) {
                            if (n2 != -1) {
                                n2 -= patternResult.numberOfPatterns;
                            }
                            List<Pattern> list2 = this.createAnnicPatterns(new LuceneQueryResult(this.removeUnitNumber(string), patternResult.annotationSetName, patternResult.firstTermPositions, patternResult.patternLegths, queryItem.qType, patternResult.gateAnnotations, queryItem.queryString));
                            arrayList.addAll(list2);
                            if (n != -1 && n2 == 0) {
                                return arrayList;
                            }
                        }
                        ++this.queryItemIndex;
                        this.ftpIndex = -1;
                        this.ftp = null;
                    }
                }
            }
            ++this.serializedFileIDIndex;
            this.queryItemIndex = 0;
            this.ftp = null;
        }
        this.fwdIterationEnded = true;
        return arrayList;
    }

    private List<Pattern> createAnnicPatterns(LuceneQueryResult luceneQueryResult) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        List list = luceneQueryResult.getFirstTermPositions();
        if (list != null && list.size() > 0) {
            List<Integer> list2 = luceneQueryResult.patternLength();
            List<Pattern> list3 = this.locatePatterns((String)luceneQueryResult.getDocumentID(), luceneQueryResult.getAnnotationSetName(), luceneQueryResult.getGateAnnotations(), list, list2, luceneQueryResult.getQuery());
            if (list3 != null) {
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    private List<Pattern> locatePatterns(String string, String string2, List<List<PatternAnnotation>> list, List list2, List<Integer> list3, String string3) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            List<PatternAnnotation> list4 = list.get(i);
            if (list4.size() == 0) continue;
            int n2 = Integer.MAX_VALUE;
            int n3 = -1;
            for (int j = 0; j < list4.size(); ++j) {
                PatternAnnotation patternAnnotation = list4.get(j);
                if (patternAnnotation.getStartOffset() < n2) {
                    n2 = patternAnnotation.getStartOffset();
                }
                if (patternAnnotation.getEndOffset() <= n3) continue;
                n3 = patternAnnotation.getEndOffset();
            }
            char[] cArray = new char[n3 - n2];
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 32;
            }
            for (n = 0; n < list4.size(); ++n) {
                PatternAnnotation patternAnnotation = list4.get(n);
                if (patternAnnotation.getText() == null) continue;
                int n4 = patternAnnotation.getStartOffset() - n2;
                for (int j = 0; j < patternAnnotation.getText().length() && n4 < cArray.length; ++j, ++n4) {
                    cArray[n4] = patternAnnotation.getText().charAt(j);
                }
                if (this.luceneSearcher.annotationTypesMap.keySet().contains(patternAnnotation.getType())) {
                    List<String> list5 = this.luceneSearcher.annotationTypesMap.get(patternAnnotation.getType());
                    Map<String, String> map = patternAnnotation.getFeatures();
                    if (map != null) {
                        for (String string4 : map.keySet()) {
                            if (list5.contains(string4)) continue;
                            list5.add(string4);
                        }
                    }
                    this.luceneSearcher.annotationTypesMap.put(patternAnnotation.getType(), list5);
                    continue;
                }
                Map<String, String> map = patternAnnotation.getFeatures();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("All");
                if (map != null) {
                    arrayList2.addAll(map.keySet());
                }
                this.luceneSearcher.annotationTypesMap.put(patternAnnotation.getType(), arrayList2);
            }
            n = (Integer)list2.get(i);
            int n5 = list3.get(i);
            int n6 = Integer.MAX_VALUE;
            for (int j = 0; j < list4.size(); ++j) {
                PatternAnnotation patternAnnotation = list4.get(j);
                if (patternAnnotation.getPosition() != n || patternAnnotation.getStartOffset() >= n6) continue;
                n6 = patternAnnotation.getStartOffset();
            }
            if (n6 == Integer.MAX_VALUE || n6 < n2 || n5 > n3) continue;
            Pattern pattern = new Pattern(string, string2, new String(cArray), n6, n5, n2, n3, list4, string3);
            arrayList.add(pattern);
        }
        return arrayList;
    }

    private String removeUnitNumber(String string) {
        int n = string.lastIndexOf("-");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private List<Token> getTokenStreamFromDisk(String string, String string2, String string3) throws Exception {
        if (string.startsWith("file:/")) {
            string = string.substring(6, string.length());
        }
        File file = new File(string, "serialized-files");
        file = new File(file, string2);
        File file2 = new File(file, string3 + ".annic");
        FileInputStream fileInputStream = new FileInputStream(file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        List list = (List)objectInputStream.readObject();
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        return list;
    }

    private PatternResult getPatternResult(List<Token> list, String string, int n, int n2, int n3, String string2, String string3, int n4) {
        if (n2 == 1) {
            return this.getPatternResult(list, string, n, n3, string2, string3, n4);
        }
        String string4 = (String)this.ftp.get(0);
        String string5 = (String)this.ftp.get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Token token = list.get(i);
            String string6 = token.termText();
            String string7 = token.type();
            if (string5.equals("*")) {
                if (!string6.equals(string4) || !string5.equals(string7)) continue;
                arrayList.add(new Integer(token.getPosition()));
                continue;
            }
            if (!string4.equals(string6) || !string5.equals(string7)) continue;
            arrayList.add(new Integer(token.getPosition()));
        }
        this.ftp = arrayList;
        return this.getPatternResult(list, string, 1, n3, string2, string3, n4);
    }

    private PatternResult getPatternResult(List<Token> list, String string, int n, int n2, String string2, String string3, int n3) {
        int n4;
        ArrayList<List<PatternAnnotation>> arrayList = new ArrayList<List<PatternAnnotation>>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ++this.ftpIndex;
        int n5 = this.ftpIndex;
        while (this.ftpIndex < this.ftp.size() && (n3 == -1 || n3 > 0)) {
            block29: {
                Token token;
                int n6;
                Serializable serializable;
                int n7;
                Token token2;
                int n8 = (Integer)this.ftp.get(this.ftpIndex);
                for (n4 = 0; n4 < list.size() && (token2 = list.get(n4)).getPosition() != n8; ++n4) {
                }
                int n9 = 0;
                int n10 = -1;
                for (n7 = n4 - 1; n7 >= 0; --n7) {
                    Token token3 = list.get(n7);
                    if (token3.getPosition() < n8 && token3.termText().equals(string3) && token3.type().equals("*")) {
                        ++n9;
                        n10 = token3.startOffset();
                        n4 = n7;
                    }
                    if (n9 == n2) break;
                }
                --n8;
                if (n10 > -1) {
                    boolean bl = false;
                    for (n7 = n4; n7 < list.size(); ++n7) {
                        Token token4 = list.get(n7);
                        if (token4.getPosition() == n8) {
                            bl = true;
                            continue;
                        }
                        if (bl) break;
                    }
                }
                int n11 = n10 == -1 ? -1 : n7 - 1;
                int n12 = -1;
                int n13 = 0;
                if (this.queryParser.needValidation()) {
                    try {
                        int n14;
                        List<String> list2 = this.luceneSearcher.getQueryTokens(string2);
                        if (list2 == null) {
                            list2 = new QueryParser().findTokens(string2);
                            this.luceneSearcher.addQueryTokens(string2, list2);
                        }
                        if ((n12 = ((PatternValidator)((Object)(serializable = new PatternValidator()))).validate(list2, list, n7, new QueryParser())) == -1) {
                            this.ftp.remove(this.ftpIndex);
                            --this.ftpIndex;
                            break block29;
                        }
                        n6 = 0;
                        n13 = list.get(n14).getPosition();
                        for (n14 = n11 + 1; n14 < list.size(); ++n14) {
                            token = list.get(n14);
                            if (token.endOffset() == n12) {
                                n13 = token.getPosition();
                                n6 = 1;
                                continue;
                            }
                            if (n6 != 0) break;
                        }
                        arrayList2.add(new Integer(n12));
                        n7 = n14;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    n9 = 0;
                    while (n9 < n && n7 < list.size()) {
                        Token token5 = list.get(n7);
                        if (token5.termText().equals(string3) && token5.type().equals("*")) {
                            ++n9;
                            n12 = token5.endOffset();
                            n13 = token5.getPosition();
                        }
                        ++n7;
                    }
                    arrayList2.add(new Integer(n12));
                    ++n7;
                }
                int n15 = n12;
                while (n7 < list.size() && ((Token)(serializable = list.get(n7))).getPosition() != n13 + 1) {
                    ++n7;
                }
                n9 = 0;
                while (n7 < list.size()) {
                    serializable = list.get(n7);
                    if (((Token)serializable).startOffset() >= n12 && ((Token)serializable).termText().equals(string3) && ((Token)serializable).type().equals("*")) {
                        ++n9;
                        n15 = ((Token)serializable).endOffset();
                    }
                    if (n9 == n2) break;
                    ++n7;
                }
                if (n7 < list.size()) {
                    n13 = list.get(n7).getPosition();
                    while (n7 < list.size() && ((Token)(serializable = list.get(n7))).getPosition() == n13) {
                        ++n7;
                    }
                }
                if (n7 >= list.size()) {
                    n7 = list.size() - 1;
                }
                serializable = new ArrayList();
                PatternAnnotation patternAnnotation = null;
                for (n6 = n4; n6 <= n7; ++n6) {
                    token = list.get(n6);
                    String string4 = token.termText();
                    int n16 = token.startOffset();
                    int n17 = token.endOffset();
                    String string5 = token.type();
                    int n18 = token.getPosition();
                    if (string5.equals("*")) {
                        patternAnnotation = new PatternAnnotation();
                        patternAnnotation.setType(string4);
                        patternAnnotation.setStOffset(n16);
                        patternAnnotation.setEnOffset(n17);
                        patternAnnotation.setPosition(n18);
                        if (patternAnnotation.getEndOffset() > n15) continue;
                        serializable.add(patternAnnotation);
                        continue;
                    }
                    if (string5.equals("**")) continue;
                    int n19 = string5.indexOf(".");
                    String string6 = string5.substring(n19 + 1, string5.length());
                    if (string6.equals("string")) {
                        patternAnnotation.setText(string4);
                    }
                    patternAnnotation.addFeature(string6, string4);
                }
                arrayList.add((List<PatternAnnotation>)((Object)serializable));
                if (n3 != -1) {
                    --n3;
                }
            }
            ++this.ftpIndex;
        }
        if (n3 == 0 && this.ftpIndex < this.ftp.size()) {
            --this.ftpIndex;
        }
        PatternResult patternResult = new PatternResult();
        patternResult.annotationSetName = string;
        patternResult.gateAnnotations = arrayList;
        patternResult.firstTermPositions = new ArrayList();
        for (n4 = 0; n4 < patternResult.gateAnnotations.size(); ++n4) {
            patternResult.firstTermPositions.add(this.ftp.get(n4 + n5));
        }
        patternResult.patternLegths = arrayList2;
        patternResult.numberOfPatterns = patternResult.gateAnnotations.size();
        return patternResult;
    }

    private boolean areTheyEqual(List list, List list2, int n) {
        if (n == 1) {
            if (list.size() == list2.size()) {
                for (int i = 0; i < list.size(); ++i) {
                    int n2;
                    int n3 = (Integer)list.get(i);
                    if (n3 == (n2 = ((Integer)list2.get(i)).intValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        String string = (String)list.get(0);
        String string2 = (String)list.get(1);
        String string3 = (String)list2.get(0);
        String string4 = (String)list2.get(1);
        return string3.equals(string) && string4.equals(string2);
    }

    public String getQuery() {
        return this.query;
    }

    private class QueryItem {
        float score;
        int id;
        String documentID;
        List ftp;
        int patLen;
        int qType;
        Query query;
        String queryString;
        String annotationSetName;

        private QueryItem() {
        }
    }

    private class PatternResult {
        int numberOfPatterns;
        List<List<PatternAnnotation>> gateAnnotations;
        String annotationSetName;
        List firstTermPositions;
        List<Integer> patternLegths;

        private PatternResult() {
        }
    }
}

