/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.IndexWriter;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.LuceneAnalyzer;
import gate.creole.annic.lucene.LuceneDocument;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexer
implements Indexer {
    protected boolean DEBUG = false;
    protected Corpus corpus;
    protected Map parameters;

    public LuceneIndexer(URL uRL) throws IOException {
        if (uRL != null) {
            this.readParametersFromDisk(uRL);
        }
    }

    protected void checkIndexParameters(Map map) throws IndexException {
        this.parameters = map;
        if (map == null) {
            throw new IndexException("No parameters provided!");
        }
        URL uRL = (URL)map.get("INDEX_LOCATION_URL");
        if (uRL == null) {
            throw new IndexException("You must provide a URL for INDEX_LOCATION");
        }
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            throw new IndexException("Index Output Directory must be set to the empty directory on the file system");
        }
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getFile());
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IndexException("Path doesn't exist");
        }
        String string = (String)map.get("BASE_TOKEN_ANNOTATION_TYPE");
        if (string.indexOf(".") > -1 || string.indexOf("=") > -1 || string.indexOf(";") > -1 || string.indexOf(",") > -1) {
            throw new IndexException("Base token annotation type cannot have '.' , '=', ',' or ';; in it");
        }
        String string2 = (String)map.get("INDEX_UNIT_ANNOTATION_TYPE");
        if (this.DEBUG) {
            System.out.println("BTAT : " + string);
            System.out.println("IUAT : " + string2);
        }
        if (string == null || string.trim().length() == 0) {
            string = "Token";
            map.put("BASE_TOKEN_ANNOTATION_TYPE", "Token");
        }
    }

    protected Map getIndexParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(Map map) throws IndexException {
        this.checkIndexParameters(map);
        URL uRL = (URL)this.parameters.get("INDEX_LOCATION_URL");
        try {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getFile());
            }
            IndexWriter indexWriter = new IndexWriter(file.getAbsolutePath(), (Analyzer)new LuceneAnalyzer(), true);
            try {
                if (this.corpus != null) {
                    for (int i = 0; i < this.corpus.size(); ++i) {
                        Document document = (Document)this.corpus.get(i);
                        String string = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
                        System.out.print("Indexing : " + string + " ...");
                        String string2 = this.corpus.getLRPersistenceId() == null ? this.corpus.getName() : this.corpus.getLRPersistenceId().toString();
                        List<gate.creole.annic.apache.lucene.document.Document> list = this.getLuceneDocuments(string2, document, uRL.toString());
                        if (list != null) {
                            for (int j = 0; j < list.size(); ++j) {
                                if (list.get(j) == null) continue;
                                indexWriter.addDocument(list.get(j));
                            }
                        }
                        if (document.getLRPersistenceId() != null) {
                            Factory.deleteResource(document);
                        }
                        System.out.println("Done");
                    }
                }
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                indexWriter.close();
                throw throwable;
            }
            indexWriter.close();
            this.writeParametersToDisk();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimizeIndex() throws IndexException {
        try {
            String string = ((URL)this.parameters.get("INDEX_LOCATION_URL")).toString();
            IndexWriter indexWriter = new IndexWriter(string, (Analyzer)new LuceneAnalyzer(), false);
            try {
                indexWriter.optimize();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                indexWriter.close();
                throw throwable;
            }
            indexWriter.close();
            {
            }
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    @Override
    public void deleteIndex() throws IndexException {
        boolean bl = true;
        if (this.parameters == null) {
            return;
        }
        File file = null;
        try {
            file = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile());
        }
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    File[] fileArray2 = file2.listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        File file3 = fileArray2[j];
                        file3.delete();
                    }
                }
                file2.delete();
            }
        }
        if (!(bl = file.delete())) {
            throw new IndexException("Can't delete directory" + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String string, List<Document> list) throws IndexException {
        String string2 = null;
        try {
            string2 = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            string2 = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try {
            IndexWriter indexWriter = new IndexWriter(string2, (Analyzer)new LuceneAnalyzer(), false);
            try {
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        Document document = list.get(i);
                        String string3 = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
                        System.out.print("Indexing : " + string3 + " ...");
                        List<gate.creole.annic.apache.lucene.document.Document> list2 = this.getLuceneDocuments(string, document, string2);
                        if (list2 == null) {
                            System.out.println("Done");
                            continue;
                        }
                        for (int j = 0; j < list2.size(); ++j) {
                            indexWriter.addDocument(list2.get(j));
                        }
                        System.out.println("Done");
                    }
                }
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                indexWriter.close();
                throw throwable;
            }
            indexWriter.close();
            {
            }
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    private String getCompatibleName(String string) {
        return string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(List list) throws IndexException {
        String string = null;
        try {
            string = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            string = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try {
            IndexReader indexReader = IndexReader.open(string);
            try {
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = list.get(i).toString();
                        Set<String> set = this.getNamesOfSerializedFiles(string2);
                        if (set.size() <= 0) continue;
                        System.out.print("Removing => " + string2 + "...");
                        string2 = this.getCompatibleName(string2);
                        File file = new File(string, "serialized-files");
                        file = new File(file, string2);
                        for (String string3 : set) {
                            Term term = new Term("DOCUMENT_ID_FOR_SERIALIZED_FILE", string3);
                            indexReader.delete(term);
                            File file2 = new File(file, (string3 = this.getCompatibleName(string3)) + ".annic");
                            if (!file2.exists()) continue;
                            file2.delete();
                        }
                        if (file.exists() && file.isDirectory()) {
                            file.delete();
                        }
                        System.out.println("Done ");
                    }
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                indexReader.close();
                throw throwable;
            }
            indexReader.close();
            {
            }
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    private List<gate.creole.annic.apache.lucene.document.Document> getLuceneDocuments(String string, Document document, String string2) throws IndexException {
        ArrayList arrayList = new ArrayList((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_INCLUDE"));
        ArrayList arrayList2 = new ArrayList((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_EXCLUDE"));
        String string3 = (String)this.parameters.get("BASE_TOKEN_ANNOTATION_TYPE");
        String string4 = (String)this.parameters.get("INDEX_UNIT_ANNOTATION_TYPE");
        ArrayList<String> arrayList3 = new ArrayList<String>((List)this.parameters.get("FEATURES_TO_EXCLUDE"));
        ArrayList<String> arrayList4 = new ArrayList<String>((List)this.parameters.get("FEATURES_TO_INCLUDE"));
        ArrayList<String> arrayList5 = new ArrayList<String>((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_EXCLUDE"));
        ArrayList<String> arrayList6 = new ArrayList<String>((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_INCLUDE"));
        Boolean bl = (Boolean)this.parameters.get("CREATE_TOKENS_AUTOMATICALLY");
        if (bl == null) {
            bl = new Boolean(true);
        }
        String string5 = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
        return new LuceneDocument().createDocuments(string, document, string5, arrayList6, arrayList5, arrayList4, arrayList3, string2, string3, bl, string4);
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(Corpus corpus) throws IndexException {
        this.corpus = corpus;
        if (corpus == null) {
            throw new IndexException("Corpus is not initialized");
        }
        corpus.getFeatures().put("CorpusIndexFeature", "AnnicIR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readParametersFromDisk(URL uRL) throws IOException {
        File file = null;
        try {
            file = new File(new File(uRL.toURI()), "LuceneIndexDefinition.xml");
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getFile(), "LuceneIndexDefinition.xml");
        }
        if (!file.exists()) {
            return;
        }
        FileReader fileReader = new FileReader(file);
        try {
            XStream xStream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            this.parameters = (HashMap)xStream.fromXML((Reader)fileReader);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            fileReader.close();
            throw throwable;
        }
        fileReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParametersToDisk() throws IOException {
        Object object2;
        URL uRL = (URL)this.parameters.get("INDEX_LOCATION_URL");
        File file = null;
        try {
            file = new File(new File(uRL.toURI()), "LuceneIndexDefinition.xml");
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getFile(), "LuceneIndexDefinition.xml");
        }
        FileWriter fileWriter = new FileWriter(file);
        HashMap hashMap = new HashMap();
        for (Object object2 : this.parameters.keySet()) {
            hashMap.put(object2, this.parameters.get(object2));
        }
        hashMap.put("CorpusIndexFeature", "AnnicIR");
        if (this.corpus != null) {
            hashMap.put("CORPUS_SIZE", new Integer(this.corpus.getDocumentNames().size()));
        }
        object2 = new XStream();
        try {
            object2.toXML(hashMap, (Writer)fileWriter);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            fileWriter.close();
            throw throwable;
        }
        fileWriter.close();
    }

    @Override
    public Map getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getNamesOfSerializedFiles(String string) throws IndexException {
        String string2 = null;
        try {
            string2 = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            string2 = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            HashSet<String> hashSet2;
            Term term = new Term("DOCUMENT_ID", string);
            TermQuery termQuery = new TermQuery(term);
            IndexSearcher indexSearcher = new IndexSearcher(string2);
            try {
                Hits hits = indexSearcher.search(termQuery);
                for (int i = 0; i < hits.length(); ++i) {
                    gate.creole.annic.apache.lucene.document.Document document = hits.doc(i);
                    String string3 = document.get("DOCUMENT_ID_FOR_SERIALIZED_FILE");
                    hashSet.add(string3);
                }
                hashSet2 = hashSet;
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                indexSearcher.close();
                throw throwable;
            }
            indexSearcher.close();
            return hashSet2;
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }
}

