/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.store.RAMFile;
import java.io.IOException;

public class RAMOutputStream
extends OutputStream {
    private RAMFile file;
    private int pointer = 0;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    RAMOutputStream(RAMFile rAMFile) {
        this.file = rAMFile;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.flush();
        long l = this.file.length;
        long l2 = 0L;
        int n = 0;
        while (l2 < l) {
            int n2 = 1024;
            long l3 = l2 + (long)n2;
            if (l3 > l) {
                n2 = (int)(l - l2);
            }
            outputStream.writeBytes((byte[])this.file.buffers.elementAt(n++), n2);
            l2 = l3;
        }
    }

    public void reset() {
        try {
            this.seek(0L);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        this.file.length = 0L;
    }

    public void flushBuffer(byte[] byArray, int n) {
        int n2;
        int n3 = this.pointer / 1024;
        int n4 = this.pointer % 1024;
        int n5 = 1024 - n4;
        int n6 = n2 = n5 >= n ? n : n5;
        if (n3 == this.file.buffers.size()) {
            this.file.buffers.addElement(new byte[1024]);
        }
        byte[] byArray2 = (byte[])this.file.buffers.elementAt(n3);
        System.arraycopy(byArray, 0, byArray2, n4, n2);
        if (n2 < n) {
            int n7 = n2;
            n2 = n - n2;
            if (++n3 == this.file.buffers.size()) {
                this.file.buffers.addElement(new byte[1024]);
            }
            byArray2 = (byte[])this.file.buffers.elementAt(n3);
            System.arraycopy(byArray, n7, byArray2, 0, n2);
        }
        this.pointer += n;
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
        this.file.lastModified = System.currentTimeMillis();
    }

    public void close() throws IOException {
        super.close();
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        this.pointer = (int)l;
    }

    public long length() {
        return this.file.length;
    }
}

