/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;

final class TermScorer
extends Scorer {
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc;
    private Term term;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs termDocs, Similarity similarity, byte[] byArray, Term term) throws IOException {
        super(similarity);
        this.weight = weight;
        this.termDocs = termDocs;
        this.norms = byArray;
        this.weightValue = weight.getValue();
        this.term = term;
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    public int doc() {
        return this.doc;
    }

    public boolean next(Searcher searcher) throws IOException {
        this.searcher = searcher;
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }
        this.doc = this.docs[this.pointer];
        return true;
    }

    public float score(Searcher searcher) throws IOException {
        this.searcher = searcher;
        int n = this.freqs[this.pointer];
        float f = n < 32 ? this.scoreCache[n] : this.getSimilarity().tf(n) * this.weightValue;
        float f2 = f * Similarity.decodeNorm(this.norms[this.doc]);
        if (f2 > 0.0f && this.term.type() != null && this.searcher instanceof IndexSearcher) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.term.text());
            arrayList.add(this.term.type());
            ((IndexSearcher)this.searcher).setFirstTermPositions(0, this.doc(), arrayList, 1, n);
        }
        return f2;
    }

    public boolean skipTo(int n) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (n <= this.docs[this.pointer]) {
                this.doc = this.docs[this.pointer];
                return true;
            }
            ++this.pointer;
        }
        boolean bl = this.termDocs.skipTo(n);
        if (bl) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return bl;
    }

    public Explanation explain(int n) throws IOException {
        TermQuery termQuery = (TermQuery)this.weight.getQuery();
        Explanation explanation = new Explanation();
        int n2 = 0;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] == n) {
                n2 = this.freqs[this.pointer];
            }
            ++this.pointer;
        }
        if (n2 == 0) {
            while (this.termDocs.next()) {
                if (this.termDocs.doc() != n) continue;
                n2 = this.termDocs.freq();
            }
        }
        this.termDocs.close();
        explanation.setValue(this.getSimilarity().tf(n2));
        explanation.setDescription("tf(termFreq(" + termQuery.getTerm() + ")=" + n2 + ")");
        return explanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

