/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.SortComparatorSource;
import java.io.Serializable;
import java.util.Locale;

public class SortField
implements Serializable {
    public static final int SCORE = 0;
    public static final int DOC = 1;
    public static final int AUTO = 2;
    public static final int STRING = 3;
    public static final int INT = 4;
    public static final int FLOAT = 5;
    public static final int CUSTOM = 9;
    public static final SortField FIELD_SCORE = new SortField(null, 0);
    public static final SortField FIELD_DOC = new SortField(null, 1);
    private String field;
    private int type = 2;
    private Locale locale;
    boolean reverse = false;
    private SortComparatorSource factory;

    public SortField(String string) {
        this.field = string.intern();
    }

    public SortField(String string, boolean bl) {
        this.field = string.intern();
        this.reverse = bl;
    }

    public SortField(String string, int n) {
        this.field = string != null ? string.intern() : string;
        this.type = n;
    }

    public SortField(String string, int n, boolean bl) {
        this.field = string != null ? string.intern() : string;
        this.type = n;
        this.reverse = bl;
    }

    public SortField(String string, Locale locale) {
        this.field = string.intern();
        this.type = 3;
        this.locale = locale;
    }

    public SortField(String string, Locale locale, boolean bl) {
        this.field = string.intern();
        this.type = 3;
        this.locale = locale;
        this.reverse = bl;
    }

    public SortField(String string, SortComparatorSource sortComparatorSource) {
        this.field = string != null ? string.intern() : string;
        this.type = 9;
        this.factory = sortComparatorSource;
    }

    public SortField(String string, SortComparatorSource sortComparatorSource, boolean bl) {
        this.field = string != null ? string.intern() : string;
        this.type = 9;
        this.reverse = bl;
        this.factory = sortComparatorSource;
    }

    public String getField() {
        return this.field;
    }

    public int getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public SortComparatorSource getFactory() {
        return this.factory;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("<score>");
                break;
            }
            case 1: {
                stringBuffer.append("<doc>");
                break;
            }
            case 9: {
                stringBuffer.append("<custom:\"" + this.field + "\": " + this.factory + ">");
                break;
            }
            default: {
                stringBuffer.append("\"" + this.field + "\"");
            }
        }
        if (this.locale != null) {
            stringBuffer.append("(" + this.locale + ")");
        }
        if (this.reverse) {
            stringBuffer.append('!');
        }
        return stringBuffer.toString();
    }
}

