/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.BooleanClause;
import gate.creole.annic.apache.lucene.search.BooleanScorer;
import gate.creole.annic.apache.lucene.search.ConjunctionScorer;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class BooleanQuery
extends Query {
    public static int maxClauseCount = Integer.parseInt(System.getProperty("gate.creole.annic.apache.lucene.maxClauseCount", "1024"));
    private Vector clauses = new Vector();

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int n) {
        maxClauseCount = n;
    }

    public void add(Query query, boolean bl, boolean bl2) {
        this.add(new BooleanClause(query, bl, bl2));
    }

    public void add(BooleanClause booleanClause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.addElement(booleanClause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[0]);
    }

    protected Weight createWeight(Searcher searcher) {
        return new BooleanWeight(searcher);
    }

    public Query rewrite(IndexReader indexReader) throws IOException {
        Serializable serializable;
        if (this.clauses.size() == 1) {
            serializable = (BooleanClause)this.clauses.elementAt(0);
            if (!serializable.prohibited) {
                Query query = serializable.query.rewrite(indexReader);
                if (this.getBoost() != 1.0f) {
                    if (query == serializable.query) {
                        query = (Query)query.clone();
                    }
                    query.setBoost(this.getBoost() * query.getBoost());
                }
                return query;
            }
        }
        serializable = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(i);
            Query query = booleanClause.query.rewrite(indexReader);
            if (query == booleanClause.query) continue;
            if (serializable == null) {
                serializable = (BooleanQuery)this.clone();
            }
            ((BooleanQuery)serializable).clauses.setElementAt(new BooleanClause(query, booleanClause.required, booleanClause.prohibited), i);
        }
        if (serializable != null) {
            return serializable;
        }
        return this;
    }

    public Object clone() {
        BooleanQuery booleanQuery = (BooleanQuery)super.clone();
        booleanQuery.clauses = (Vector)this.clauses.clone();
        return booleanQuery;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((double)this.getBoost() != 1.0) {
            stringBuffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(i);
            if (booleanClause.prohibited) {
                stringBuffer.append("-");
            } else if (booleanClause.required) {
                stringBuffer.append("+");
            }
            Query query = booleanClause.query;
            if (query instanceof BooleanQuery) {
                stringBuffer.append("(");
                stringBuffer.append(booleanClause.query.toString(string));
                stringBuffer.append(")");
            } else {
                stringBuffer.append(booleanClause.query.toString(string));
            }
            if (i == this.clauses.size() - 1) continue;
            stringBuffer.append(" ");
        }
        if ((double)this.getBoost() != 1.0) {
            stringBuffer.append(")^");
            stringBuffer.append(this.getBoost());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery booleanQuery = (BooleanQuery)object;
        return this.getBoost() == booleanQuery.getBoost() && this.clauses.equals(booleanQuery.clauses);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode();
    }

    private class BooleanWeight
    implements Weight {
        private Searcher searcher;
        private Vector weights = new Vector();

        public BooleanWeight(Searcher searcher) {
            this.searcher = searcher;
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                this.weights.add(booleanClause.query.createWeight(searcher));
            }
        }

        public Query getQuery() {
            return BooleanQuery.this;
        }

        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float f = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight weight = (Weight)this.weights.elementAt(i);
                if (booleanClause.prohibited) continue;
                f += weight.sumOfSquaredWeights();
            }
            return f *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        public void normalize(float f) {
            f *= BooleanQuery.this.getBoost();
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight weight = (Weight)this.weights.elementAt(i);
                if (booleanClause.prohibited) continue;
                weight.normalize(f);
            }
        }

        public Scorer scorer(IndexReader indexReader, Searcher searcher) throws IOException {
            this.searcher = searcher;
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                if (!booleanClause.required) {
                    bl = false;
                }
                if (!(booleanClause.query instanceof BooleanQuery)) continue;
                bl2 = false;
            }
            if (bl && bl2) {
                ConjunctionScorer conjunctionScorer = new ConjunctionScorer(BooleanQuery.this.getSimilarity(searcher));
                for (int i = 0; i < this.weights.size(); ++i) {
                    Weight weight = (Weight)this.weights.elementAt(i);
                    Scorer scorer = weight.scorer(indexReader, searcher);
                    if (scorer == null) {
                        return null;
                    }
                    conjunctionScorer.add(scorer);
                }
                return conjunctionScorer;
            }
            BooleanScorer booleanScorer = new BooleanScorer(BooleanQuery.this.getSimilarity(searcher));
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight weight = (Weight)this.weights.elementAt(i);
                Scorer scorer = weight.scorer(indexReader, searcher);
                if (scorer != null) {
                    booleanScorer.add(scorer, booleanClause.required, booleanClause.prohibited);
                    continue;
                }
                if (!booleanClause.required) continue;
                return null;
            }
            return booleanScorer;
        }

        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            float f;
            Serializable serializable;
            Explanation explanation = new Explanation();
            explanation.setDescription("sum of:");
            int n2 = 0;
            int n3 = 0;
            float f2 = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                serializable = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight weight = (Weight)this.weights.elementAt(i);
                Explanation explanation2 = weight.explain(indexReader, n);
                if (!((BooleanClause)serializable).prohibited) {
                    ++n3;
                }
                if (explanation2.getValue() > 0.0f) {
                    if (!((BooleanClause)serializable).prohibited) {
                        explanation.addDetail(explanation2);
                        f2 += explanation2.getValue();
                        ++n2;
                        continue;
                    }
                    return new Explanation(0.0f, "match prohibited");
                }
                if (!((BooleanClause)serializable).required) continue;
                return new Explanation(0.0f, "match required");
            }
            explanation.setValue(f2);
            if (n2 == 1) {
                explanation = explanation.getDetails()[0];
            }
            if ((f = BooleanQuery.this.getSimilarity(this.searcher).coord(n2, n3)) == 1.0f) {
                return explanation;
            }
            serializable = new Explanation();
            ((Explanation)serializable).setDescription("product of:");
            ((Explanation)serializable).addDetail(explanation);
            ((Explanation)serializable).addDetail(new Explanation(f, "coord(" + n2 + "/" + n3 + ")"));
            ((Explanation)serializable).setValue(f2 * f);
            return serializable;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
    }
}

