/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.SegmentMergeInfo;
import gate.creole.annic.apache.lucene.index.SegmentMergeQueue;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import java.io.IOException;

class MultiTermEnum
extends TermEnum {
    private SegmentMergeQueue queue;
    private Term term;
    private int docFreq;

    public MultiTermEnum(IndexReader[] indexReaderArray, int[] nArray, Term term) throws IOException {
        this.queue = new SegmentMergeQueue(indexReaderArray.length);
        for (int i = 0; i < indexReaderArray.length; ++i) {
            IndexReader indexReader = indexReaderArray[i];
            TermEnum termEnum = term != null ? indexReader.terms(term) : indexReader.terms();
            SegmentMergeInfo segmentMergeInfo = new SegmentMergeInfo(nArray[i], termEnum, indexReader);
            if (term == null ? segmentMergeInfo.next() : termEnum.term() != null) {
                this.queue.put(segmentMergeInfo);
                continue;
            }
            segmentMergeInfo.close();
        }
        if (term != null && this.queue.size() > 0) {
            this.next();
        }
    }

    public boolean next() throws IOException {
        SegmentMergeInfo segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
        if (segmentMergeInfo == null) {
            this.term = null;
            return false;
        }
        this.term = segmentMergeInfo.term;
        this.docFreq = 0;
        while (segmentMergeInfo != null && this.term.indexCompareTo(segmentMergeInfo.term) == 0) {
            this.queue.pop();
            this.docFreq += segmentMergeInfo.termEnum.docFreq();
            if (segmentMergeInfo.next()) {
                this.queue.put(segmentMergeInfo);
            } else {
                segmentMergeInfo.close();
            }
            segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
        }
        return true;
    }

    public Term term() {
        return this.term;
    }

    public int docFreq() {
        return this.docFreq;
    }

    public void close() throws IOException {
        this.queue.close();
    }
}

