/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.MultiTermDocs;
import gate.creole.annic.apache.lucene.index.MultiTermEnum;
import gate.creole.annic.apache.lucene.index.MultiTermPositions;
import gate.creole.annic.apache.lucene.index.SegmentInfos;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public class MultiReader
extends IndexReader {
    private IndexReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;

    public MultiReader(IndexReader[] indexReaderArray) throws IOException {
        super(indexReaderArray.length == 0 ? null : indexReaderArray[0].directory());
        this.initialize(indexReaderArray);
    }

    MultiReader(Directory directory, SegmentInfos segmentInfos, boolean bl, IndexReader[] indexReaderArray) throws IOException {
        super(directory, segmentInfos, bl);
        this.initialize(indexReaderArray);
    }

    private void initialize(IndexReader[] indexReaderArray) throws IOException {
        this.subReaders = indexReaderArray;
        this.starts = new int[indexReaderArray.length + 1];
        for (int i = 0; i < indexReaderArray.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += indexReaderArray[i].maxDoc();
            if (!indexReaderArray[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[indexReaderArray.length] = this.maxDoc;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVectors(n - this.starts[n2]);
    }

    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVector(n - this.starts[n2], string);
    }

    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n) throws IOException {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].document(n - this.starts[n2]);
    }

    public boolean isDeleted(int n) {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].isDeleted(n - this.starts[n2]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int n2 = this.readerIndex(n);
        this.subReaders[n2].delete(n - this.starts[n2]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
    }

    private int readerIndex(int n) {
        int n2 = 0;
        int n3 = this.subReaders.length - 1;
        while (n3 >= n2) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.starts[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            while (n4 + 1 < this.subReaders.length && this.starts[n4 + 1] == n5) {
                ++n4;
            }
            return n4;
        }
        return n3;
    }

    public synchronized byte[] norms(String string) throws IOException {
        byte[] byArray = (byte[])this.normsCache.get(string);
        if (byArray != null) {
            return byArray;
        }
        byArray = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(string, byArray, this.starts[i]);
        }
        this.normsCache.put(string, byArray);
        return byArray;
    }

    public synchronized void norms(String string, byte[] byArray, int n) throws IOException {
        byte[] byArray2 = (byte[])this.normsCache.get(string);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, n, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(string, byArray, n + this.starts[i]);
        }
    }

    protected void doSetNorm(int n, String string, byte by) throws IOException {
        this.normsCache.remove(string);
        int n2 = this.readerIndex(n);
        this.subReaders[n2].setNorm(n - this.starts[n2], string, by);
    }

    public TermEnum terms() throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    public int docFreq(Term term) throws IOException {
        int n = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            n += this.subReaders[i].docFreq(term);
        }
        return n;
    }

    public TermDocs termDocs() throws IOException {
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].close();
        }
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader indexReader = this.subReaders[i];
            Collection collection = indexReader.getFieldNames();
            for (String string : collection) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public Collection getFieldNames(boolean bl) throws IOException {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader indexReader = this.subReaders[i];
            Collection collection = indexReader.getFieldNames(bl);
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    public Collection getIndexedFieldNames(boolean bl) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader indexReader = this.subReaders[i];
            Collection collection = indexReader.getIndexedFieldNames(bl);
            hashSet.addAll(collection);
        }
        return hashSet;
    }
}

