/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.Lock;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.HashMap;

class CompoundFileReader
extends Directory {
    private Directory directory;
    private String fileName;
    private boolean open;
    private InputStream stream;
    private HashMap entries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundFileReader(Directory directory, String string) throws IOException {
        this.directory = directory;
        this.fileName = string;
        boolean bl = false;
        try {
            this.stream = directory.openFile(string);
            int n = this.stream.readVInt();
            FileEntry fileEntry = null;
            for (int i = 0; i < n; ++i) {
                long l = this.stream.readLong();
                String string2 = this.stream.readString();
                if (fileEntry != null) {
                    fileEntry.length = l - fileEntry.offset;
                }
                fileEntry = new FileEntry();
                fileEntry.offset = l;
                this.entries.put(string2, fileEntry);
            }
            if (fileEntry != null) {
                fileEntry.length = this.stream.length() - fileEntry.offset;
            }
            bl = true;
            Object var11_9 = null;
            if (bl) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (bl) throw throwable;
            try {
                this.stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.stream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public synchronized void close() throws IOException {
        if (this.stream == null) {
            throw new IOException("Already closed");
        }
        this.entries.clear();
        this.stream.close();
        this.stream = null;
    }

    public synchronized InputStream openFile(String string) throws IOException {
        if (this.stream == null) {
            throw new IOException("Stream closed");
        }
        FileEntry fileEntry = (FileEntry)this.entries.get(string);
        if (fileEntry == null) {
            throw new IOException("No sub-file with id " + string + " found");
        }
        return new CSInputStream(this.stream, fileEntry.offset, fileEntry.length);
    }

    public String[] list() {
        String[] stringArray = new String[this.entries.size()];
        return this.entries.keySet().toArray(stringArray);
    }

    public boolean fileExists(String string) {
        return this.entries.containsKey(string);
    }

    public long fileModified(String string) throws IOException {
        return this.directory.fileModified(this.fileName);
    }

    public void touchFile(String string) throws IOException {
        this.directory.touchFile(this.fileName);
    }

    public void deleteFile(String string) {
        throw new UnsupportedOperationException();
    }

    public void renameFile(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String string) throws IOException {
        FileEntry fileEntry = (FileEntry)this.entries.get(string);
        if (fileEntry == null) {
            throw new IOException("File " + string + " does not exist");
        }
        return fileEntry.length;
    }

    public OutputStream createFile(String string) {
        throw new UnsupportedOperationException();
    }

    public Lock makeLock(String string) {
        throw new UnsupportedOperationException();
    }

    static final class CSInputStream
    extends InputStream {
        InputStream base;
        long fileOffset;

        CSInputStream(InputStream inputStream, long l, long l2) throws IOException {
            this.base = inputStream;
            this.fileOffset = l;
            this.length = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] byArray, int n, int n2) throws IOException {
            InputStream inputStream = this.base;
            synchronized (inputStream) {
                long l = this.getFilePointer();
                if (l + (long)n2 > this.length) {
                    System.out.println("I m in compound");
                    throw new IOException("read past EOF");
                }
                this.base.seek(this.fileOffset + l);
                this.base.readBytes(byArray, n, n2);
            }
        }

        protected void seekInternal(long l) throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

