/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.ANNIETransducer;
import gate.creole.POSTagger;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.jape.JapeException;
import gate.jape.constraint.AbstractConstraintPredicate;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.jape.constraint.MetaPropertyAccessor;
import gate.util.AnnotationDiffer;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPR
extends TestCase {
    private static final boolean DEBUG = false;
    protected static Document doc1;
    protected static Document doc2;
    protected static Document doc3;
    protected static Document doc4;
    protected static List<String> annotationTypes;

    public TestPR(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testTokenizer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        defaultTokeniser.setDocument(doc1);
        defaultTokeniser.execute();
        defaultTokeniser.setDocument(doc2);
        defaultTokeniser.execute();
        defaultTokeniser.setDocument(doc3);
        defaultTokeniser.execute();
        defaultTokeniser.setDocument(doc4);
        defaultTokeniser.execute();
        Factory.deleteResource(defaultTokeniser);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().size() + " Token annotations, instead of the expected 1281."), (doc1.getAnnotations().size() == 1281 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().size() + " Token annotations, instead of the expected 2135."), (doc2.getAnnotations().size() == 2135 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().size() + " Token annotations, instead of the expected 2806."), (doc3.getAnnotations().size() == 2806 ? 1 : 0) != 0);
    }

    public void testGazetteer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        defaultGazetteer.setDocument(doc1);
        defaultGazetteer.execute();
        defaultGazetteer.setDocument(doc2);
        defaultGazetteer.execute();
        defaultGazetteer.setDocument(doc3);
        defaultGazetteer.execute();
        defaultGazetteer.setDocument(doc4);
        defaultGazetteer.execute();
        Factory.deleteResource(defaultGazetteer);
        TestPR.assertEquals((String)("Wrong number of annotations produced in " + doc1.getSourceUrl().getFile()), (int)57, (int)doc1.getAnnotations().get("Lookup").size());
        TestPR.assertEquals((String)("Wrong number of annotations produced in " + doc2.getSourceUrl().getFile()), (int)127, (int)doc2.getAnnotations().get("Lookup").size());
        TestPR.assertEquals((String)("Wrong number of annotations produced in " + doc3.getSourceUrl().getFile()), (int)139, (int)doc3.getAnnotations().get("Lookup").size());
    }

    public void testSplitter() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter", featureMap);
        sentenceSplitter.setDocument(doc1);
        sentenceSplitter.execute();
        sentenceSplitter.setDocument(doc2);
        sentenceSplitter.execute();
        sentenceSplitter.setDocument(doc3);
        sentenceSplitter.execute();
        sentenceSplitter.setDocument(doc4);
        sentenceSplitter.execute();
        Factory.deleteResource(sentenceSplitter);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 21."), (doc1.getAnnotations().get("Sentence").size() == 21 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 38."), (doc1.getAnnotations().get("Split").size() == 38 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 51."), (doc2.getAnnotations().get("Sentence").size() == 51 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 74."), (doc2.getAnnotations().get("Split").size() == 74 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 66."), (doc3.getAnnotations().get("Sentence").size() == 66 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 84."), (doc3.getAnnotations().get("Split").size() == 84 ? 1 : 0) != 0);
    }

    public void testTagger() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger", featureMap);
        pOSTagger.setDocument(doc1);
        pOSTagger.execute();
        pOSTagger.setDocument(doc2);
        pOSTagger.execute();
        pOSTagger.setDocument(doc3);
        pOSTagger.execute();
        pOSTagger.setDocument(doc4);
        pOSTagger.execute();
        Factory.deleteResource(pOSTagger);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("category");
        AnnotationSet annotationSet = doc1.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 677."), (annotationSet.size() == 677 ? 1 : 0) != 0);
        annotationSet = doc2.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 1133."), (annotationSet.size() == 1133 ? 1 : 0) != 0);
        annotationSet = doc3.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 1446."), (annotationSet.size() == 1446 ? 1 : 0) != 0);
    }

    public void testTransducer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer", featureMap);
        aNNIETransducer.setDocument(doc1);
        aNNIETransducer.execute();
        aNNIETransducer.setDocument(doc2);
        aNNIETransducer.execute();
        aNNIETransducer.setDocument(doc3);
        aNNIETransducer.execute();
        aNNIETransducer.setDocument(doc4);
        aNNIETransducer.execute();
        Factory.deleteResource(aNNIETransducer);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 26"), (doc1.getAnnotations().get("Organization").size() == 26 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 3"), (doc1.getAnnotations().get("Location").size() == 3 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 1"), (doc1.getAnnotations().get("Person").size() == 1 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 7"), (doc1.getAnnotations().get("Date").size() == 7 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 1"), (doc1.getAnnotations().get("Money").size() == 1 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 23"), (doc2.getAnnotations().get("Organization").size() == 24 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 11"), (doc2.getAnnotations().get("Location").size() == 11 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 1"), (doc2.getAnnotations().get("Person").size() == 1 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 8"), (doc2.getAnnotations().get("Date").size() == 8 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 3"), (doc2.getAnnotations().get("Money").size() == 3 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 29"), (doc3.getAnnotations().get("Organization").size() == 32 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 11"), (doc3.getAnnotations().get("Location").size() == 11 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 8"), (doc3.getAnnotations().get("Person").size() == 8 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 7"), (doc3.getAnnotations().get("Date").size() == 7 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 4"), (doc3.getAnnotations().get("Money").size() == 4 ? 1 : 0) != 0);
        TestPR.assertEquals((String)"Wrong number of Person annotations in OrthoMatcher test document", (int)22, (int)doc4.getAnnotations().get("Person").size());
    }

    public void testCustomConstraintDefs() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        featureMap.put("operators", arrayList);
        TestConstraintPredicate testConstraintPredicate = new TestConstraintPredicate();
        arrayList.add(testConstraintPredicate.getClass().getName());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        featureMap.put("annotationAccessors", arrayList2);
        TestAnnotationAccessor testAnnotationAccessor = new TestAnnotationAccessor();
        arrayList2.add(testAnnotationAccessor.getClass().getName());
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer", featureMap);
        TestPR.assertEquals(arrayList2, aNNIETransducer.getAnnotationAccessors());
        TestPR.assertEquals(arrayList, aNNIETransducer.getOperators());
        ConstraintPredicate constraintPredicate = Factory.getConstraintFactory().createPredicate("fooOp", testAnnotationAccessor, "fooValue");
        TestPR.assertNotNull((Object)constraintPredicate);
        TestPR.assertEquals((String)"Operator not set", testConstraintPredicate.getClass(), constraintPredicate.getClass());
        AnnotationAccessor annotationAccessor = Factory.getConstraintFactory().createMetaPropertyAccessor("fooProp");
        TestPR.assertNotNull((Object)annotationAccessor);
        TestPR.assertEquals((String)"Accessor not set", testAnnotationAccessor.getClass(), annotationAccessor.getClass());
    }

    public void testOrthomatcher() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        OrthoMatcher orthoMatcher = (OrthoMatcher)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher", featureMap);
        orthoMatcher.setDocument(doc1);
        orthoMatcher.execute();
        orthoMatcher.setDocument(doc2);
        orthoMatcher.execute();
        orthoMatcher.setDocument(doc3);
        orthoMatcher.execute();
        orthoMatcher.setDocument(doc4);
        orthoMatcher.execute();
        Factory.deleteResource(orthoMatcher);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("matches");
        AnnotationSet annotationSet = doc1.getAnnotations().get(null, hashSet);
        annotationSet = doc2.getAnnotations().get(null, hashSet);
        annotationSet = doc3.getAnnotations().get(null, hashSet);
        AnnotationSet annotationSet2 = doc4.getAnnotations().get("Person");
        Annotation annotation = annotationSet2.get(new Long(806L), new Long(811L)).iterator().next();
        TestPR.assertEquals((String)"Wrong number of matches for second Sarah in document", (int)2, (int)((ArrayList)annotation.getFeatures().get("matches")).size());
        Annotation annotation2 = annotationSet2.get(new Long(300L), new Long(315L)).iterator().next();
        TestPR.assertEquals((String)"Wrong number of matches for Robert Q Jones in document", (int)3, (int)((ArrayList)annotation2.getFeatures().get("matches")).size());
        Annotation annotation3 = annotationSet2.get(new Long(0L), new Long(15L)).iterator().next();
        TestPR.assertEquals((String)"Wrong number of matches for Robert C Jones in document", (int)3, (int)((ArrayList)annotation3.getFeatures().get("matches")).size());
        Annotation annotation4 = annotationSet2.get(new Long(1188L), new Long(1203L)).iterator().next();
        TestPR.assertEquals((String)"Found a match for Robert Anderson, but he should not have been matched.", (boolean)false, (boolean)annotation4.getFeatures().containsKey("matches"));
    }

    public void testAllPR() throws Exception {
        Serializable serializable;
        String string = Gate.locateGateFiles();
        if (string.endsWith("/bin/gate.jar!/")) {
            serializable = new StringBuffer(string.substring(0, string.lastIndexOf("bin/gate.jar!/")));
            ((StringBuffer)serializable).append("classes/");
            ((StringBuffer)serializable).delete(0, "jar:file:".length());
            ((StringBuffer)serializable).insert(0, "file://");
            string = ((StringBuffer)serializable).toString();
        }
        serializable = new URL(string + "gate/resources/gate.ac.uk/");
        URL uRL = null;
        uRL = new URL((URL)serializable, "tests/ft");
        DataStore dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        String string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc1);
        uRL = null;
        uRL = new URL((URL)serializable, "tests/gu");
        dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc2);
        uRL = null;
        uRL = new URL((URL)serializable, "tests/in");
        dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc3);
    }

    public void compareAnnots(Document document, Document document2) throws Exception {
        for (String string : annotationTypes) {
            AnnotationDiffer annotationDiffer = new AnnotationDiffer();
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("NMRule", "kind", "orgType", "rule", "rule1", "rule2", "locType", "gender", "majorType", "minorType", "category", "length", "orth", "string", "subkind", "symbolkind"));
            annotationDiffer.setSignificantFeaturesSet(hashSet);
            annotationDiffer.calculateDiff(document.getAnnotations().get(string), document2.getAnnotations().get(string));
            TestPR.assertTrue((String)(string + " precision strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getPrecisionStrict() + " instead of 1.0 "), (annotationDiffer.getPrecisionStrict() == 1.0 ? 1 : 0) != 0);
            TestPR.assertTrue((String)(string + " recall strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getRecallStrict() + " instead of 1.0 "), (annotationDiffer.getRecallStrict() == 1.0 ? 1 : 0) != 0);
            TestPR.assertTrue((String)(string + " f-measure strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getFMeasureStrict(0.5) + " instead of 1.0 "), (annotationDiffer.getFMeasureStrict(0.5) == 1.0 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new TestSuite(TestPR.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestPR testPR = new TestPR("");
            testPR.setUp();
            testPR.testTokenizer();
            testPR.testGazetteer();
            testPR.testSplitter();
            testPR.testTagger();
            testPR.testTransducer();
            testPR.testOrthomatcher();
            testPR.testAllPR();
            testPR.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        annotationTypes = new ArrayList<String>(10);
        annotationTypes.add("Sentence");
        annotationTypes.add("Organization");
        annotationTypes.add("Location");
        annotationTypes.add("Person");
        annotationTypes.add("Date");
        annotationTypes.add("Money");
        annotationTypes.add("Lookup");
        annotationTypes.add("Token");
        try {
            if (doc1 == null) {
                doc1 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/ft-bt-03-aug-2001.html"), "ISO-8859-1");
            }
            if (doc2 == null) {
                doc2 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/gu-Am-Brit-4-aug-2001.html"), "ISO-8859-1");
            }
            if (doc3 == null) {
                doc3 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/in-outlook-09-aug-2001.html"), "ISO-8859-1");
            }
            if (doc4 == null) {
                doc4 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/OrthoMatcherTest.txt"), "UTF-8");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class TestAnnotationAccessor
    extends MetaPropertyAccessor {
        public Object getValue(Annotation annotation, AnnotationSet annotationSet) {
            return "foo";
        }

        public Object getKey() {
            return "fooProp";
        }
    }

    public static class TestConstraintPredicate
    extends AbstractConstraintPredicate {
        protected boolean doMatch(Object object, AnnotationSet annotationSet) throws JapeException {
            return false;
        }

        public String getOperator() {
            return "fooOp";
        }
    }
}

