/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.AnnotationSet;
import gate.CreoleRegister;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.SerialController;
import gate.util.GateException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestControllers
extends TestCase {
    private static final boolean DEBUG = false;
    CreoleRegister reg;

    public TestControllers(String string) {
        super(string);
    }

    public void setUp() throws GateException {
        Gate.init();
        this.reg = Gate.getCreoleRegister();
    }

    public void tearDown() throws Exception {
        this.reg.clear();
        Gate.init();
    }

    public void testSerial1() throws Exception {
        SerialController serialController = new SerialController();
        TestControllers.assertNotNull((String)"c1 controller is null", (Object)serialController);
        serialController.setName("SerialController_" + Gate.genSym());
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        featureMap = Factory.newFeatureMap();
        featureMap.put("document", document);
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        featureMap = Factory.newFeatureMap();
        featureMap.put("document", document);
        ProcessingResource processingResource2 = (ProcessingResource)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        serialController.add(processingResource);
        serialController.add(processingResource2);
        serialController.execute();
        AnnotationSet annotationSet = document.getAnnotations();
        TestControllers.assertTrue((String)"no annotations from doc!", (!annotationSet.isEmpty() ? 1 : 0) != 0);
        Annotation annotation = annotationSet.get(new Integer(580));
        TestControllers.assertNotNull((String)"couldn't get annot with id 580", (Object)annotation);
    }

    public void testSerial2() throws Exception {
        SerialController serialController = new SerialController();
        TestControllers.assertNotNull((String)"c1 controller is null", (Object)serialController);
    }

    public static Test suite() {
        return new TestSuite(TestControllers.class);
    }
}

