/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.CustomDuplication;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.profile.Profiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(name="Pipeline", comment="A simple serial controller for PR pipelines.", helpURL="http://gate.ac.uk/userguide/sec:developer:apps")
public class SerialController
extends AbstractController
implements CreoleListener,
CustomDuplication {
    protected static final Logger log = Logger.getLogger(SerialController.class);
    protected Profiler prof;
    protected HashMap timeMap;
    protected HashMap<String, Long> prTimeMap;
    protected List prList = Collections.synchronizedList(new ArrayList());
    protected StatusListener sListener = new AbstractController.InternalStatusListener();

    public SerialController() {
        this.prTimeMap = new HashMap();
        if (log.isDebugEnabled()) {
            this.prof = new Profiler();
            this.prof.enableGCCalling(false);
            this.prof.printToSystemOut(true);
            this.timeMap = new HashMap();
        }
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public Collection getPRs() {
        return Collections.unmodifiableList(this.prList);
    }

    @Override
    public void setPRs(Collection collection) {
        this.prList.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((ProcessingResource)iterator.next());
        }
    }

    public void add(int n, ProcessingResource processingResource) {
        this.prList.add(n, processingResource);
        this.fireResourceAdded(new ControllerEvent(this, 0, processingResource));
    }

    public void add(ProcessingResource processingResource) {
        this.prList.add(processingResource);
        this.fireResourceAdded(new ControllerEvent(this, 0, processingResource));
    }

    public ProcessingResource remove(int n) {
        ProcessingResource processingResource = (ProcessingResource)this.prList.remove(n);
        this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        return processingResource;
    }

    public boolean remove(ProcessingResource processingResource) {
        boolean bl = this.prList.remove(processingResource);
        if (bl) {
            this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        }
        return bl;
    }

    public ProcessingResource set(int n, ProcessingResource processingResource) {
        return this.prList.set(n, processingResource);
    }

    protected void checkParameters() throws ExecutionException {
        List list;
        try {
            list = this.getOffendingPocessingResources();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException("Could not check runtime parameters for the processing resources:\n" + resourceInstantiationException.toString());
        }
        if (list != null && !list.isEmpty()) {
            throw new ExecutionException("Some of the processing resources in this controller have unset runtime parameters:\n" + list.toString());
        }
    }

    @Override
    protected void executeImpl() throws ExecutionException {
        this.checkParameters();
        if (log.isDebugEnabled()) {
            this.prof.initRun("Execute controller [" + this.getName() + "]");
        }
        this.interrupted = false;
        for (int i = 0; i < this.prList.size(); ++i) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            this.runComponent(i);
            if (!log.isDebugEnabled()) continue;
            this.prof.checkPoint("~Execute PR [" + ((ProcessingResource)this.prList.get(i)).getName() + "]");
            Long l = (Long)this.timeMap.get(((ProcessingResource)this.prList.get(i)).getName());
            if (l == null) {
                this.timeMap.put(((ProcessingResource)this.prList.get(i)).getName(), new Long(this.prof.getLastDuration()));
            } else {
                this.timeMap.put(((ProcessingResource)this.prList.get(i)).getName(), new Long(l + this.prof.getLastDuration()));
            }
            log.debug((Object)("Time taken so far by " + ((ProcessingResource)this.prList.get(i)).getName() + ": " + this.timeMap.get(((ProcessingResource)this.prList.get(i)).getName())));
        }
        if (log.isDebugEnabled()) {
            this.prof.checkPoint("Execute controller [" + this.getName() + "] finished");
        }
    }

    public void resetPrTimeMap() {
        this.prTimeMap.clear();
    }

    public HashMap<String, Long> getPrTimeMap() {
        return this.prTimeMap;
    }

    protected void runComponent(int n) throws ExecutionException {
        ProcessingResource processingResource = (ProcessingResource)this.prList.get(n);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("gate.event.StatusListener", this.sListener);
        int n2 = 100 / this.prList.size();
        featureMap.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(n * n2, (n + 1) * n2));
        try {
            AbstractResource.setResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            log.error((Object)("Could not set listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over."));
        }
        this.benchmarkFeatures.put("prName", processingResource.getName());
        long l = System.currentTimeMillis();
        Benchmark.executeWithBenchmarking(processingResource, Benchmark.createBenchmarkId("pr_" + processingResource.getName(), this.getBenchmarkId()), this, this.benchmarkFeatures);
        this.benchmarkFeatures.remove("prName");
        long l2 = System.currentTimeMillis() - l;
        Long l3 = this.prTimeMap.get(processingResource.getName());
        if (l3 == null) {
            l3 = new Long(0L);
        }
        l3 = new Long(l3 + l2);
        this.prTimeMap.put(processingResource.getName(), l3);
        try {
            AbstractResource.removeResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            log.error((Object)("Could not clear listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over."));
        }
    }

    @Override
    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.prList != null && !this.prList.isEmpty()) {
            try {
                List<Resource> list = Gate.getCreoleRegister().getAllInstances("gate.Controller");
                list.remove(this);
                ArrayList arrayList = new ArrayList();
                for (Resource resource : list) {
                    arrayList.addAll(((Controller)resource).getPRs());
                }
                for (Resource resource : new ArrayList(this.getPRs())) {
                    if (arrayList.contains(resource)) continue;
                    Factory.deleteResource(resource);
                }
            }
            catch (GateException gateException) {
                // empty catch block
            }
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext duplicationContext) throws ResourceInstantiationException {
        Controller controller = (Controller)Factory.defaultDuplicate(this, duplicationContext);
        ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>();
        for (Object e : this.prList) {
            arrayList.add((ProcessingResource)Factory.duplicate((Resource)e, duplicationContext));
        }
        controller.setPRs(arrayList);
        return controller;
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            while (this.remove((ProcessingResource)creoleEvent.getResource())) {
            }
        }
        for (int i = 0; i < this.prList.size(); ++i) {
            ProcessingResource processingResource = (ProcessingResource)this.prList.get(i);
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
            if (resourceData == null) continue;
            for (List<Parameter> list : resourceData.getParameterList().getRuntimeParameters()) {
                for (Parameter parameter : list) {
                    String string = parameter.getName();
                    try {
                        if (processingResource.getParameterValue(string) != creoleEvent.getResource()) continue;
                        processingResource.setParameterValue(string, null);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        throw new GateRuntimeException(resourceInstantiationException);
                    }
                }
            }
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
    }
}

