/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.LanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.SerialAnalyserController;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.util.Err;
import gate.util.profile.Profiler;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

@CreoleResource(name="Real-Time Corpus Pipeline", comment="A serial controller for PR pipelines over corpora which limits the run time of each PR.", icon="application-realtime", helpURL="http://gate.ac.uk/userguide/sec:creole-model:applications")
public class RealtimeCorpusController
extends SerialAnalyserController {
    private static final boolean DEBUG = false;
    protected Profiler prof;
    protected HashMap<String, Long> timeMap;
    protected Long timeout;
    protected Long graceful;
    private static final int POLL_INTERVAL = 50;

    public void executeImpl() throws ExecutionException {
        Timer timer = new Timer(this.getClass().getName() + " timeout timer");
        this.interrupted = false;
        if (this.corpus == null) {
            throw new ExecutionException("(SerialAnalyserController) \"" + this.getName() + "\":\n" + "The corpus supplied for execution was null!");
        }
        for (int i = 0; i < this.corpus.size(); ++i) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            boolean bl = this.corpus.isDocumentLoaded(i);
            Document document = (Document)this.corpus.get(i);
            DocRunner docRunner = new DocRunner();
            docRunner.setDocument(document);
            final Thread thread = new Thread((Runnable)docRunner, this.getClass().getCanonicalName() + " worker thread (document " + document.getName() + ")");
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    Err.prln("Execution timeout, attempting to gracefully stop worker thread...");
                    thread.interrupt();
                    for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                        ((Executable)RealtimeCorpusController.this.prList.get(i)).interrupt();
                    }
                }
            };
            TimerTask timerTask2 = new TimerTask(){

                public void run() {
                    if (!thread.isAlive()) {
                        return;
                    }
                    Err.println("Execution timeout, attempting to induce exception in order to stop worker thread...");
                    for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
                    }
                }
            };
            TimerTask timerTask3 = new TimerTask(){

                public void run() {
                    if (!thread.isAlive()) {
                        return;
                    }
                    Err.println("Execution timout, worker thread will be forcibly terminated!");
                    thread.stop();
                }
            };
            if (this.graceful != -1L && (this.timeout == -1L || this.graceful < this.timeout)) {
                timer.schedule(timerTask, this.graceful);
                long l = this.graceful + (this.timeout != -1L ? (this.timeout - this.graceful) / 2L : this.graceful / 2L);
                timer.schedule(timerTask2, l);
            }
            if (this.timeout != -1L) {
                timer.schedule(timerTask3, this.timeout);
            }
            thread.start();
            while (thread.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
            timerTask3.cancel();
            if (bl) continue;
            this.getCorpus().unloadDocument(document);
            Factory.deleteResource(document);
        }
        timer.cancel();
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @CreoleParameter(defaultValue="60000", comment="Timout in milliseconds before execution on a document is forcibly stopped (forcibly stopping execution may result in memory leaks and/or unexpected behaviour)")
    public void setTimeout(Long l) {
        this.timeout = l;
    }

    public Long getGracefulTimeout() {
        return this.graceful;
    }

    @CreoleParameter(defaultValue="-1", comment="Timeout in milliseconds before execution on a document is gracefully stopped. Defaults to -1 which disables this functionality and relies, as previously, on forcibly stoping execution.")
    public void setGracefulTimeout(Long l) {
        this.graceful = l;
    }

    protected class DocRunner
    implements Runnable {
        Document document;

        protected DocRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    int n;
                    for (n = 0; n < RealtimeCorpusController.this.prList.size(); ++n) {
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(n)).setDocument(this.document);
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(n)).setCorpus(RealtimeCorpusController.this.corpus);
                    }
                    RealtimeCorpusController.this.interrupted = false;
                    RealtimeCorpusController.this.checkParameters();
                    RealtimeCorpusController.this.interrupted = false;
                    for (n = 0; n < RealtimeCorpusController.this.prList.size(); ++n) {
                        if (RealtimeCorpusController.this.isInterrupted()) {
                            throw new ExecutionInterruptedException("The execution of the " + RealtimeCorpusController.this.getName() + " application has been abruptly interrupted!");
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            Err.println("Execution on document " + this.document.getName() + " has been stopped");
                            break;
                        }
                        try {
                            RealtimeCorpusController.this.runComponent(n);
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (!Thread.currentThread().isInterrupted()) {
                                throw throwable;
                            }
                            Err.println("Execution on document " + this.document.getName() + " has been stopped");
                            break;
                        }
                    }
                    Object var4_5 = null;
                }
                catch (ThreadDeath threadDeath) {
                    Err.prln("Execution on document " + this.document.getName() + " has been stopped");
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Err.prln("Execution on document " + this.document.getName() + " has caused an error:\n=========================");
                    throwable.printStackTrace(Err.getPrintWriter());
                    Err.prln("=========================\nError ignored...\n");
                    Object var4_6 = null;
                    for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                int i = 0;
                while (true) {
                    if (i >= RealtimeCorpusController.this.prList.size()) {
                        throw throwable;
                    }
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
                    ++i;
                }
            }
            for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
            }
        }

        public Document getDocument() {
            return this.document;
        }

        public void setDocument(Document document) {
            this.document = document;
        }
    }
}

