/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSchema
implements Serializable {
    private static final boolean DEBUG = false;
    String featureName = null;
    Class<?> featureValueClass = null;
    String featureValue = null;
    String featureUse = null;
    Set featurePermissibleValuesSet = null;

    public FeatureSchema(String string, Class<?> clazz, String string2, String string3, Set set) {
        this.featureName = string;
        this.featureValueClass = clazz;
        this.featureValue = string2;
        this.featureUse = string3;
        this.featurePermissibleValuesSet = set;
    }

    public boolean isEnumeration() {
        return this.featurePermissibleValuesSet != null;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Class<?> getFeatureValueClass() {
        return this.featureValueClass;
    }

    public Set getPermittedValues() {
        return this.featurePermissibleValuesSet;
    }

    public boolean setPermissibleValues(Set set) {
        this.featurePermissibleValuesSet.clear();
        return this.featurePermissibleValuesSet.addAll(set);
    }

    public boolean addPermissibleValue(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().getName().equals(this.featureValueClass)) {
            return false;
        }
        if (this.featurePermissibleValuesSet == null) {
            this.featurePermissibleValuesSet = new HashSet();
        }
        return this.featurePermissibleValuesSet.add(object);
    }

    public String toXSchema(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<attribute name=\"" + this.featureName + "\" ");
        stringBuffer.append("use=\"" + this.featureUse + "\"");
        if (!this.isEnumeration()) {
            stringBuffer.append(" type=\"" + (String)map.get(this.featureValueClass) + "\"/>\n");
        } else {
            stringBuffer.append(">\n <simpleType>\n");
            stringBuffer.append("  <restriction base=\"" + this.featureValueClass + "\">\n");
            for (String string : this.featurePermissibleValuesSet) {
                stringBuffer.append("   <enumeration value=\"" + string + "\"/>\n");
            }
            stringBuffer.append("  </restriction>\n");
            stringBuffer.append(" </simpleType>\n");
            stringBuffer.append("</attribute>\n");
        }
        return stringBuffer.toString();
    }

    public String getFeatureValue() {
        if (this.isDefault() || this.isFixed()) {
            return this.featureValue;
        }
        return "";
    }

    public void setFeatureValue(String string) {
        this.featureValue = string;
    }

    public boolean isRequired() {
        return "required".equals(this.featureUse);
    }

    public boolean isDefault() {
        return "default".equals(this.featureUse);
    }

    public boolean isFixed() {
        return "fixed".equals(this.featureUse);
    }

    public boolean isOptional() {
        return "optional".equals(this.featureUse);
    }

    public boolean isProhibited() {
        return "prohibited".equals(this.featureUse);
    }
}

