/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.TextualDocument;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.Err;
import gate.util.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DocumentXmlUtils {
    public static final int DOC_SIZE_MULTIPLICATION_FACTOR = 40;
    public static Map entitiesMap = null;

    public static String toXml(TextualDocument textualDocument) {
        StringBuffer stringBuffer = new StringBuffer(40 * textualDocument.getContent().size().intValue());
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(textualDocument.getEncoding());
        stringBuffer.append("\" ?>");
        stringBuffer.append(Strings.getNl());
        stringBuffer.append("<GateDocument>\n");
        stringBuffer.append("<!-- The document's features-->\n\n");
        stringBuffer.append("<GateDocumentFeatures>\n");
        stringBuffer.append(DocumentXmlUtils.featuresToXml(textualDocument.getFeatures(), null));
        stringBuffer.append("</GateDocumentFeatures>\n");
        stringBuffer.append("<!-- The document content area with serialized nodes -->\n\n");
        stringBuffer.append("<TextWithNodes>");
        stringBuffer.append(DocumentXmlUtils.textWithNodes(textualDocument, textualDocument.getContent().toString()));
        stringBuffer.append("</TextWithNodes>\n");
        StatusListener statusListener = (StatusListener)((Object)MainFrame.getListeners().get("gate.event.StatusListener"));
        if (statusListener != null) {
            statusListener.statusChanged("Saving the default annotation set ");
        }
        stringBuffer.append("<!-- The default annotation set -->\n\n");
        DocumentXmlUtils.annotationSetToXml(textualDocument.getAnnotations(), stringBuffer);
        Map<String, AnnotationSet> map = textualDocument.getNamedAnnotationSets();
        if (map != null) {
            for (AnnotationSet annotationSet : map.values()) {
                stringBuffer.append("<!-- Named annotation set -->\n\n");
                if (statusListener != null) {
                    statusListener.statusChanged("Saving " + annotationSet.getName() + " annotation set ");
                }
                DocumentXmlUtils.annotationSetToXml(annotationSet, stringBuffer);
            }
        }
        stringBuffer.append("</GateDocument>");
        if (statusListener != null) {
            statusListener.statusChanged("Done !");
        }
        return stringBuffer.toString();
    }

    public static StringBuffer featuresToXml(FeatureMap featureMap, Map map) {
        if (featureMap == null) {
            return new StringBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        Set set = featureMap.keySet();
        for (Object k : set) {
            Iterator iterator;
            StringBuffer stringBuffer2;
            Object v = featureMap.get(k);
            if (k == null || v == null) continue;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = k.toString();
            String string6 = v.toString();
            Object object = null;
            if (k instanceof String || k instanceof Number || k instanceof Collection) {
                string = k.getClass().getName();
            }
            if (v instanceof String || v instanceof Number || v instanceof Collection) {
                string3 = v.getClass().getName();
            }
            if (string == null || string3 == null) continue;
            if (k instanceof Collection) {
                stringBuffer2 = new StringBuffer();
                iterator = ((Collection)k).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string2 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer2.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer2.append(";").append(object.toString());
                }
                string5 = stringBuffer2.toString();
            }
            if (v instanceof Collection) {
                stringBuffer2 = new StringBuffer();
                iterator = ((Collection)v).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string4 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer2.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer2.append(";").append(object.toString());
                }
                string6 = stringBuffer2.toString();
            }
            stringBuffer.append("<Feature>\n  <Name");
            if (string != null) {
                stringBuffer.append(" className=\"").append(string).append("\"");
            }
            if (string2 != null) {
                stringBuffer.append(" itemClassName=\"").append(string2).append("\"");
            }
            stringBuffer.append(">");
            stringBuffer2 = new StringBuffer(string5);
            if (map != null) {
                stringBuffer2 = (StringBuffer)map.get(string5);
                if (stringBuffer2 == null) {
                    stringBuffer2 = DocumentXmlUtils.combinedNormalisation(string5);
                    map.put(string5, stringBuffer2);
                }
            } else {
                stringBuffer2 = DocumentXmlUtils.combinedNormalisation(string5);
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("</Name>\n  <Value");
            if (string3 != null) {
                stringBuffer.append(" className=\"").append(string3).append("\"");
            }
            if (string4 != null) {
                stringBuffer.append(" itemClassName=\"").append(string4).append("\"");
            }
            stringBuffer.append(">");
            stringBuffer.append(DocumentXmlUtils.combinedNormalisation(string6));
            stringBuffer.append("</Value>\n</Feature>\n");
        }
        return stringBuffer;
    }

    public static StringBuffer combinedNormalisation(String string) {
        if (string == null) {
            return new StringBuffer("");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (!DocumentXmlUtils.isXmlChar(c)) {
                stringBuffer.replace(i, i + 1, " ");
                continue;
            }
            if (c != '<' && c != '>' && c != '&' && c != '\'' && c != '\"' && c != '\u00a0' && c != '\u00a9') continue;
            stringBuffer.replace(i, i + 1, (String)entitiesMap.get(new Character(c)));
        }
        return stringBuffer;
    }

    public static StringBuffer filterNonXmlChars(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return new StringBuffer("");
        }
        char c = ' ';
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (DocumentXmlUtils.isXmlChar(stringBuffer.charAt(i))) continue;
            stringBuffer.setCharAt(i, c);
        }
        return stringBuffer;
    }

    public static boolean isXmlChar(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (' ' <= c && c <= '\ud7ff') {
            return true;
        }
        if ('\ue000' <= c && c <= '\ufffd') {
            return true;
        }
        return '\u10000' <= c && c <= '\u10ffff';
    }

    public static StringBuffer replaceCharsWithEntities(String string) {
        if (string == null) {
            return new StringBuffer("");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            Character c = new Character(stringBuffer.charAt(i));
            if (!entitiesMap.keySet().contains(c)) continue;
            stringBuffer.replace(i, i + 1, (String)entitiesMap.get(c));
        }
        return stringBuffer;
    }

    public static String textWithNodes(TextualDocument textualDocument, String string) {
        Object object2;
        Map<String, AnnotationSet> map2;
        if (string == null) {
            return new String("");
        }
        StringBuffer stringBuffer = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(string));
        TreeMap treeMap = new TreeMap();
        if (string.length() != 0) {
            DocumentXmlUtils.buildEntityMapFromString(string, treeMap);
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (Map<String, AnnotationSet> map2 : textualDocument.getAnnotations()) {
            treeSet.add(map2.getStartNode().getOffset());
            treeSet.add(map2.getEndNode().getOffset());
        }
        map2 = textualDocument.getNamedAnnotationSets();
        if (map2 != null) {
            for (AnnotationSet annotationSet : map2.values()) {
                for (Object object2 : annotationSet) {
                    treeSet.add(object2.getStartNode().getOffset());
                    treeSet.add(object2.getEndNode().getOffset());
                }
            }
        }
        if (treeSet.isEmpty()) {
            return DocumentXmlUtils.replaceCharsWithEntities(string).toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length() * 2);
        int n = 0;
        TreeSet treeSet2 = new TreeSet();
        treeSet2.addAll(treeSet);
        treeSet2.addAll(treeMap.keySet());
        object2 = treeSet2.iterator();
        while (object2.hasNext()) {
            Long l = (Long)object2.next();
            int n2 = l.intValue();
            if (n2 > n) {
                stringBuffer2.append(stringBuffer.substring(n, n2));
                n = n2;
            }
            if (treeSet.contains(l)) {
                stringBuffer2.append("<Node id=\"").append(n2).append("\"/>");
            }
            if (!treeMap.containsKey(l)) continue;
            String string2 = (String)entitiesMap.get((Character)treeMap.get(l));
            ++n;
            stringBuffer2.append(string2);
        }
        stringBuffer2.append(stringBuffer.substring(n, stringBuffer.length()));
        return stringBuffer2.toString();
    }

    public static void buildEntityMapFromString(String string, TreeMap treeMap) {
        if (string == null || treeMap == null) {
            return;
        }
        if (entitiesMap == null || entitiesMap.isEmpty()) {
            Err.prln("WARNING: Entities map was not initialised !");
            return;
        }
        for (Character c : entitiesMap.keySet()) {
            int n = 0;
            while (-1 != n) {
                n = string.indexOf(c.charValue(), n);
                if (-1 == n) continue;
                treeMap.put(new Long(n), c);
                ++n;
            }
        }
    }

    public static void annotationSetToXml(AnnotationSet annotationSet, StringBuffer stringBuffer) {
        if (annotationSet == null) {
            stringBuffer.append("<AnnotationSet>\n");
            stringBuffer.append("</AnnotationSet>\n");
            return;
        }
        if (annotationSet.getName() == null) {
            stringBuffer.append("<AnnotationSet>\n");
        } else {
            stringBuffer.append("<AnnotationSet Name=\"");
            stringBuffer.append(annotationSet.getName());
            stringBuffer.append("\" >\n");
        }
        HashMap hashMap = new HashMap();
        for (Annotation annotation : annotationSet) {
            stringBuffer.append("<Annotation Id=\"");
            stringBuffer.append(annotation.getId());
            stringBuffer.append("\" Type=\"");
            stringBuffer.append(annotation.getType());
            stringBuffer.append("\" StartNode=\"");
            stringBuffer.append(annotation.getStartNode().getOffset());
            stringBuffer.append("\" EndNode=\"");
            stringBuffer.append(annotation.getEndNode().getOffset());
            stringBuffer.append("\">\n");
            stringBuffer.append(DocumentXmlUtils.featuresToXml(annotation.getFeatures(), hashMap));
            stringBuffer.append("</Annotation>\n");
        }
        stringBuffer.append("</AnnotationSet>\n");
    }

    public static void annotationSetToXml(AnnotationSet annotationSet, String string, StringBuffer stringBuffer) {
        if (annotationSet == null) {
            stringBuffer.append("<AnnotationSet>\n");
            stringBuffer.append("</AnnotationSet>\n");
            return;
        }
        if (string == null || string.trim().length() == 0) {
            stringBuffer.append("<AnnotationSet>\n");
        } else {
            stringBuffer.append("<AnnotationSet Name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" >\n");
        }
        HashMap hashMap = new HashMap();
        for (Annotation annotation : annotationSet) {
            stringBuffer.append("<Annotation Id=\"");
            stringBuffer.append(annotation.getId());
            stringBuffer.append("\" Type=\"");
            stringBuffer.append(annotation.getType());
            stringBuffer.append("\" StartNode=\"");
            stringBuffer.append(annotation.getStartNode().getOffset());
            stringBuffer.append("\" EndNode=\"");
            stringBuffer.append(annotation.getEndNode().getOffset());
            stringBuffer.append("\">\n");
            stringBuffer.append(DocumentXmlUtils.featuresToXml(annotation.getFeatures(), hashMap));
            stringBuffer.append("</Annotation>\n");
        }
        stringBuffer.append("</AnnotationSet>\n");
    }

    static {
        entitiesMap = new HashMap();
        entitiesMap.put(new Character('<'), "&lt;");
        entitiesMap.put(new Character('>'), "&gt;");
        entitiesMap.put(new Character('&'), "&amp;");
        entitiesMap.put(new Character('\''), "&apos;");
        entitiesMap.put(new Character('\"'), "&quot;");
        entitiesMap.put(new Character('\u00a0'), "&#160;");
        entitiesMap.put(new Character('\u00a9'), "&#169;");
    }
}

