/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.TextualDocument;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentStaxUtils {
    private static XMLInputFactory inputFactory = null;
    public static final char INVALID_CHARACTER_REPLACEMENT = ' ';
    public static final int LT_THRESHOLD = 5;
    public static final String XCES_VERSION = "1.0";
    public static final String XCES_NAMESPACE = "http://www.xces.org/schema/2003";
    private static XMLOutputFactory outputFactory = null;
    private static Pattern CDATA_END_PATTERN = Pattern.compile("\\]\\]>");
    public static final Comparator<Annotation> LONGEST_FIRST_OFFSET_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation annotation, Annotation annotation2) {
            long l;
            long l2 = annotation.getStartNode().getOffset();
            if (l2 == (l = annotation2.getStartNode().getOffset().longValue())) {
                l2 = annotation.getEndNode().getOffset();
                if (l2 == (l = annotation2.getEndNode().getOffset().longValue())) {
                    return annotation.getId() - annotation2.getId();
                }
                return (int)(l - l2);
            }
            return (int)(l2 - l);
        }
    };

    public static void readGateXmlDocument(XMLStreamReader xMLStreamReader, Document document) throws XMLStreamException {
        DocumentStaxUtils.readGateXmlDocument(xMLStreamReader, document, null);
    }

    public static void readGateXmlDocument(XMLStreamReader xMLStreamReader, Document document, StatusListener statusListener) throws XMLStreamException {
        DocumentContent documentContent = null;
        xMLStreamReader.require(1, null, "GateDocument");
        xMLStreamReader.nextTag();
        xMLStreamReader.require(1, null, "GateDocumentFeatures");
        if (statusListener != null) {
            statusListener.statusChanged("Reading document features");
        }
        FeatureMap featureMap = DocumentStaxUtils.readFeatureMap(xMLStreamReader);
        xMLStreamReader.nextTag();
        xMLStreamReader.require(1, null, "TextWithNodes");
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        if (statusListener != null) {
            statusListener.statusChanged("Reading document content");
        }
        String string = DocumentStaxUtils.readTextWithNodes(xMLStreamReader, hashMap);
        documentContent = document.getContent();
        document.setContent(new DocumentContentImpl(string));
        try {
            int n = 0;
            Integer n2 = null;
            Boolean bl = null;
            int n3 = xMLStreamReader.nextTag();
            while (n3 == 1) {
                xMLStreamReader.require(1, null, "AnnotationSet");
                String string2 = xMLStreamReader.getAttributeValue(null, "Name");
                AnnotationSet annotationSet = null;
                if (string2 == null) {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading default annotation set");
                    }
                    annotationSet = document.getAnnotations();
                } else {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading \"" + string2 + "\" annotation set");
                    }
                    annotationSet = document.getAnnotations(string2);
                }
                annotationSet.clear();
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                bl = DocumentStaxUtils.readAnnotationSet(xMLStreamReader, annotationSet, hashMap, treeSet, bl);
                if (treeSet.size() > 0 && (n2 == null || (Integer)treeSet.last() > n2)) {
                    n2 = (Integer)treeSet.last();
                }
                n += treeSet.size();
                n3 = xMLStreamReader.nextTag();
            }
            xMLStreamReader.require(2, null, "GateDocument");
            document.setFeatures(featureMap);
            if (document instanceof DocumentImpl && n2 != null) {
                ((DocumentImpl)document).setNextAnnotationId(n2 + 1);
            }
            if (statusListener != null) {
                statusListener.statusChanged("Finished.  " + n + " annotation(s) processed");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            document.setContent(documentContent);
            throw xMLStreamException;
        }
        catch (RuntimeException runtimeException) {
            document.setContent(documentContent);
            throw runtimeException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean readAnnotationSet(XMLStreamReader xMLStreamReader, AnnotationSet annotationSet, Map<Integer, Long> map, Set<Integer> set, Boolean bl) throws XMLStreamException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (xMLStreamReader.nextTag() == 1) {
            int n;
            xMLStreamReader.require(1, null, "Annotation");
            AnnotationObject annotationObject = new AnnotationObject();
            annotationObject.setElemName(xMLStreamReader.getAttributeValue(null, "Type"));
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "StartNode"));
                if (map != null) {
                    Long l = map.get(new Integer(n));
                    if (l == null) throw new XMLStreamException("Invalid start node ID", xMLStreamReader.getLocation());
                    annotationObject.setStart(l);
                } else {
                    annotationObject.setStart(new Long(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for StartNode", xMLStreamReader.getLocation());
            }
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "EndNode"));
                if (map != null) {
                    Long l = map.get(new Integer(n));
                    if (l == null) throw new XMLStreamException("Invalid end node ID", xMLStreamReader.getLocation());
                    annotationObject.setEnd(l);
                } else {
                    annotationObject.setEnd(new Long(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for EndNode", xMLStreamReader.getLocation());
            }
            Object object = xMLStreamReader.getAttributeValue(null, "Id");
            if (object == null) {
                if (bl == null) {
                    bl = Boolean.FALSE;
                } else if (bl.booleanValue()) {
                    throw new XMLStreamException("New style GATE XML format requires that every annotation specify its Id, but an annotation with no Id was found", xMLStreamReader.getLocation());
                }
            } else {
                if (bl == null) {
                    bl = Boolean.TRUE;
                } else if (!bl.booleanValue()) {
                    throw new XMLStreamException("Old style GATE XML format requires that no annotation specifies its Id, but an annotation with an Id was found", xMLStreamReader.getLocation());
                }
                try {
                    Integer n2 = Integer.valueOf((String)object);
                    if (set.contains(n2)) {
                        throw new XMLStreamException("Annotation IDs must be unique within an annotation set. Found duplicate ID", xMLStreamReader.getLocation());
                    }
                    set.add(n2);
                    annotationObject.setId(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XMLStreamException("Non-integer annotation ID found", xMLStreamReader.getLocation());
                }
            }
            annotationObject.setFM(DocumentStaxUtils.readFeatureMap(xMLStreamReader));
            arrayList.add(annotationObject);
        }
        for (Object object : arrayList) {
            try {
                if (((AnnotationObject)object).getId() != null) {
                    annotationSet.add(((AnnotationObject)object).getId(), ((AnnotationObject)object).getStart(), ((AnnotationObject)object).getEnd(), ((AnnotationObject)object).getElemName(), ((AnnotationObject)object).getFM());
                    continue;
                }
                annotationSet.add(((AnnotationObject)object).getStart(), ((AnnotationObject)object).getEnd(), ((AnnotationObject)object).getElemName(), ((AnnotationObject)object).getFM());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new XMLStreamException("Invalid offset when creating annotation " + object, invalidOffsetException);
            }
        }
        return bl;
    }

    public static String readTextWithNodes(XMLStreamReader xMLStreamReader, Map<Integer, Long> map) throws XMLStreamException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(20480);
        while ((n = xMLStreamReader.next()) != 2) {
            switch (n) {
                case 4: {
                    stringBuffer.append(xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
                    break;
                }
                case 1: {
                    xMLStreamReader.require(1, null, "Node");
                    String string = xMLStreamReader.getAttributeValue(null, "id");
                    if (string == null) {
                        throw new XMLStreamException("Node element has no id", xMLStreamReader.getLocation());
                    }
                    try {
                        Integer n2 = Integer.valueOf(string);
                        Long l = new Long(stringBuffer.length());
                        map.put(n2, l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new XMLStreamException("Node element must have integer id", xMLStreamReader.getLocation());
                    }
                    if (xMLStreamReader.next() == 2) break;
                    throw new XMLStreamException("Node element within TextWithNodes must be empty.", xMLStreamReader.getLocation());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static FeatureMap readFeatureMap(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        FeatureMap featureMap = Factory.newFeatureMap();
        while (xMLStreamReader.nextTag() == 1) {
            xMLStreamReader.require(1, null, "Feature");
            Object object = null;
            Object object2 = null;
            while (xMLStreamReader.nextTag() == 1) {
                if ("Name".equals(xMLStreamReader.getLocalName())) {
                    object = DocumentStaxUtils.readFeatureNameOrValue(xMLStreamReader);
                    continue;
                }
                if ("Value".equals(xMLStreamReader.getLocalName())) {
                    object2 = DocumentStaxUtils.readFeatureNameOrValue(xMLStreamReader);
                    continue;
                }
                throw new XMLStreamException("Feature element should contain only Name and Value children", xMLStreamReader.getLocation());
            }
            featureMap.put(object, object2);
        }
        return featureMap;
    }

    static Object readFeatureNameOrValue(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n;
        String string;
        String string2 = xMLStreamReader.getAttributeValue(null, "className");
        if (string2 == null) {
            string2 = "java.lang.String";
        }
        if ((string = xMLStreamReader.getAttributeValue(null, "itemClassName")) == null) {
            string = "java.lang.String";
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        block17: while ((n = xMLStreamReader.next()) != 2) {
            switch (n) {
                case 4: {
                    stringBuffer.append(xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
                    continue block17;
                }
                case 1: {
                    throw new XMLStreamException("Elements not allowed within feature name or value element.", xMLStreamReader.getLocation());
                }
            }
        }
        if ("java.lang.String".equals(string2)) {
            return stringBuffer.toString();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2, true, Gate.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return stringBuffer.toString();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Object object;
            Class<?> clazz2 = null;
            Constructor<?> constructor = null;
            Collection collection = null;
            boolean bl = false;
            try {
                collection = (Collection)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                return stringBuffer.toString();
            }
            catch (InstantiationException instantiationException) {
                return stringBuffer.toString();
            }
            if ("java.lang.String".equals(string)) {
                bl = true;
            } else {
                try {
                    clazz2 = Class.forName(string, true, Gate.getClassLoader());
                    object = new Class[]{String.class};
                    constructor = clazz2.getConstructor((Class<?>)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Out.prln("Warning: Item class " + string + " not found." + "Adding items as Strings");
                    bl = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
            }
            object = new StringTokenizer(stringBuffer.toString(), ";");
            Object[] objectArray = new Object[1];
            Object e = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (bl) {
                    collection.add(string3);
                    continue;
                }
                objectArray[0] = string3;
                try {
                    e = constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    throw new XMLStreamException("An item(" + string3 + ")  does not comply with its class" + " definition(" + string + ")", xMLStreamReader.getLocation());
                }
                collection.add(e);
            }
            return collection;
        }
        Class[] classArray = new Class[]{String.class};
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{stringBuffer.toString()};
            Object obj = constructor.newInstance(objectArray);
            return obj;
        }
        catch (Exception exception) {
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readXces(InputStream inputStream, AnnotationSet annotationSet) throws XMLStreamException {
        if (inputFactory == null) {
            inputFactory = XMLInputFactory.newInstance();
        }
        XMLStreamReader xMLStreamReader = inputFactory.createXMLStreamReader(inputStream);
        try {
            DocumentStaxUtils.nextTagSkipDTD(xMLStreamReader);
            DocumentStaxUtils.readXces(xMLStreamReader, annotationSet);
        }
        finally {
            xMLStreamReader.close();
        }
    }

    private static int nextTagSkipDTD(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.next();
        while (n == 4 && xMLStreamReader.isWhiteSpace() || n == 12 && xMLStreamReader.isWhiteSpace() || n == 6 || n == 3 || n == 5 || n == 11) {
            n = xMLStreamReader.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("expected start or end tag", xMLStreamReader.getLocation());
        }
        return n;
    }

    public static void readXces(XMLStreamReader xMLStreamReader, AnnotationSet annotationSet) throws XMLStreamException {
        Object object;
        AnnotationObject annotationObject;
        Serializable serializable2;
        xMLStreamReader.require(1, XCES_NAMESPACE, "cesAna");
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Serializable serializable2 : annotationSet) {
            treeSet.add(serializable2.getId());
        }
        ArrayList arrayList = new ArrayList();
        serializable2 = new ArrayList();
        while (xMLStreamReader.nextTag() == 1) {
            int n;
            xMLStreamReader.require(1, XCES_NAMESPACE, "struct");
            annotationObject = new AnnotationObject();
            annotationObject.setElemName(xMLStreamReader.getAttributeValue(null, "type"));
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "from"));
                annotationObject.setStart(new Long(n));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for struct/@from", xMLStreamReader.getLocation());
            }
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "to"));
                annotationObject.setEnd(new Long(n));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for struct/@to", xMLStreamReader.getLocation());
            }
            object = xMLStreamReader.getAttributeValue(null, "n");
            if (object != null) {
                try {
                    Integer n2 = Integer.valueOf((String)object);
                    if (treeSet.contains(n2)) {
                        throw new XMLStreamException("Annotation IDs must be unique within an annotation set. Found duplicate ID", xMLStreamReader.getLocation());
                    }
                    treeSet.add(n2);
                    annotationObject.setId(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XMLStreamException("Non-integer annotation ID found", xMLStreamReader.getLocation());
                }
            }
            annotationObject.setFM(DocumentStaxUtils.readXcesFeatureMap(xMLStreamReader));
            if (annotationObject.getId() != null) {
                arrayList.add(annotationObject);
                continue;
            }
            serializable2.add(annotationObject);
        }
        annotationObject = null;
        try {
            object = arrayList.iterator();
            while (object.hasNext()) {
                annotationObject = (AnnotationObject)object.next();
                annotationSet.add(annotationObject.getId(), annotationObject.getStart(), annotationObject.getEnd(), annotationObject.getElemName(), annotationObject.getFM());
            }
            object = serializable2.iterator();
            while (object.hasNext()) {
                annotationObject = (AnnotationObject)object.next();
                annotationSet.add(annotationObject.getStart(), annotationObject.getEnd(), annotationObject.getElemName(), annotationObject.getFM());
            }
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new XMLStreamException("Invalid offset when creating annotation " + annotationObject, invalidOffsetException);
        }
    }

    public static FeatureMap readXcesFeatureMap(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        FeatureMap featureMap = Factory.newFeatureMap();
        while (xMLStreamReader.nextTag() == 1) {
            xMLStreamReader.require(1, XCES_NAMESPACE, "feat");
            String string = xMLStreamReader.getAttributeValue(null, "name");
            String string2 = xMLStreamReader.getAttributeValue(null, "value");
            featureMap.put(string, string2);
            xMLStreamReader.nextTag();
            xMLStreamReader.require(2, XCES_NAMESPACE, "feat");
        }
        return featureMap;
    }

    public static String toXml(Document document) {
        try {
            if (outputFactory == null) {
                outputFactory = XMLOutputFactory.newInstance();
            }
            StringWriter stringWriter = new StringWriter(document.getContent().size().intValue() * 40);
            XMLStreamWriter xMLStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            if (document instanceof TextualDocument) {
                xMLStreamWriter.writeStartDocument(((TextualDocument)document).getEncoding(), XCES_VERSION);
            } else {
                xMLStreamWriter.writeStartDocument(XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeDocument(document, xMLStreamWriter, "");
            xMLStreamWriter.close();
            return stringWriter.toString();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new GateRuntimeException("Error converting document to XML", xMLStreamException);
        }
    }

    public static void writeDocument(Document document, File file) throws XMLStreamException, IOException {
        DocumentStaxUtils.writeDocument(document, file, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, String string) throws XMLStreamException, IOException {
        if (outputFactory == null) {
            outputFactory = XMLOutputFactory.newInstance();
        }
        XMLStreamWriter xMLStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            if (document instanceof TextualDocument) {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(fileOutputStream, ((TextualDocument)document).getEncoding());
                xMLStreamWriter.writeStartDocument(((TextualDocument)document).getEncoding(), XCES_VERSION);
            } else {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(fileOutputStream);
                xMLStreamWriter.writeStartDocument(XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeDocument(document, xMLStreamWriter, string);
        }
        finally {
            if (xMLStreamWriter != null) {
                xMLStreamWriter.close();
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void writeDocument(Document document, Map<String, Collection<Annotation>> map, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(string, "GateDocument");
        xMLStreamWriter.setDefaultNamespace(string);
        if (string.length() > 0) {
            xMLStreamWriter.writeDefaultNamespace(string);
        }
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeComment(" The document's features");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeStartElement(string, "GateDocumentFeatures");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.writeFeatures(document.getFeatures(), xMLStreamWriter, string);
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeComment(" The document content area with serialized nodes ");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.writeTextWithNodes(document, map.values(), xMLStreamWriter, string);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        StatusListener statusListener = (StatusListener)((Object)MainFrame.getListeners().get("gate.event.StatusListener"));
        if (map.containsKey(null)) {
            if (statusListener != null) {
                statusListener.statusChanged("Saving the default annotation set ");
            }
            xMLStreamWriter.writeComment(" The default annotation set ");
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeAnnotationSet(map.get(null), null, xMLStreamWriter, string);
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
        for (String string2 : map.keySet()) {
            if (string2 == null) continue;
            Collection<Annotation> collection = map.get(string2);
            xMLStreamWriter.writeComment(" Named annotation set ");
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.newLine(xMLStreamWriter);
            if (statusListener != null) {
                statusListener.statusChanged("Saving " + string2 + " annotation set ");
            }
            DocumentStaxUtils.writeAnnotationSet(collection, string2, xMLStreamWriter, string);
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
    }

    public static void writeDocument(Document document, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        HashMap<String, Collection<Annotation>> hashMap = new HashMap<String, Collection<Annotation>>();
        hashMap.put(null, document.getAnnotations());
        if (document.getNamedAnnotationSets() != null) {
            hashMap.putAll(document.getNamedAnnotationSets());
        }
        DocumentStaxUtils.writeDocument(document, hashMap, xMLStreamWriter, string);
    }

    public static void writeAnnotationSet(AnnotationSet annotationSet, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        DocumentStaxUtils.writeAnnotationSet((Collection<Annotation>)annotationSet, annotationSet.getName(), xMLStreamWriter, string);
    }

    public static void writeAnnotationSet(Collection<Annotation> collection, String string, XMLStreamWriter xMLStreamWriter, String string2) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(string2, "AnnotationSet");
        if (string != null) {
            xMLStreamWriter.writeAttribute("Name", string);
        }
        DocumentStaxUtils.newLine(xMLStreamWriter);
        if (collection != null) {
            for (Annotation annotation : collection) {
                xMLStreamWriter.writeStartElement(string2, "Annotation");
                xMLStreamWriter.writeAttribute("Id", String.valueOf(annotation.getId()));
                xMLStreamWriter.writeAttribute("Type", annotation.getType());
                xMLStreamWriter.writeAttribute("StartNode", String.valueOf(annotation.getStartNode().getOffset()));
                xMLStreamWriter.writeAttribute("EndNode", String.valueOf(annotation.getEndNode().getOffset()));
                DocumentStaxUtils.newLine(xMLStreamWriter);
                DocumentStaxUtils.writeFeatures(annotation.getFeatures(), xMLStreamWriter, string2);
                xMLStreamWriter.writeEndElement();
                DocumentStaxUtils.newLine(xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
    }

    public static void writeAnnotationSet(AnnotationSet annotationSet, String string, XMLStreamWriter xMLStreamWriter, String string2) throws XMLStreamException {
        DocumentStaxUtils.writeAnnotationSet((Collection<Annotation>)annotationSet, string, xMLStreamWriter, string2);
    }

    public static void writeTextWithNodes(Document document, Collection<Collection<Annotation>> collection, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        int n;
        String string2 = document.getContent().toString();
        if (string2 == null) {
            xMLStreamWriter.writeEmptyElement(string, "TextWithNodes");
            return;
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        if (collection != null) {
            for (Collection collection2 : collection) {
                if (collection2 == null) continue;
                for (Annotation n2 : collection2) {
                    treeSet.add(n2.getStartNode().getOffset());
                    treeSet.add(n2.getEndNode().getOffset());
                }
            }
        }
        Object object = string2.toCharArray();
        DocumentStaxUtils.replaceXMLIllegalCharacters((char[])object);
        xMLStreamWriter.writeStartElement(string, "TextWithNodes");
        boolean n2 = false;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n3 = ((Long)iterator.next()).intValue();
            DocumentStaxUtils.writeCharactersOrCDATA(xMLStreamWriter, new String((char[])object, n, n3 - n));
            xMLStreamWriter.writeEmptyElement(string, "Node");
            xMLStreamWriter.writeAttribute("id", String.valueOf(n3));
            n = n3;
        }
        DocumentStaxUtils.writeCharactersOrCDATA(xMLStreamWriter, new String((char[])object, n, ((Object)object).length - n));
        xMLStreamWriter.writeEndElement();
    }

    public static void writeTextWithNodes(Document document, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        ArrayList<Collection<Annotation>> arrayList = new ArrayList<Collection<Annotation>>();
        arrayList.add(document.getAnnotations());
        if (document.getNamedAnnotationSets() != null) {
            arrayList.addAll(document.getNamedAnnotationSets().values());
        }
        DocumentStaxUtils.writeTextWithNodes(document, arrayList, xMLStreamWriter, string);
    }

    static void replaceXMLIllegalCharacters(char[] cArray) {
        ArrayCharSequence arrayCharSequence = new ArrayCharSequence(cArray);
        for (int i = 0; i < cArray.length; ++i) {
            if (!DocumentStaxUtils.isInvalidXmlChar(arrayCharSequence, i)) continue;
            cArray[i] = 32;
        }
    }

    static String replaceXMLIllegalCharactersInString(String string) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < string.length(); ++i) {
            if (DocumentStaxUtils.isInvalidXmlChar(string, i)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(0, i));
                }
                stringBuilder.append(' ');
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(string.charAt(i));
        }
        if (stringBuilder == null) {
            return string;
        }
        return stringBuilder.toString();
    }

    static final boolean isInvalidXmlChar(CharSequence charSequence, int n) {
        if (charSequence.charAt(n) <= '\b' || charSequence.charAt(n) == '\u000b' || charSequence.charAt(n) == '\f' || charSequence.charAt(n) >= '\u000e' && charSequence.charAt(n) <= '\u001f') {
            return true;
        }
        if (charSequence.charAt(n) >= '\ud800' && charSequence.charAt(n) <= '\udbff') {
            return n >= charSequence.length() - 1 || charSequence.charAt(n + 1) < '\udc00' || charSequence.charAt(n + 1) > '\udfff';
        }
        if (charSequence.charAt(n) >= '\udc00' && charSequence.charAt(n) <= '\udfff') {
            return n <= 0 || charSequence.charAt(n - 1) < '\ud800' || charSequence.charAt(n - 1) > '\udbff';
        }
        return charSequence.charAt(n) == '\ufffe' || charSequence.charAt(n) == '\uffff';
    }

    public static void writeFeatures(FeatureMap featureMap, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        if (featureMap == null) {
            return;
        }
        Set set = featureMap.keySet();
        for (Object k : set) {
            Iterator iterator;
            StringBuffer stringBuffer;
            Object v = featureMap.get(k);
            if (k == null || v == null) continue;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = k.toString();
            String string7 = v.toString();
            Object object = null;
            if (k instanceof String || k instanceof Number || k instanceof Collection) {
                string2 = k.getClass().getName();
            }
            if (v instanceof String || v instanceof Number || v instanceof Collection) {
                string4 = v.getClass().getName();
            }
            if (string2 == null || string4 == null) continue;
            if (k instanceof Collection) {
                stringBuffer = new StringBuffer();
                iterator = ((Collection)k).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string3 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer.append(";").append(object.toString());
                }
                string6 = stringBuffer.toString();
            }
            if (v instanceof Collection) {
                stringBuffer = new StringBuffer();
                iterator = ((Collection)v).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string5 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer.append(";").append(object.toString());
                }
                string7 = stringBuffer.toString();
            }
            xMLStreamWriter.writeStartElement(string, "Feature");
            xMLStreamWriter.writeCharacters("\n  ");
            xMLStreamWriter.writeStartElement(string, "Name");
            if (string2 != null) {
                xMLStreamWriter.writeAttribute("className", string2);
            }
            if (string3 != null) {
                xMLStreamWriter.writeAttribute("itemClassName", string3);
            }
            xMLStreamWriter.writeCharacters(string6);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n  ");
            xMLStreamWriter.writeStartElement(string, "Value");
            if (string4 != null) {
                xMLStreamWriter.writeAttribute("className", string4);
            }
            if (string5 != null) {
                xMLStreamWriter.writeAttribute("itemClassName", string5);
            }
            DocumentStaxUtils.writeCharactersOrCDATA(xMLStreamWriter, DocumentStaxUtils.replaceXMLIllegalCharactersInString(string7));
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
    }

    static void newLine(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeCharacters("\n");
    }

    static void writeCharactersOrCDATA(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        if (DocumentStaxUtils.containsEnoughLTs(string)) {
            Matcher matcher = CDATA_END_PATTERN.matcher(string);
            int n = 0;
            while (matcher.find()) {
                xMLStreamWriter.writeCData(string.substring(n, matcher.start()));
                xMLStreamWriter.writeCharacters("]]>");
                n = matcher.end();
            }
            if (n == 0) {
                xMLStreamWriter.writeCData(string);
            } else if (n < string.length()) {
                xMLStreamWriter.writeCData(string.substring(n));
            }
        } else {
            xMLStreamWriter.writeCharacters(string);
        }
    }

    private static boolean containsEnoughLTs(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(60, n2 + 1)) >= 0) {
            if (++n < 5) continue;
            return true;
        }
        return false;
    }

    public static void writeXcesContent(Document document, OutputStream outputStream, String string) throws IOException {
        if (string == null) {
            string = "UTF-8";
        }
        String string2 = document.getContent().toString();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write(string2);
        bufferedWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXcesAnnotations(Collection<Annotation> collection, OutputStream outputStream, String string) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter = null;
        try {
            if (string == null) {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(outputStream);
                xMLStreamWriter.writeStartDocument();
            } else {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(outputStream, string);
                xMLStreamWriter.writeStartDocument(string, XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeXcesAnnotations(collection, xMLStreamWriter);
        }
        finally {
            if (xMLStreamWriter != null) {
                xMLStreamWriter.close();
            }
        }
    }

    public static void writeXcesAnnotations(Collection<Annotation> collection, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        DocumentStaxUtils.writeXcesAnnotations(collection, xMLStreamWriter, true);
    }

    public static void writeXcesAnnotations(Collection<Annotation> collection, XMLStreamWriter xMLStreamWriter, boolean bl) throws XMLStreamException {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(collection);
        Collections.sort(arrayList, LONGEST_FIRST_OFFSET_COMPARATOR);
        xMLStreamWriter.setDefaultNamespace(XCES_NAMESPACE);
        xMLStreamWriter.writeStartElement(XCES_NAMESPACE, "cesAna");
        xMLStreamWriter.writeDefaultNamespace(XCES_NAMESPACE);
        xMLStreamWriter.writeAttribute("version", XCES_VERSION);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        String string = "   ";
        String string2 = string + string;
        for (Annotation annotation : arrayList) {
            long l = annotation.getStartNode().getOffset();
            long l2 = annotation.getEndNode().getOffset();
            FeatureMap featureMap = annotation.getFeatures();
            xMLStreamWriter.writeCharacters(string);
            if (featureMap == null || featureMap.size() == 0) {
                xMLStreamWriter.writeEmptyElement(XCES_NAMESPACE, "struct");
            } else {
                xMLStreamWriter.writeStartElement(XCES_NAMESPACE, "struct");
            }
            xMLStreamWriter.writeAttribute("type", annotation.getType());
            xMLStreamWriter.writeAttribute("from", String.valueOf(l));
            xMLStreamWriter.writeAttribute("to", String.valueOf(l2));
            if (bl) {
                xMLStreamWriter.writeAttribute("n", String.valueOf(annotation.getId()));
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            if (featureMap == null || featureMap.size() == 0) continue;
            for (Map.Entry entry : featureMap.entrySet()) {
                if ("isEmptyAndSpan".equals(entry.getKey())) continue;
                xMLStreamWriter.writeCharacters(string2);
                xMLStreamWriter.writeEmptyElement(XCES_NAMESPACE, "feat");
                xMLStreamWriter.writeAttribute("name", String.valueOf(entry.getKey()));
                xMLStreamWriter.writeAttribute("value", DocumentStaxUtils.replaceXMLIllegalCharactersInString(String.valueOf(entry.getValue())));
                DocumentStaxUtils.newLine(xMLStreamWriter);
            }
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
    }

    static class ArrayCharSequence
    implements CharSequence {
        char[] array;

        ArrayCharSequence(char[] cArray) {
            this.array = cArray;
        }

        public final char charAt(int n) {
            return this.array[n];
        }

        public final int length() {
            return this.array.length;
        }

        public CharSequence subSequence(int n, int n2) {
            throw new UnsupportedOperationException("subSequence not implemented");
        }

        public String toString() {
            return String.valueOf(this.array);
        }
    }

    static class AnnotationObject {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n) {
            this.id = n;
        }

        public String toString() {
            return " [id =" + this.id + " type=" + this.elemName + " startNode=" + this.start + " endNode=" + this.end + " features=" + this.fm + "] ";
        }
    }
}

