/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.ResourceInstantiationException;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CorpusAnnotationDiff
extends AbstractVisualResource
implements Scrollable {
    protected int maxUnitIncrement = 10;
    private static final boolean DEBUG = false;
    private Document keyDocument = null;
    private Corpus keyCorpus = null;
    private String keyAnnotationSetName = null;
    private Document responseDocument = null;
    private Corpus responseCorpus = null;
    private String responseAnnotationSetName = null;
    private String responseAnnotationSetNameFalsePoz = null;
    private AnnotationSchema annotationSchema = null;
    private Set keyFeatureNamesSet = null;
    private double precisionStrict = 0.0;
    private double precisionLenient = 0.0;
    private double precisionAverage = 0.0;
    private double recallStrict = 0.0;
    private double recallLenient = 0.0;
    private double recallAverage = 0.0;
    private double falsePositiveStrict = 0.0;
    private double falsePositiveLenient = 0.0;
    private double falsePositiveAverage = 0.0;
    private double fMeasureStrict = 0.0;
    private double fMeasureLenient = 0.0;
    private double fMeasureAverage = 0.0;
    public static double weight = 0.5;
    private String annotationTypeForFalsePositive = null;
    protected static NumberFormat formatter = NumberFormat.getInstance();
    private XJTable diffTable = null;
    private Set diffSet = null;
    private Set keyPartiallySet = null;
    private Set responsePartiallySet = null;
    private List keyAnnotList = null;
    private List responseAnnotList = null;
    private boolean textMode = false;
    public static final int MAX_TYPES = 5;
    public static final int DEFAULT_TYPE = 0;
    public static final int CORRECT_TYPE = 1;
    public static final int PARTIALLY_CORRECT_TYPE = 2;
    public static final int SPURIOUS_TYPE = 3;
    public static final int MISSING_TYPE = 4;
    private final Color RED = new Color(255, 173, 181);
    private final Color GREEN = new Color(173, 255, 214);
    private final Color WHITE = new Color(255, 255, 255);
    private final Color BLUE = new Color(173, 215, 255);
    private final Color YELLOW = new Color(255, 231, 173);
    private final int NULL_TYPE = -1;
    private final Color BLACK = new Color(0, 0, 0);
    private Color[] colors = new Color[5];
    private JScrollPane scrollPane = null;
    private int[] typeCounter = new int[5];

    public void setAnnotationTypeForFalsePositive(String string) {
        this.annotationTypeForFalsePositive = string;
    }

    public String getAnnotationTypeForFalsePositive() {
        return this.annotationTypeForFalsePositive;
    }

    public void setKeyCorpus(Corpus corpus) {
        this.keyCorpus = corpus;
    }

    public Corpus getKeyCorpus() {
        return this.keyCorpus;
    }

    public void setKeyAnnotationSetName(String string) {
        this.keyAnnotationSetName = string;
    }

    public String getKeyAnnotationSetName() {
        return this.keyAnnotationSetName;
    }

    public void setKeyFeatureNamesSet(Set set) {
        this.keyFeatureNamesSet = set;
    }

    public Set getKeyFeatureNamesSet() {
        return this.keyFeatureNamesSet;
    }

    public void setResponseAnnotationSetName(String string) {
        this.responseAnnotationSetName = string;
    }

    public String getResponseAnnotationSetName() {
        return this.responseAnnotationSetName;
    }

    public void setResponseAnnotationSetNameFalsePoz(String string) {
        this.responseAnnotationSetNameFalsePoz = string;
    }

    public String getResponseAnnotationSetNameFalsePoz() {
        return this.responseAnnotationSetNameFalsePoz;
    }

    public void setTextMode(Boolean bl) {
        this.textMode = bl;
    }

    public boolean isTextMode() {
        return this.textMode;
    }

    public Set getAnnotationsOfType(int n) {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        if (this.diffSet == null) {
            return hashSet;
        }
        for (DiffSetElement diffSetElement : this.diffSet) {
            switch (n) {
                case 1: {
                    if (diffSetElement.getRightType() != 1) break;
                    hashSet.add(diffSetElement.getRightAnnotation());
                    break;
                }
                case 2: {
                    if (diffSetElement.getRightType() != 2) break;
                    hashSet.add(diffSetElement.getRightAnnotation());
                    break;
                }
                case 3: {
                    if (diffSetElement.getRightType() != 3) break;
                    hashSet.add(diffSetElement.getRightAnnotation());
                    break;
                }
                case 4: {
                    if (diffSetElement.getLeftType() != 4) break;
                    hashSet.add(diffSetElement.getLeftAnnotation());
                    break;
                }
                case 0: {
                    if (diffSetElement.getLeftType() != 0) break;
                    hashSet.add(diffSetElement.getLeftAnnotation());
                }
            }
        }
        return hashSet;
    }

    public Object getParameterValue(String string) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, string);
    }

    public void setParameterValue(String string, Object object) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        AbstractResource.setParameterValue(this, beanInfo, string, object);
    }

    public void setParameterValues(FeatureMap featureMap) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, featureMap);
    }

    public double getPrecisionStrict() {
        return this.precisionStrict;
    }

    public double getPrecisionLenient() {
        return this.precisionLenient;
    }

    public double getPrecisionAverage() {
        return this.precisionAverage;
    }

    public double getFMeasureStrict() {
        return this.fMeasureStrict;
    }

    public double getFMeasureLenient() {
        return this.fMeasureLenient;
    }

    public double getFMeasureAverage() {
        return this.fMeasureAverage;
    }

    public double getRecallStrict() {
        return this.recallStrict;
    }

    public double getRecallLenient() {
        return this.recallLenient;
    }

    public double getRecallAverage() {
        return this.recallAverage;
    }

    public double getFalsePositiveStrict() {
        return this.falsePositiveStrict;
    }

    public double getFalsePositiveLenient() {
        return this.falsePositiveLenient;
    }

    public double getFalsePositiveAverage() {
        return this.falsePositiveAverage;
    }

    public void setResponseCorpus(Corpus corpus) {
        this.responseCorpus = corpus;
    }

    public void setAnnotationSchema(AnnotationSchema annotationSchema) {
        this.annotationSchema = annotationSchema;
    }

    public AnnotationSchema getAnnotationSchema() {
        return this.annotationSchema;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.maxUnitIncrement;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - this.maxUnitIncrement;
        }
        return rectangle.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Resource init() throws ResourceInstantiationException {
        Serializable serializable;
        int n;
        this.colors[0] = this.WHITE;
        this.colors[1] = this.GREEN;
        this.colors[3] = this.RED;
        this.colors[2] = this.BLUE;
        this.colors[4] = this.YELLOW;
        this.keyPartiallySet = new HashSet();
        this.responsePartiallySet = new HashSet();
        AnnotationSet annotationSet = null;
        AnnotationSet annotationSet2 = null;
        if (this.annotationSchema == null) {
            throw new ResourceInstantiationException("No annotation schema defined !");
        }
        if (this.keyCorpus == null || 0 == this.keyCorpus.size()) {
            throw new ResourceInstantiationException("No key corpus or empty defined !");
        }
        if (this.responseCorpus == null || 0 == this.responseCorpus.size()) {
            throw new ResourceInstantiationException("No response corpus or empty defined !");
        }
        for (n = 0; n < 5; ++n) {
            this.typeCounter[n] = 0;
        }
        this.diffSet = new HashSet();
        for (n = 0; n < this.keyCorpus.size(); ++n) {
            this.keyDocument = (Document)this.keyCorpus.get(n);
            this.responseDocument = null;
            for (int i = 0; i < this.responseCorpus.size(); ++i) {
                serializable = (Document)this.responseCorpus.get(i);
                if (0 != serializable.getName().compareTo(this.keyDocument.getName()) && 0 != serializable.getSourceUrl().getFile().compareTo(this.keyDocument.getSourceUrl().getFile())) continue;
                this.responseDocument = serializable;
                break;
            }
            if (null == this.responseDocument) {
                Out.prln("There is no mach in responce corpus for document '" + this.keyDocument.getName() + "' from key corpus");
                continue;
            }
            annotationSet = this.keyAnnotationSetName == null ? this.keyDocument.getAnnotations().get(this.annotationSchema.getAnnotationName()) : this.keyDocument.getAnnotations(this.keyAnnotationSetName).get(this.annotationSchema.getAnnotationName());
            this.keyAnnotList = annotationSet == null ? new LinkedList() : new LinkedList<Annotation>(annotationSet);
            annotationSet2 = this.responseAnnotationSetName == null ? this.responseDocument.getAnnotations().get(this.annotationSchema.getAnnotationName()) : this.responseDocument.getAnnotations(this.responseAnnotationSetName).get(this.annotationSchema.getAnnotationName());
            this.responseAnnotList = annotationSet2 == null ? new LinkedList() : new LinkedList<Annotation>(annotationSet2);
            AnnotationSetComparator annotationSetComparator = new AnnotationSetComparator();
            Collections.sort(this.keyAnnotList, annotationSetComparator);
            Collections.sort(this.responseAnnotList, annotationSetComparator);
            this.doDiff(this.keyAnnotList, this.responseAnnotList);
        }
        if (this.textMode) {
            return this;
        }
        formatter.setMaximumIntegerDigits(1);
        formatter.setMinimumFractionDigits(4);
        formatter.setMinimumFractionDigits(4);
        AnnotationDiffTableModel annotationDiffTableModel = new AnnotationDiffTableModel(this.diffSet);
        this.diffTable = new XJTable(annotationDiffTableModel);
        this.diffTable.setAlignmentX(0.0f);
        serializable = new AnnotationDiffCellRenderer();
        this.diffTable.setDefaultRenderer(String.class, (TableCellRenderer)((Object)serializable));
        this.diffTable.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)serializable));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusAnnotationDiff.this.arangeAllComponents();
            }
        });
        return this;
    }

    protected void arangeAllComponents() {
        this.removeAll();
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        JTableHeader jTableHeader = this.diffTable.getTableHeader();
        jTableHeader.setAlignmentX(0.0f);
        this.add(jTableHeader);
        this.diffTable.setAlignmentX(0.0f);
        this.add(this.diffTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        Box box = new Box(1);
        JLabel jLabel = new JLabel("LEGEND");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        jLabel = new JLabel("Missing (present in Key but not in Response):  " + this.typeCounter[4]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[4]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Correct (total match):  " + this.typeCounter[1]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[1]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Partially correct (overlap in Key and Response):  " + this.typeCounter[2]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[2]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Spurious (present in Response but not in Key):  " + this.typeCounter[3]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[3]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("Precision strict: " + formatter.format(this.precisionStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Precision average: " + formatter.format(this.precisionAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Precision lenient: " + formatter.format(this.precisionLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("Recall strict: " + formatter.format(this.recallStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Recall average: " + formatter.format(this.recallAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Recall lenient: " + formatter.format(this.recallLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("F-Measure strict: " + formatter.format(this.fMeasureStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("F-Measure average: " + formatter.format(this.fMeasureAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("F-Measure lenient: " + formatter.format(this.fMeasureLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("False positive strict: " + formatter.format(this.falsePositiveStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("False positive average: " + formatter.format(this.falsePositiveAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("False positive lenient: " + formatter.format(this.falsePositiveLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(jPanel);
    }

    protected void printStructure(Set set) {
        Iterator iterator = set.iterator();
        String string = null;
        String string2 = null;
        while (iterator.hasNext()) {
            DiffSetElement diffSetElement = (DiffSetElement)iterator.next();
            string = diffSetElement.getLeftAnnotation() == null ? "NULL " : diffSetElement.getLeftAnnotation().toString();
            string2 = diffSetElement.getRightAnnotation() == null ? " NULL" : diffSetElement.getRightAnnotation().toString();
            Out.prln(string + "|" + string2);
        }
    }

    protected void doDiff(List list, List list2) {
        double d;
        Serializable serializable;
        Object object;
        Iterator iterator;
        Object object2;
        if (list == null || list2 == null) {
            return;
        }
        int n = list2.size();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            object2 = (Annotation)iterator2.next();
            iterator = list2.iterator();
            object = null;
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (object2.isPartiallyCompatible(annotation, this.keyFeatureNamesSet)) {
                    this.keyPartiallySet.add(object2);
                    this.responsePartiallySet.add(annotation);
                    if (object2.coextensive(annotation)) {
                        object = new DiffSetElement((Annotation)object2, annotation, 0, 1, this.keyDocument, this.responseDocument);
                        this.addToDiffset((DiffSetElement)object);
                    }
                } else if (object2.coextensive(annotation)) {
                    object = new DiffSetElement((Annotation)object2, annotation, this.detectKeyType((Annotation)object2), this.detectResponseType(annotation), this.keyDocument, this.responseDocument);
                    this.addToDiffset((DiffSetElement)object);
                }
                if (object == null) continue;
                iterator.remove();
                break;
            }
            if (object == null) {
                if (this.keyPartiallySet.contains(object2)) {
                    object = new DiffSetElement((Annotation)object2, null, 0, -1, this.keyDocument, this.responseDocument);
                } else {
                    for (DiffSetElement diffSetElement : this.diffSet) {
                        serializable = diffSetElement.getRightAnnotation();
                        if (serializable == null || !object2.isPartiallyCompatible((Annotation)serializable, this.keyFeatureNamesSet)) continue;
                        object = new DiffSetElement((Annotation)object2, null, 0, -1, this.keyDocument, this.responseDocument);
                        break;
                    }
                    if (object == null) {
                        object = new DiffSetElement((Annotation)object2, null, 4, -1, this.keyDocument, this.responseDocument);
                    }
                }
                this.addToDiffset((DiffSetElement)object);
            }
            iterator2.remove();
        }
        object2 = null;
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (Annotation)iterator.next();
            object2 = this.responsePartiallySet.contains(object) ? new DiffSetElement(null, (Annotation)object, -1, 2, this.keyDocument, this.responseDocument) : new DiffSetElement(null, (Annotation)object, -1, 3, this.keyDocument, this.responseDocument);
            this.addToDiffset((DiffSetElement)object2);
            iterator.remove();
        }
        int n2 = this.typeCounter[1] + this.typeCounter[2] + this.typeCounter[4];
        int n3 = this.typeCounter[1] + this.typeCounter[2] + this.typeCounter[3];
        if (n3 != 0) {
            this.precisionStrict = (double)this.typeCounter[1] / (double)n3;
            this.precisionLenient = (double)(this.typeCounter[1] + this.typeCounter[2]) / (double)n3;
            this.precisionAverage = (this.precisionStrict + this.precisionLenient) / 2.0;
        }
        if (n2 != 0) {
            this.recallStrict = (double)this.typeCounter[1] / (double)n2;
            this.recallLenient = (double)(this.typeCounter[1] + this.typeCounter[2]) / (double)n2;
            this.recallAverage = (this.recallStrict + this.recallLenient) / 2.0;
        }
        int n4 = 0;
        if (this.annotationTypeForFalsePositive != null) {
            if (this.responseAnnotationSetNameFalsePoz == null) {
                serializable = this.responseDocument.getAnnotations().get(this.annotationTypeForFalsePositive);
                n4 = serializable == null ? 0 : serializable.size();
            } else {
                serializable = this.responseDocument.getAnnotations(this.responseAnnotationSetNameFalsePoz).get(this.annotationTypeForFalsePositive);
                int n5 = n4 = serializable == null ? 0 : serializable.size();
            }
        }
        if (n4 != 0) {
            this.falsePositiveStrict = (double)(this.typeCounter[3] + this.typeCounter[2]) / (double)n4;
            this.falsePositiveLenient = (double)this.typeCounter[3] / (double)n4;
            this.falsePositiveAverage = (this.falsePositiveStrict + this.falsePositiveLenient) / 2.0;
        }
        this.fMeasureStrict = (d = weight * (this.precisionStrict + this.recallStrict)) != 0.0 ? this.precisionStrict * this.recallStrict / d : 0.0;
        d = weight * (this.precisionLenient + this.recallLenient);
        this.fMeasureLenient = d != 0.0 ? this.precisionLenient * this.recallLenient / d : 0.0;
        this.fMeasureAverage = (this.fMeasureStrict + this.fMeasureLenient) / 2.0;
    }

    private int detectKeyType(Annotation annotation) {
        if (annotation == null) {
            return -1;
        }
        if (this.keyPartiallySet.contains(annotation)) {
            return 0;
        }
        for (Annotation annotation2 : this.responsePartiallySet) {
            if (!annotation.isPartiallyCompatible(annotation2, this.keyFeatureNamesSet)) continue;
            return 0;
        }
        for (Annotation annotation2 : this.responseAnnotList) {
            if (!annotation.isPartiallyCompatible(annotation2, this.keyFeatureNamesSet)) continue;
            this.responsePartiallySet.add(annotation2);
            this.keyPartiallySet.add(annotation);
            return 0;
        }
        return 4;
    }

    private int detectResponseType(Annotation annotation) {
        if (annotation == null) {
            return -1;
        }
        if (this.responsePartiallySet.contains(annotation)) {
            return 2;
        }
        for (Annotation annotation2 : this.keyPartiallySet) {
            if (!annotation2.isPartiallyCompatible(annotation, this.keyFeatureNamesSet)) continue;
            return 2;
        }
        for (Annotation annotation2 : this.keyAnnotList) {
            if (!annotation2.isPartiallyCompatible(annotation, this.keyFeatureNamesSet)) continue;
            this.responsePartiallySet.add(annotation);
            this.keyPartiallySet.add(annotation2);
            return 2;
        }
        return 3;
    }

    private void addToDiffset(DiffSetElement diffSetElement) {
        if (diffSetElement == null) {
            return;
        }
        this.diffSet.add(diffSetElement);
        if (-1 != diffSetElement.getRightType()) {
            int n = diffSetElement.getRightType();
            this.typeCounter[n] = this.typeCounter[n] + 1;
        }
        if (-1 != diffSetElement.getLeftType() && 1 != diffSetElement.getLeftType()) {
            int n = diffSetElement.getLeftType();
            this.typeCounter[n] = this.typeCounter[n] + 1;
        }
    }

    protected class DiffSetElement {
        private Annotation leftAnnotation = null;
        private Annotation rightAnnotation = null;
        private int leftType = 0;
        private int rightType = 0;
        private Document keyDocument;
        private Document respDocument;

        public DiffSetElement() {
        }

        public DiffSetElement(Annotation annotation, Annotation annotation2, int n, int n2) {
            this.leftAnnotation = annotation;
            this.rightAnnotation = annotation2;
            this.leftType = n;
            this.rightType = n2;
            this.keyDocument = null;
            this.respDocument = null;
        }

        public DiffSetElement(Annotation annotation, Annotation annotation2, int n, int n2, Document document, Document document2) {
            this.leftAnnotation = annotation;
            this.rightAnnotation = annotation2;
            this.leftType = n;
            this.rightType = n2;
            this.keyDocument = document;
            this.respDocument = document2;
        }

        public void setLeftAnnotation(Annotation annotation) {
            this.leftAnnotation = annotation;
        }

        public Annotation getLeftAnnotation() {
            return this.leftAnnotation;
        }

        public void setRightAnnotation(Annotation annotation) {
            this.rightAnnotation = annotation;
        }

        public Annotation getRightAnnotation() {
            return this.rightAnnotation;
        }

        public void setLeftType(int n) {
            this.leftType = n;
        }

        public int getLeftType() {
            return this.leftType;
        }

        public void setRightType(int n) {
            this.rightType = n;
        }

        public int getRightType() {
            return this.rightType;
        }

        public Document getKeyDocument() {
            return this.keyDocument;
        }

        public void setKeyDocument(Document document) {
            this.keyDocument = document;
        }

        public Document getResponseDocument() {
            return this.respDocument;
        }

        public void setResponseDocument(Document document) {
            this.respDocument = document;
        }
    }

    class AnnotationSetComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (!(object instanceof Annotation) || !(object2 instanceof Annotation)) {
                return 0;
            }
            Annotation annotation = (Annotation)object;
            Annotation annotation2 = (Annotation)object2;
            Long l = annotation.getStartNode().getOffset();
            Long l2 = annotation2.getStartNode().getOffset();
            if (l != null) {
                return l.compareTo(l2);
            }
            return -1;
        }
    }

    public class AnnotationDiffCellRenderer
    extends DefaultTableCellRenderer {
        private Color background;
        private Color foreground;

        public AnnotationDiffCellRenderer() {
            this.background = CorpusAnnotationDiff.this.WHITE;
            this.foreground = CorpusAnnotationDiff.this.BLACK;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = null;
            jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 4 || object == null) {
                return new JPanel();
            }
            if (!(jTable.getModel().getValueAt(n, 10) instanceof DiffSetElement)) {
                return jComponent;
            }
            DiffSetElement diffSetElement = (DiffSetElement)jTable.getModel().getValueAt(n, 10);
            if (diffSetElement == null) {
                return jComponent;
            }
            if (n2 < 4) {
                if (-1 == diffSetElement.getLeftType()) return new JPanel();
                this.background = CorpusAnnotationDiff.this.colors[diffSetElement.getLeftType()];
            } else if (n2 < 10) {
                if (-1 == diffSetElement.getRightType()) return new JPanel();
                this.background = CorpusAnnotationDiff.this.colors[diffSetElement.getRightType()];
            }
            jComponent.setBackground(this.background);
            jComponent.setForeground(CorpusAnnotationDiff.this.BLACK);
            jComponent.setOpaque(true);
            return jComponent;
        }
    }

    protected class AnnotationDiffTableModel
    extends AbstractTableModel {
        private List modelData = new ArrayList();

        public AnnotationDiffTableModel(Collection collection) {
            this.modelData.addAll(collection);
        }

        public AnnotationDiffTableModel() {
        }

        public int getRowCount() {
            return this.modelData.size();
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "String - Key";
                }
                case 1: {
                    return "Start - Key";
                }
                case 2: {
                    return "End - Key";
                }
                case 3: {
                    return "Features - Key";
                }
                case 4: {
                    return "   ";
                }
                case 5: {
                    return "String - Response";
                }
                case 6: {
                    return "Start - Response";
                }
                case 7: {
                    return "End -Response";
                }
                case 8: {
                    return "Features - Response";
                }
                case 9: {
                    return "Document";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Long.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Long.class;
                }
                case 7: {
                    return Long.class;
                }
                case 8: {
                    return String.class;
                }
                case 9: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public Object getValueAt(int n, int n2) {
            DiffSetElement diffSetElement = (DiffSetElement)this.modelData.get(n);
            if (diffSetElement == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    Annotation annotation = diffSetElement.getLeftAnnotation();
                    String string = "";
                    try {
                        string = diffSetElement.getKeyDocument().getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        Err.prln(invalidOffsetException.getMessage());
                    }
                    return string;
                }
                case 1: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getStartNode().getOffset();
                }
                case 2: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getEndNode().getOffset();
                }
                case 3: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    if (diffSetElement.getLeftAnnotation().getFeatures() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getFeatures().toString();
                }
                case 4: {
                    return "   ";
                }
                case 5: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    Annotation annotation = diffSetElement.getRightAnnotation();
                    String string = "";
                    try {
                        string = diffSetElement.getResponseDocument().getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        Err.prln(invalidOffsetException.getMessage());
                    }
                    return string;
                }
                case 6: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getStartNode().getOffset();
                }
                case 7: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getEndNode().getOffset();
                }
                case 8: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getFeatures().toString();
                }
                case 9: {
                    return diffSetElement.getKeyDocument().getName();
                }
                case 10: {
                    return diffSetElement;
                }
            }
            return null;
        }

        public Object getRawObject(int n) {
            return this.modelData.get(n);
        }
    }
}

