/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.DataStore;
import gate.Gate;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStoreRegister
extends HashSet {
    private static final long serialVersionUID = 1L;
    private static Map configData = new HashMap();
    private static Map securityData = new HashMap();
    private transient Vector creoleListeners;

    public static Map<String, String> getDataStoreClassNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("gate.persist.SerialDataStore", "SerialDataStore: file-based storage using Java serialisation");
        hashMap.put("gate.persist.LuceneDataStoreImpl", "Lucene Based Searchable DataStore");
        try {
            if (Class.forName("gleam.docservice.gate.DocServiceDataStore", true, Gate.getClassLoader()) != null) {
                hashMap.put("gleam.docservice.gate.DocServiceDataStore", "SAFE DocService DataStore");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return hashMap;
    }

    @Override
    public boolean add(Object object) {
        return super.add(object);
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            this.fireDatastoreClosed(new CreoleEvent((DataStore)object, 5));
            DataStoreRegister.removeSecurityData((DataStore)object);
        }
        return bl;
    }

    @Override
    public void clear() {
        HashSet hashSet = new HashSet(this);
        super.clear();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.fireDatastoreClosed(new CreoleEvent((DataStore)iterator.next(), 5));
        }
    }

    public static Map getConfigData() {
        return configData;
    }

    public static void addConfig(Map map) {
        configData.putAll(map);
    }

    public static Map getSecurityData(DataStore dataStore) {
        return (Map)securityData.get(dataStore);
    }

    public static void addSecurityData(DataStore dataStore, Map map) {
        securityData.put(dataStore, map);
    }

    public static void removeSecurityData(DataStore dataStore) {
        securityData.remove(dataStore);
    }

    public synchronized void removeCreoleListener(CreoleListener creoleListener) {
        if (this.creoleListeners != null && this.creoleListeners.contains(creoleListener)) {
            Vector vector = (Vector)this.creoleListeners.clone();
            vector.removeElement(creoleListener);
            this.creoleListeners = vector;
        }
    }

    public synchronized void addCreoleListener(CreoleListener creoleListener) {
        Vector vector;
        Vector vector2 = vector = this.creoleListeners == null ? new Vector(2) : (Vector)this.creoleListeners.clone();
        if (!vector.contains(creoleListener)) {
            vector.addElement(creoleListener);
            this.creoleListeners = vector;
        }
    }

    protected void fireDatastoreOpened(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreOpened(creoleEvent);
            }
        }
    }

    protected void fireDatastoreCreated(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreCreated(creoleEvent);
            }
        }
    }

    protected void fireDatastoreClosed(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreClosed(creoleEvent);
            }
        }
    }
}

