/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security.filter;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;
import uk.ac.ebi.tsc.aap.client.exception.AAPLockedException;
import uk.ac.ebi.tsc.aap.client.exception.AAPUsernameNotFoundException;
import uk.ac.ebi.tsc.aap.client.model.ErrorResponse;
import uk.ac.ebi.tsc.aap.client.security.UserAuthentication;
import uk.ac.ebi.tsc.aap.client.security.audit.Action;
import uk.ac.ebi.tsc.aap.client.security.audit.Actor;
import uk.ac.ebi.tsc.aap.client.security.audit.SecurityLogger;
import uk.ac.ebi.tsc.aap.client.security.audit.Severity;
import uk.ac.ebi.tsc.aap.client.security.repo.GenericUserRepository;
import uk.ac.ebi.tsc.aap.client.security.util.SecurityUtil;

public abstract class AbstractReadFromRepositoryFilterBean
extends GenericFilterBean {
    public static final String ERROR_RESPONSE = "ERROR_RESPONSE";
    private static final String exceptionMsgAccountLocked = "Token-authenticated user %s has locked account";
    private static final String exceptionMsgUserNotFound = "Token-authenticated user %s not found in repository";
    private static final Logger logger = LoggerFactory.getLogger(AbstractReadFromRepositoryFilterBean.class);
    private final SecurityLogger securityLogger;
    private final GenericUserRepository userRepository;

    protected AbstractReadFromRepositoryFilterBean(SecurityLogger securityLogger, GenericUserRepository userRepository) {
        Assert.notNull((Object)securityLogger, (String)"Security Logger must not be null.");
        Assert.notNull((Object)userRepository, (String)"User Repository must not be null.");
        this.securityLogger = securityLogger;
        this.userRepository = userRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.trace("~doFilter() : Invoked by {} ", (Object)SecurityUtil.retrieveAuthenticatedName());
        Authentication authentication = SecurityUtil.retrieveAuthentication();
        if (authentication != null && authentication instanceof UserAuthentication) {
            ErrorResponse errorResponse = null;
            try {
                this.loadUserDetails(authentication);
            }
            catch (AAPLockedException lockedException) {
                errorResponse = new ErrorResponse();
                errorResponse.setError("ACCOUNT_LOCKED");
                errorResponse.setMessage(lockedException.getMessage());
                errorResponse.setException(((Object)((Object)lockedException)).getClass().getCanonicalName());
            }
            catch (AAPUsernameNotFoundException usernameNotFoundException) {
                errorResponse = new ErrorResponse();
                errorResponse.setError("USERNAME_NOT_FOUND");
                errorResponse.setMessage(usernameNotFoundException.getMessage());
                errorResponse.setException(((Object)((Object)usernameNotFoundException)).getClass().getCanonicalName());
            }
            finally {
                if (errorResponse != null) {
                    request.setAttribute(ERROR_RESPONSE, (Object)errorResponse);
                    SecurityUtil.nullifyAuthentication();
                }
            }
        } else {
            logger.trace("~doFilter() : Not reading user repo -- Authentication is {}", (Object)authentication);
        }
        chain.doFilter(request, response);
    }

    protected abstract void loadUserDetails(Authentication var1) throws AAPLockedException, AAPUsernameNotFoundException;

    protected SecurityLogger getSecurityLogger() {
        return this.securityLogger;
    }

    protected GenericUserRepository getUserRepository() {
        return this.userRepository;
    }

    private void logSecurity(String message, String identifier) {
        HashMap<String, Object> additionalData = new HashMap<String, Object>(1);
        additionalData.put("Activity", message);
        this.getSecurityLogger().logActionOnSelf(Severity.WARN, Action.INDETERMINABLE, Actor.USER, identifier, additionalData);
    }

    protected void logAndThrowAccountLocked(String userIdentifier) throws AAPLockedException {
        String message = String.format(exceptionMsgAccountLocked, userIdentifier);
        this.logSecurity(message, userIdentifier);
        throw new AAPLockedException(message);
    }

    protected void logAndThrowUsernameNotFound(String userIdentifier) throws AAPUsernameNotFoundException {
        String message = String.format(exceptionMsgUserNotFound, userIdentifier);
        this.logSecurity(message, userIdentifier);
        throw new AAPUsernameNotFoundException(message);
    }
}

