/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.security.audit;

import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import uk.ac.ebi.tsc.aap.client.security.audit.Action;
import uk.ac.ebi.tsc.aap.client.security.audit.Actor;
import uk.ac.ebi.tsc.aap.client.security.audit.SecurityLogger;
import uk.ac.ebi.tsc.aap.client.security.audit.Severity;

@Component
public class SimpleSecurityLogger
implements SecurityLogger {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSecurityLogger.class);
    private static final String fmtActOnOther = "[SECURITY_AUDIT] ".concat("Action: {} by {} [{}] on {} [{}] : {}");
    private static final String fmtActOnSelf = "[SECURITY_AUDIT] ".concat("Action: {} by {} [{}] on self : {}");

    @Override
    public void logAction(@NotNull Severity severity, @NotNull Action action, @NotNull Actor actionBy, @NotNull String actionById, Actor actionOn, String actionOnId, Map<String, Object> additionalData) {
        boolean actionOnSelf = true;
        if (!(actionOn == null || actionOnId == null || actionBy.compareTo(actionOn) == 0 && actionById.equals(actionOnId))) {
            actionOnSelf = false;
        }
        switch (severity) {
            case WARN: {
                if (!actionOnSelf) {
                    logger.warn(fmtActOnOther, new Object[]{action.toString(), actionBy.toString(), actionById, actionOn.toString(), actionOnId, this.convertWithStream(additionalData)});
                    break;
                }
                logger.warn(fmtActOnSelf, new Object[]{action.toString(), actionBy.toString(), actionById, this.convertWithStream(additionalData)});
                break;
            }
            case INFO: {
                if (!actionOnSelf) {
                    logger.info(fmtActOnOther, new Object[]{action.toString(), actionBy.toString(), actionById, actionOn.toString(), actionOnId, this.convertWithStream(additionalData)});
                    break;
                }
                logger.info(fmtActOnSelf, new Object[]{action.toString(), actionBy.toString(), actionById, this.convertWithStream(additionalData)});
                break;
            }
            case DEBUG: {
                if (!actionOnSelf) {
                    logger.debug(fmtActOnOther, new Object[]{action.toString(), actionBy.toString(), actionById, actionOn.toString(), actionOnId, this.convertWithStream(additionalData)});
                    break;
                }
                logger.debug(fmtActOnSelf, new Object[]{action.toString(), actionBy.toString(), actionById, this.convertWithStream(additionalData)});
                break;
            }
            case TRACE: {
                if (!actionOnSelf) {
                    logger.trace(fmtActOnOther, new Object[]{action.toString(), actionBy.toString(), actionById, actionOn.toString(), actionOnId, this.convertWithStream(additionalData)});
                    break;
                }
                logger.trace(fmtActOnSelf, new Object[]{action.toString(), actionBy.toString(), actionById, this.convertWithStream(additionalData)});
                break;
            }
            default: {
                logger.error("[SECURITY_AUDIT] ".concat("Error - Can't write Security Audit!!"));
            }
        }
    }

    @Override
    public void logActionOnSelf(Severity severity, Action action, Actor actionBy, String actionById, Map<String, Object> additionalData) {
        this.logAction(severity, action, actionBy, actionById, null, null, additionalData);
    }

    private String convertWithStream(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        String mapAsString = map.keySet().stream().map(key -> key + "=" + map.get(key)).collect(Collectors.joining(", ", "{", "}"));
        return mapAsString;
    }
}

