/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.BotFrameworkProperties;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.social.UserIdSource;
import org.springframework.social.borframework.service.BotService;
import org.springframework.social.borframework.service.impl.BotServiceImpl;
import org.springframework.social.botframework.api.BotFramework;
import org.springframework.social.botframework.api.proxy.BotFrameworkReConnectHandler;
import org.springframework.social.botframework.connect.BotFrameworkConnectionFactory;
import org.springframework.social.config.annotation.ConnectionFactoryConfigurer;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.UsersConnectionRepository;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, BotFrameworkConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.microsoft.skype", name={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class BotFrameworkAutoConfiguration {

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={BotFrameworkProperties.class})
    @ConditionalOnWebApplication
    protected static class BotFrameworkConfigurerAdapter
    extends SocialConfigurerAdapter {
        @Autowired
        private BotFrameworkProperties properties;

        protected BotFrameworkConfigurerAdapter() {
        }

        public void addConnectionFactories(ConnectionFactoryConfigurer connectionFactoryConfigurer, Environment environment) {
            connectionFactoryConfigurer.addConnectionFactory((ConnectionFactory)this.botFrameworkConnectionFactory());
        }

        public UserIdSource getUserIdSource() {
            return () -> this.properties.getAppId();
        }

        @Bean
        @ConditionalOnMissingBean(value={BotFramework.class})
        public BotFramework botFramework(ConnectionRepository repository, BotFrameworkConnectionFactory connectionFactory) {
            Class[] interfaces = new Class[]{BotFramework.class};
            return (BotFramework)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), interfaces, (InvocationHandler)new BotFrameworkReConnectHandler(repository, connectionFactory, this.properties.getScope()));
        }

        @Bean
        public ConnectionRepository connectionRepository(UsersConnectionRepository usersConnectionRepository) {
            return usersConnectionRepository.createConnectionRepository(this.getUserIdSource().getUserId());
        }

        @Bean
        public BotFrameworkConnectionFactory botFrameworkConnectionFactory() {
            return new BotFrameworkConnectionFactory(this.properties.getAppId(), this.properties.getAppSecret(), this.properties.getAuthUrl());
        }

        @Bean
        public BotService botService() {
            return new BotServiceImpl();
        }
    }
}

