/*
 * Decompiled with CFR 0.152.
 */
package ua.pl.mik.perspectivedrawer;

import android.view.animation.Interpolator;

public final class Interpolators {
    private static final float DOMAIN = 1.0f;
    private static final float DURATION = 1.0f;
    private static final float START = 0.0f;

    private Interpolators() {
    }

    public static final class Sine {
        public static final Interpolator EASE_IN = new Interpolator(){

            public float getInterpolation(float input) {
                return -1.0f * (float)Math.cos((double)(input / 1.0f) * 1.5707963267948966) + 1.0f + 0.0f;
            }
        };
        public static final Interpolator EASE_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                return 1.0f * (float)Math.sin((double)(input / 1.0f) * 1.5707963267948966) + 0.0f;
            }
        };
        public static final Interpolator EASE_IN_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                return -0.5f * ((float)Math.cos(Math.PI * (double)input / 1.0) - 1.0f) + 0.0f;
            }
        };

        private Sine() {
        }
    }

    public static final class Quint {
        public static final Interpolator EASE_IN = new Interpolator(){

            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input * input * input + 0.0f;
            }
        };
        public static final Interpolator EASE_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return 1.0f * (input * input * input * input * input + 1.0f) + 0.0f;
            }
        };
        public static final Interpolator EASE_IN_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input * input * input + 0.0f : 0.5f * ((input -= 2.0f) * input * input * input * input + 2.0f) + 0.0f;
            }
        };

        private Quint() {
        }
    }

    public static final class Quart {
        public static final Interpolator EASE_IN = new Interpolator(){

            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input * input + 0.0f;
            }
        };
        public static final Interpolator EASE_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return -1.0f * (input * input * input * input - 1.0f) + 0.0f;
            }
        };
        public static final Interpolator EASE_IN_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input * input + 0.0f : -0.5f * ((input -= 2.0f) * input * input * input - 2.0f) + 0.0f;
            }
        };

        private Quart() {
        }
    }

    public static final class Quad {
        public static final Interpolator EASE_IN = new Interpolator(){

            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input + 0.0f;
            }
        };
        public static final Interpolator EASE_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                return -1.0f * (input /= 1.0f) * (input - 2.0f) + 0.0f;
            }
        };
        public static final Interpolator EASE_IN_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input + 0.0f : -0.5f * ((input -= 1.0f) * (input - 2.0f) - 1.0f) + 0.0f;
            }
        };

        private Quad() {
        }
    }

    public static final class Cubic {
        public static final Interpolator EASE_IN = new Interpolator(){

            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input + 0.0f;
            }
        };
        public static final Interpolator EASE_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return 1.0f * (input * input * input + 1.0f) + 0.0f;
            }
        };
        public static final Interpolator EASE_IN_OUT = new Interpolator(){

            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input + 0.0f : 0.5f * ((input -= 2.0f) * input * input + 2.0f) + 0.0f;
            }
        };

        private Cubic() {
        }
    }

    public static final class Linear {
        public static final Interpolator EASE_NONE = new Interpolator(){

            public float getInterpolation(float input) {
                return input;
            }
        };

        private Linear() {
        }
    }
}

