/*
 * Decompiled with CFR 0.152.
 */
package tz.co.hosannahighertech.messagekit.messages;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import tz.co.hosannahighertech.messagekit.commons.models.IMessage;
import tz.co.hosannahighertech.messagekit.interfaces.OnMessageGestureListener;
import tz.co.hosannahighertech.messagekit.messages.MessagesListAdapter;
import tz.co.hosannahighertech.messagekit.messages.MessagesListStyle;
import tz.co.hosannahighertech.messagekit.messages.RecyclerScrollMoreListener;

public class MessagesList
extends RecyclerView {
    private MessagesListStyle messagesListStyle;

    public MessagesList(Context context) {
        super(context);
    }

    public MessagesList(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.parseStyle(context, attrs);
    }

    public MessagesList(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.parseStyle(context, attrs);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        throw new IllegalArgumentException("You can't set adapter to MessagesList. Use #setAdapter(MessagesListAdapter) instead.");
    }

    public <MESSAGE extends IMessage> void setAdapter(MessagesListAdapter<MESSAGE> adapter) {
        this.setAdapter(adapter, true);
    }

    public <MESSAGE extends IMessage> void setAdapter(final MessagesListAdapter<MESSAGE> adapter, final OnMessageGestureListener listener) {
        this.setAdapter(adapter, true);
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new ItemTouchHelper.SimpleCallback(0, 12){

            public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
                return false;
            }

            public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
                Object message = adapter.getMessageByIndex(viewHolder.getAdapterPosition());
                if (direction == 4) {
                    listener.onSwipeLeft((IMessage)message);
                } else if (direction == 8) {
                    listener.onSwipeRight((IMessage)message);
                }
                if (listener.isRestoreSwiped()) {
                    adapter.notifyDataSetChanged();
                } else {
                    adapter.delete(message);
                }
            }
        });
        itemTouchHelper.attachToRecyclerView((RecyclerView)this);
    }

    public <MESSAGE extends IMessage> void setAdapter(MessagesListAdapter<MESSAGE> adapter, boolean reverseLayout) {
        DefaultItemAnimator itemAnimator = new DefaultItemAnimator();
        itemAnimator.setSupportsChangeAnimations(false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, reverseLayout);
        this.setItemAnimator((RecyclerView.ItemAnimator)itemAnimator);
        this.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        adapter.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        adapter.setStyle(this.messagesListStyle);
        this.addOnScrollListener(new RecyclerScrollMoreListener(layoutManager, adapter));
        super.setAdapter(adapter);
    }

    private void parseStyle(Context context, AttributeSet attrs) {
        this.messagesListStyle = MessagesListStyle.parse(context, attrs);
    }
}

