/*
 * Decompiled with CFR 0.152.
 */
package tz.co.hosannahighertech.messagekit.messages;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Field;
import tz.co.hosannahighertech.messagekit.R;
import tz.co.hosannahighertech.messagekit.messages.MessageInputStyle;

public class MessageInput
extends RelativeLayout
implements View.OnClickListener,
TextWatcher,
View.OnFocusChangeListener {
    protected EditText messageInput;
    protected ImageButton messageSendButton;
    protected ImageButton attachmentButton;
    protected Space sendButtonSpace;
    protected Space attachmentButtonSpace;
    private CharSequence input;
    private InputListener inputListener;
    private AttachmentsListener attachmentsListener;
    private boolean isTyping;
    private TypingListener typingListener;
    private int delayTypingStatusMillis;
    private final Runnable typingTimerRunnable = new Runnable(){

        @Override
        public void run() {
            if (MessageInput.this.isTyping) {
                MessageInput.this.isTyping = false;
                if (MessageInput.this.typingListener != null) {
                    MessageInput.this.typingListener.onStopTyping();
                }
            }
        }
    };
    private boolean lastFocus;

    public MessageInput(Context context) {
        super(context);
        this.init(context);
    }

    public MessageInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MessageInput(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setInputListener(InputListener inputListener) {
        this.inputListener = inputListener;
    }

    public void setAttachmentsListener(AttachmentsListener attachmentsListener) {
        this.attachmentsListener = attachmentsListener;
    }

    public EditText getInputEditText() {
        return this.messageInput;
    }

    public ImageButton getButton() {
        return this.messageSendButton;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.messageSendButton) {
            boolean isSubmitted = this.onSubmit();
            if (isSubmitted) {
                this.messageInput.setText((CharSequence)"");
            }
            this.removeCallbacks(this.typingTimerRunnable);
            this.post(this.typingTimerRunnable);
        } else if (id2 == R.id.attachmentButton) {
            this.onAddAttachments();
        }
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.input = s;
        this.messageSendButton.setEnabled(this.input.length() > 0);
        if (s.length() > 0) {
            if (!this.isTyping) {
                this.isTyping = true;
                if (this.typingListener != null) {
                    this.typingListener.onStartTyping();
                }
            }
            this.removeCallbacks(this.typingTimerRunnable);
            this.postDelayed(this.typingTimerRunnable, this.delayTypingStatusMillis);
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (this.lastFocus && !hasFocus && this.typingListener != null) {
            this.typingListener.onStopTyping();
        }
        this.lastFocus = hasFocus;
    }

    private boolean onSubmit() {
        return this.inputListener != null && this.inputListener.onSubmit(this.input);
    }

    private void onAddAttachments() {
        if (this.attachmentsListener != null) {
            this.attachmentsListener.onAddAttachments();
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.init(context);
        MessageInputStyle style = MessageInputStyle.parse(context, attrs);
        this.messageInput.setMaxLines(style.getInputMaxLines());
        this.messageInput.setHint((CharSequence)style.getInputHint());
        this.messageInput.setText((CharSequence)style.getInputText());
        this.messageInput.setTextSize(0, (float)style.getInputTextSize());
        this.messageInput.setTextColor(style.getInputTextColor());
        this.messageInput.setHintTextColor(style.getInputHintColor());
        ViewCompat.setBackground((View)this.messageInput, (Drawable)style.getInputBackground());
        this.setCursor(style.getInputCursorDrawable());
        this.attachmentButton.setVisibility(style.showAttachmentButton() ? 0 : 8);
        this.attachmentButton.setImageDrawable(style.getAttachmentButtonIcon());
        this.attachmentButton.getLayoutParams().width = style.getAttachmentButtonWidth();
        this.attachmentButton.getLayoutParams().height = style.getAttachmentButtonHeight();
        ViewCompat.setBackground((View)this.attachmentButton, (Drawable)style.getAttachmentButtonBackground());
        this.attachmentButtonSpace.setVisibility(style.showAttachmentButton() ? 0 : 8);
        this.attachmentButtonSpace.getLayoutParams().width = style.getAttachmentButtonMargin();
        this.messageSendButton.setImageDrawable(style.getInputButtonIcon());
        this.messageSendButton.getLayoutParams().width = style.getInputButtonWidth();
        this.messageSendButton.getLayoutParams().height = style.getInputButtonHeight();
        ViewCompat.setBackground((View)this.messageSendButton, (Drawable)style.getInputButtonBackground());
        this.sendButtonSpace.getLayoutParams().width = style.getInputButtonMargin();
        if (this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
            this.setPadding(style.getInputDefaultPaddingLeft(), style.getInputDefaultPaddingTop(), style.getInputDefaultPaddingRight(), style.getInputDefaultPaddingBottom());
        }
        this.delayTypingStatusMillis = style.getDelayTypingStatus();
    }

    private void init(Context context) {
        MessageInput.inflate((Context)context, (int)R.layout.view_message_input, (ViewGroup)this);
        this.messageInput = (EditText)this.findViewById(R.id.messageInput);
        this.messageSendButton = (ImageButton)this.findViewById(R.id.messageSendButton);
        this.attachmentButton = (ImageButton)this.findViewById(R.id.attachmentButton);
        this.sendButtonSpace = (Space)this.findViewById(R.id.sendButtonSpace);
        this.attachmentButtonSpace = (Space)this.findViewById(R.id.attachmentButtonSpace);
        this.messageSendButton.setOnClickListener((View.OnClickListener)this);
        this.attachmentButton.setOnClickListener((View.OnClickListener)this);
        this.messageInput.addTextChangedListener((TextWatcher)this);
        this.messageInput.setText((CharSequence)"");
        this.messageInput.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    private void setCursor(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        try {
            Class drawableFieldClass;
            Object drawableFieldOwner;
            Field drawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            drawableResField.setAccessible(true);
            if (Build.VERSION.SDK_INT < 16) {
                drawableFieldOwner = this.messageInput;
                drawableFieldClass = TextView.class;
            } else {
                Field editorField = TextView.class.getDeclaredField("mEditor");
                editorField.setAccessible(true);
                drawableFieldOwner = editorField.get(this.messageInput);
                drawableFieldClass = drawableFieldOwner.getClass();
            }
            Field drawableField = drawableFieldClass.getDeclaredField("mCursorDrawable");
            drawableField.setAccessible(true);
            drawableField.set(drawableFieldOwner, new Drawable[]{drawable2, drawable2});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTypingListener(TypingListener typingListener) {
        this.typingListener = typingListener;
    }

    public static interface TypingListener {
        public void onStartTyping();

        public void onStopTyping();
    }

    public static interface InputListener {
        public boolean onSubmit(CharSequence var1);
    }

    public static interface AttachmentsListener {
        public void onAddAttachments();
    }
}

