/*
 * Decompiled with CFR 0.152.
 */
package tz.co.hosannahighertech.messagekit.dialogs;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import tz.co.hosannahighertech.messagekit.commons.models.IDialog;
import tz.co.hosannahighertech.messagekit.dialogs.DialogListStyle;
import tz.co.hosannahighertech.messagekit.dialogs.DialogsListAdapter;

public class DialogsList
extends RecyclerView {
    private DialogListStyle dialogStyle;

    public DialogsList(Context context) {
        super(context);
    }

    public DialogsList(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.parseStyle(context, attrs);
    }

    public DialogsList(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.parseStyle(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        LinearLayoutManager layout = new LinearLayoutManager(this.getContext(), 1, false);
        DefaultItemAnimator animator = new DefaultItemAnimator();
        this.setLayoutManager((RecyclerView.LayoutManager)layout);
        this.setItemAnimator((RecyclerView.ItemAnimator)animator);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        throw new IllegalArgumentException("You can't set adapter to DialogsList. Use #setAdapter(DialogsListAdapter) instead.");
    }

    public <DIALOG extends IDialog> void setAdapter(DialogsListAdapter<DIALOG> adapter) {
        this.setAdapter(adapter, false);
    }

    public <DIALOG extends IDialog> void setAdapter(DialogsListAdapter<DIALOG> adapter, boolean reverseLayout) {
        DefaultItemAnimator itemAnimator = new DefaultItemAnimator();
        itemAnimator.setSupportsChangeAnimations(false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, reverseLayout);
        this.setItemAnimator((RecyclerView.ItemAnimator)itemAnimator);
        this.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        adapter.setStyle(this.dialogStyle);
        super.setAdapter(adapter);
    }

    private void parseStyle(Context context, AttributeSet attrs) {
        this.dialogStyle = DialogListStyle.parse(context, attrs);
    }
}

