/*
 * Decompiled with CFR 0.152.
 */
package viewmodel;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import live.Live;
import logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import viewmodel.PlatformViewModel;
import viewmodel.ViewModelConfig;
import viewmodel.ViewModelCoreUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\b'\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\u00020\u001c*\u00020\t2\u0006\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\u00020\u0017*\u00020\t2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lviewmodel/ViewModel;", "I", "S", "Lviewmodel/PlatformViewModel;", "initialState", "config", "Lviewmodel/ViewModelConfig;", "(Ljava/lang/Object;Lviewmodel/ViewModelConfig;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "coroutineScope$delegate", "Lkotlin/Lazy;", "logger", "Llogging/Logger;", "getLogger", "()Llogging/Logger;", "ui", "Llive/Live;", "getUi", "()Llive/Live;", "onCleared", "", "post", "i", "(Ljava/lang/Object;)V", "execute", "", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Object;)Ljava/lang/Object;", "start", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Object;)V", "viewmodel-core_release"})
public abstract class ViewModel<I, S>
extends PlatformViewModel {
    @Nullable
    private final Logger logger;
    @NotNull
    private final Live<S> ui;
    @NotNull
    private final Lazy coroutineScope$delegate;

    @JvmOverloads
    public ViewModel(S initialState, @NotNull ViewModelConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.logger = config.getLogger();
        this.ui = new Live(initialState);
        this.coroutineScope$delegate = LazyKt.lazy(config.getScopeBuilder());
        this.ui.watch(new Function1<S, Unit>(){

            public final void invoke(S it) {
                Object s = it;
                ViewModelCoreUtilsKt.log(this, Intrinsics.stringPlus((String)"State at ", (Object)(s == null ? null : ViewModelCoreUtilsKt.getToDetailedString(s))));
            }
        });
    }

    public /* synthetic */ ViewModel(Object object, ViewModelConfig viewModelConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            viewModelConfig = ViewModelConfig.Companion.invoke$default(ViewModelConfig.Companion, null, null, 3, null);
        }
        this(object, viewModelConfig);
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Live<S> getUi() {
        return this.ui;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        Lazy lazy = this.coroutineScope$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (CoroutineScope)lazy.getValue();
    }

    public void post(I i) {
        ViewModelCoreUtilsKt.log(this, i);
        this.execute(this.getCoroutineScope(), i);
    }

    public void start(@NotNull CoroutineScope $this$start, I i) {
        Intrinsics.checkNotNullParameter((Object)$this$start, (String)"<this>");
        ViewModelCoreUtilsKt.log(this, i);
        this.execute($this$start, i);
    }

    @NotNull
    protected abstract Object execute(@NotNull CoroutineScope var1, I var2);

    @Override
    protected void onCleared() {
        this.ui.stopAll();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.getCoroutineScope(), null, (int)1, null);
    }

    @JvmOverloads
    public ViewModel(S initialState) {
        this(initialState, null, 2, null);
    }
}

