/*
 * Decompiled with CFR 0.152.
 */
package expect;

import expect.BasicExpectation;
import expect.CollectionExpectation;
import expect.LambdaExpectation;
import expect.internal.BasicExpectationImpl;
import expect.internal.CollectionExpectationImpl;
import expect.internal.LambdaExpectationImpl;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\u0007J-\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\b\"\u0004\b\u0000\u0010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\t\"\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\b\"\u0004\b\u0000\u0010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0007\u00a2\u0006\u0002\u0010\nJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\b\"\u0004\b\u0000\u0010\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lexpect/ExpectBuilders;", "", "()V", "expect", "Lexpect/BasicExpectation;", "E", "value", "(Ljava/lang/Object;)Lexpect/BasicExpectation;", "Lexpect/CollectionExpectation;", "", "([Ljava/lang/Object;)Lexpect/CollectionExpectation;", "expectArray", "array", "expectCollection", "collection", "", "expectFunction", "Lexpect/LambdaExpectation;", "lambda", "Ljava/lang/Runnable;", "expect-core"})
public final class ExpectBuilders {
    @NotNull
    public static final ExpectBuilders INSTANCE = new ExpectBuilders();

    private ExpectBuilders() {
    }

    @JvmStatic
    @NotNull
    public static final <E> BasicExpectation<E> expect(E value) {
        return new BasicExpectationImpl<E>(value);
    }

    @JvmStatic
    @NotNull
    public static final <E> CollectionExpectation<E> expect(E ... value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new CollectionExpectationImpl(ArraysKt.asList((Object[])value));
    }

    @JvmStatic
    @NotNull
    public static final <E> CollectionExpectation<E> expectArray(@NotNull E[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return ExpectBuilders.expect(Arrays.copyOf(array, array.length));
    }

    @JvmStatic
    @NotNull
    public static final <E> CollectionExpectation<E> expectCollection(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new CollectionExpectationImpl<E>(collection);
    }

    @JvmStatic
    @NotNull
    public static final LambdaExpectation expectFunction(@NotNull Runnable lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return new LambdaExpectationImpl((Function0<Unit>)((Function0)new Function0<Unit>((Object)lambda){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }));
    }
}

