/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool.HttpStack;

import com.android.volley.AuthFailureError;
import com.android.volley.Header;
import com.android.volley.Request;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3Stack
extends BaseHttpStack {
    public HttpResponse executeRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        int timeoutMs = request.getTimeoutMs();
        clientBuilder.connectTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        clientBuilder.readTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        clientBuilder.writeTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        okHttpRequestBuilder.url(request.getUrl());
        Map headers = request.getHeaders();
        for (String name : headers.keySet()) {
            okHttpRequestBuilder.addHeader(name, (String)headers.get(name));
        }
        for (String name : additionalHeaders.keySet()) {
            okHttpRequestBuilder.addHeader(name, additionalHeaders.get(name));
        }
        OkHttp3Stack.setConnectionParametersForRequest(okHttpRequestBuilder, request);
        OkHttpClient client = clientBuilder.build();
        okhttp3.Request okHttpRequest = okHttpRequestBuilder.build();
        Call okHttpCall = client.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        int code = okHttpResponse.code();
        ResponseBody body = okHttpResponse.body();
        InputStream content = body == null ? null : body.byteStream();
        int contentLength = body == null ? 0 : (int)body.contentLength();
        List<Header> responseHeaders = this.mapHeaders(okHttpResponse.headers());
        return new HttpResponse(code, responseHeaders, contentLength, content);
    }

    private List<Header> mapHeaders(Headers responseHeaders) {
        ArrayList<Header> headers = new ArrayList<Header>();
        int len = responseHeaders.size();
        for (int i = 0; i < len; ++i) {
            String name = responseHeaders.name(i);
            String value = responseHeaders.value(i);
            if (name == null) continue;
            headers.add(new Header(name, value));
        }
        return headers;
    }

    private static void setConnectionParametersForRequest(Request.Builder builder, Request<?> request) throws AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getBody();
                if (postBody == null) break;
                builder.post(RequestBody.create((MediaType)MediaType.parse((String)request.getBodyContentType()), (byte[])postBody));
                break;
            }
            case 0: {
                builder.get();
                break;
            }
            case 3: {
                builder.delete(OkHttp3Stack.createRequestBody(request));
                break;
            }
            case 1: {
                builder.post(OkHttp3Stack.createRequestBody(request));
                break;
            }
            case 2: {
                builder.put(OkHttp3Stack.createRequestBody(request));
                break;
            }
            case 4: {
                builder.head();
                break;
            }
            case 5: {
                builder.method("OPTIONS", null);
                break;
            }
            case 6: {
                builder.method("TRACE", null);
                break;
            }
            case 7: {
                builder.patch(OkHttp3Stack.createRequestBody(request));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static RequestBody createRequestBody(Request r) throws AuthFailureError {
        byte[] body = r.getBody();
        if (body == null) {
            return RequestBody.create(null, (byte[])new byte[0]);
        }
        return RequestBody.create((MediaType)MediaType.parse((String)r.getBodyContentType()), (byte[])body);
    }
}

