/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool;

import android.app.Activity;
import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListener;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListenerAdapter;
import tw.com.tp6gl4cj86.android_http_tool.Request.DataPart;
import tw.com.tp6gl4cj86.android_http_tool.Request.VolleyMultipartRequest;
import tw.com.tp6gl4cj86.android_http_tool.VolleySingleton;

public class HttpTool {
    private static boolean isApplicationJson = false;
    private static HttpListenerAdapter mStaticHttpListenerAdapter;
    private static DefaultRetryPolicy retryPolicy;
    private static int initialTimeoutMs;
    private static int maxNumRetries;
    private static float backoffMultiplier;

    public static void setIsApplicationJson(boolean isApplicationJson) {
        HttpTool.isApplicationJson = isApplicationJson;
    }

    public static void setStaticHttpListenerAdapter(HttpListenerAdapter mStaticHttpListenerAdapter) {
        HttpTool.mStaticHttpListenerAdapter = mStaticHttpListenerAdapter;
    }

    public static void post(Context context, String url) {
        HttpTool.post(context, url, new HashMap<String, String>(), null);
    }

    public static void post(Context context, String url, Map<String, String> params) {
        HttpTool.post(context, url, params, null);
    }

    public static void post(Context context, String url, HttpListener httpListener) {
        HttpTool.post(context, url, new HashMap<String, String>(), httpListener);
    }

    public static void post(Context context, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(1, context, url, params, httpListener);
    }

    public static void post(Context context, String url, Map<String, String> header, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(1, context, url, header, params, httpListener);
    }

    public static void postWithFile(Context context, String url, Map<String, String> params, Map<String, DataPart> fileParams, HttpListener httpListener) {
        HttpTool.requestJSONWithFile(context, url, params, fileParams, httpListener);
    }

    public static void get(Context context, String url) {
        HttpTool.get(context, url, new HashMap<String, String>(), null);
    }

    public static void get(Context context, String url, Map<String, String> params) {
        HttpTool.get(context, url, params, null);
    }

    public static void get(Context context, String url, HttpListener httpListener) {
        HttpTool.get(context, url, new HashMap<String, String>(), httpListener);
    }

    public static void get(Context context, String url, Map<String, String> params, HttpListener httpListener) {
        url = url + "?Olis=Android";
        for (String s : params.keySet()) {
            url = url + "&" + s + "=" + params.get(s);
        }
        HttpTool.requestJSON(0, context, url, params, httpListener);
    }

    public static void getWithParmas(Context context, String url, HttpListener httpListener) {
        HttpTool.requestJSON(0, context, url, null, httpListener);
    }

    public static void requestJSON(int method, Context context, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(method, context, url, new HashMap<String, String>(), params, httpListener);
    }

    private static void requestJSON(int method, Context context, String url, final Map<String, String> header, final Map<String, String> params, HttpListener httpListener) {
        StringRequest request;
        WeakReference<Context> mWeakContext = new WeakReference<Context>(context);
        if (isApplicationJson) {
            request = new StringRequest(method, url, response -> HttpTool.httpToolOnSuccessResponse(mWeakContext, HttpTool.getSuccessLog(HttpTool.parseMethod(method) + " " + url, params, response), httpListener, response), HttpTool.getErrorListener(mWeakContext, httpListener, HttpTool.parseMethod(method) + " " + url, params)){

                protected Map<String, String> getParams() throws AuthFailureError {
                    return params != null ? params : super.getParams();
                }

                public Map<String, String> getHeaders() throws AuthFailureError {
                    return header != null ? header : super.getHeaders();
                }
            };
        } else {
            JSONObject paramsJson = new JSONObject();
            if (params != null) {
                for (Map.Entry<String, String> stringStringEntry : params.entrySet()) {
                    try {
                        paramsJson.put(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            request = new JsonObjectRequest(method, url, paramsJson, response -> HttpTool.httpToolOnSuccessResponse(mWeakContext, HttpTool.getSuccessLog(HttpTool.parseMethod(method) + " " + url, params, response.toString()), httpListener, response.toString()), HttpTool.getErrorListener(mWeakContext, httpListener, HttpTool.parseMethod(method) + " " + url, params));
        }
        if (mStaticHttpListenerAdapter != null) {
            mStaticHttpListenerAdapter.onStart();
        }
        if (httpListener != null) {
            httpListener.onStart();
        }
        request.setShouldCache(false);
        request.setRetryPolicy((RetryPolicy)HttpTool.getRetryPolicy());
        request.setTag((Object)HttpTool.getTagFromUrl(url));
        VolleySingleton.getInstance(context).addToRequestQueue(request);
    }

    public static void requestJSONWithFile(Context context, String url, final Map<String, String> params, final Map<String, DataPart> fileParams, HttpListener httpListener) {
        WeakReference<Context> mWeakContext = new WeakReference<Context>(context);
        VolleyMultipartRequest multipartRequest = new VolleyMultipartRequest(1, url, response -> {
            String responseStr = new String(response.data);
            HttpTool.httpToolOnSuccessResponse(mWeakContext, HttpTool.getSuccessLog("POST " + url, params, responseStr), httpListener, responseStr);
        }, HttpTool.getErrorListener(mWeakContext, httpListener, "POST " + url, params)){

            protected Map<String, String> getParams() {
                return params;
            }

            @Override
            protected Map<String, DataPart> getByteData() {
                return fileParams;
            }
        };
        if (mStaticHttpListenerAdapter != null) {
            mStaticHttpListenerAdapter.onStart();
        }
        if (httpListener != null) {
            httpListener.onStart();
        }
        multipartRequest.setShouldCache(false);
        multipartRequest.setRetryPolicy((RetryPolicy)HttpTool.getRetryPolicy());
        multipartRequest.setTag(HttpTool.getTagFromUrl(url));
        VolleySingleton.getInstance(context).addToRequestQueue(multipartRequest);
    }

    public static DataPart getDataPart(File file, String mimeType) throws IOException {
        return new DataPart(file.getAbsolutePath(), FileUtils.readFileToByteArray((File)file), mimeType);
    }

    private static String getSuccessLog(String url, Map<String, String> params, String response) {
        return "Url      : " + url + "\nParams   : " + HttpTool.parseParams(params) + "\nResponse : " + response;
    }

    private static void httpToolOnSuccessResponse(WeakReference<Context> mWeakContext, String log, HttpListener httpListener, String response) {
        if (response != null && (mWeakContext.get() == null || mWeakContext.get() instanceof Activity && !((Activity)mWeakContext.get()).isFinishing())) {
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onSuccess(response, log);
                try {
                    mStaticHttpListenerAdapter.onSuccess(new JSONObject(response), log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                mStaticHttpListenerAdapter.onFinished();
            }
            if (httpListener != null) {
                httpListener.onSuccess(response, log);
                try {
                    httpListener.onSuccess(new JSONObject(response), log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                httpListener.onFinished();
            }
        }
    }

    private static Response.ErrorListener getErrorListener(WeakReference<Context> mWeakContext, HttpListener httpListener, String url, Map<String, String> params) {
        return error -> HttpTool.httpToolOnErrorResponse(error, mWeakContext, httpListener, url, params);
    }

    private static void httpToolOnErrorResponse(VolleyError error, WeakReference<Context> mWeakContext, HttpListener httpListener, String url, Map<String, String> params) {
        if (mWeakContext.get() == null || mWeakContext.get() instanceof Activity && !((Activity)mWeakContext.get()).isFinishing()) {
            int statusCode = error != null && error.networkResponse != null ? error.networkResponse.statusCode : -1;
            String message = error != null ? error.getMessage() : "";
            String body = error != null && error.networkResponse != null && error.networkResponse.data != null ? new String(error.networkResponse.data) : "";
            String log = "Status Code   : " + statusCode;
            log = log + "\nUrl           : " + url;
            log = log + "\nParams        : " + HttpTool.parseParams(params);
            log = log + "\nError message : " + message;
            log = log + "\nError body    : " + body;
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onFailure(statusCode, body, log);
                mStaticHttpListenerAdapter.onFinished();
            }
            if (httpListener != null) {
                httpListener.onFailure(statusCode, body, log);
                httpListener.onFinished();
            }
        }
    }

    private static String parseMethod(int method) {
        switch (method) {
            default: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 2: {
                return "PUT";
            }
            case 7: {
                return "PATCH";
            }
            case 3: 
        }
        return "DELETE";
    }

    private static String parseParams(Map<String, String> params) {
        return params != null ? params.toString() : "";
    }

    public static void setRetryPolicy(int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        HttpTool.initialTimeoutMs = initialTimeoutMs;
        HttpTool.maxNumRetries = maxNumRetries;
        HttpTool.backoffMultiplier = backoffMultiplier;
        retryPolicy = new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier);
    }

    private static DefaultRetryPolicy getRetryPolicy() {
        if (retryPolicy == null) {
            retryPolicy = new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier);
        }
        return retryPolicy;
    }

    public static String getTagFromUrl(String url) {
        if (url.contains("?")) {
            return url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static void cancel(Context context, String tag) {
        VolleySingleton.getInstance(context).getRequestQueue().cancelAll((Object)tag);
    }

    static {
        retryPolicy = new DefaultRetryPolicy();
        initialTimeoutMs = 10000;
        maxNumRetries = 0;
        backoffMultiplier = 1.0f;
    }
}

