/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool.HttpStack;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.toolbox.HttpStack;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

public class OkHttpStack
implements HttpStack {
    private final OkHttpClient mClient;

    public OkHttpStack(OkHttpClient client) {
        this.mClient = client;
    }

    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        int timeoutMs = request.getTimeoutMs();
        OkHttpClient.Builder builder = this.mClient.newBuilder();
        builder.connectTimeout((long)timeoutMs, TimeUnit.MILLISECONDS).readTimeout((long)timeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        OkHttpClient client = builder.build();
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        okHttpRequestBuilder.url(request.getUrl());
        Map headers = request.getHeaders();
        for (String name : headers.keySet()) {
            okHttpRequestBuilder.addHeader(name, (String)headers.get(name));
        }
        for (String name : additionalHeaders.keySet()) {
            okHttpRequestBuilder.header(name, additionalHeaders.get(name));
        }
        OkHttpStack.setConnectionParametersForRequest(okHttpRequestBuilder, request);
        okhttp3.Request okHttpRequest = okHttpRequestBuilder.build();
        Call okHttpCall = client.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        BasicStatusLine responseStatus = new BasicStatusLine(OkHttpStack.parseProtocol(okHttpResponse.protocol()), okHttpResponse.code(), okHttpResponse.message());
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)responseStatus);
        response.setEntity(OkHttpStack.entityFromOkHttpResponse(okHttpResponse));
        Headers responseHeaders = okHttpResponse.headers();
        int len = responseHeaders.size();
        for (int i = 0; i < len; ++i) {
            String name = responseHeaders.name(i);
            String value = responseHeaders.value(i);
            if (name == null) continue;
            response.addHeader((Header)new BasicHeader(name, value));
        }
        return response;
    }

    private static HttpEntity entityFromOkHttpResponse(Response r) throws IOException {
        BasicHttpEntity entity = new BasicHttpEntity();
        ResponseBody body = r.body();
        entity.setContent(body.byteStream());
        entity.setContentLength(body.contentLength());
        entity.setContentEncoding(r.header("Content-Encoding"));
        if (body.contentType() != null) {
            entity.setContentType(body.contentType().type());
        }
        return entity;
    }

    private static void setConnectionParametersForRequest(Request.Builder builder, Request<?> request) throws IOException, AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody == null) break;
                builder.post(RequestBody.create((MediaType)MediaType.parse((String)request.getPostBodyContentType()), (byte[])postBody));
                break;
            }
            case 0: {
                builder.get();
                break;
            }
            case 3: {
                builder.delete();
                break;
            }
            case 1: {
                builder.post(OkHttpStack.createRequestBody(request));
                break;
            }
            case 2: {
                builder.put(OkHttpStack.createRequestBody(request));
                break;
            }
            case 4: {
                builder.head();
                break;
            }
            case 5: {
                builder.method("OPTIONS", null);
                break;
            }
            case 6: {
                builder.method("TRACE", null);
                break;
            }
            case 7: {
                builder.patch(OkHttpStack.createRequestBody(request));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static ProtocolVersion parseProtocol(Protocol p) {
        switch (p) {
            case HTTP_1_0: {
                return new ProtocolVersion("HTTP", 1, 0);
            }
            case HTTP_1_1: {
                return new ProtocolVersion("HTTP", 1, 1);
            }
            case SPDY_3: {
                return new ProtocolVersion("SPDY", 3, 1);
            }
            case HTTP_2: {
                return new ProtocolVersion("HTTP", 2, 0);
            }
        }
        throw new IllegalAccessError("Unkwown protocol");
    }

    private static RequestBody createRequestBody(Request r) throws AuthFailureError {
        byte[] body = r.getBody();
        if (body == null) {
            if (r.getMethod() == 1) {
                body = "".getBytes();
            } else {
                return null;
            }
        }
        return RequestBody.create((MediaType)MediaType.parse((String)r.getBodyContentType()), (byte[])body);
    }
}

